<?php
// Set headers to allow cross-origin requests
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Check if 'url' parameter is provided
if (!isset($_GET['url']) || empty($_GET['url'])) {
    http_response_code(400);
    echo json_encode(["message" => "Error: 'url' parameter is missing."]);
    exit;
}

$targetUrl = $_GET['url'];

// Ensure the URL is valid and is an API call we expect (security measure)
if (!filter_var($targetUrl, FILTER_VALIDATE_URL) || 
    !preg_match('/player_api\\.php/i', $targetUrl)) {
    http_response_code(400);
    echo json_encode(["message" => "Error: Invalid or restricted URL format."]);
    exit;
}

// Initialize cURL session
$ch = curl_init();

// Set cURL options
curl_setopt($ch, CURLOPT_URL, $targetUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the transfer as a string
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // For self-signed certificates (be cautious)
curl_setopt($ch, CURLOPT_TIMEOUT, 15); // Timeout in seconds

// Execute cURL request and get the response
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    http_response_code(503);
    echo json_encode(["message" => "Proxy Error: " . curl_error($ch)]);
    curl_close($ch);
    exit;
}

// Close cURL session
curl_close($ch);

// Output the response received from the target API
echo $response;
?>
