<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
    <title>OTT PLATFORM - Xtream IPTV Generator</title>
    <style>
        * { box-sizing: border-box; }
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #0f2027, #203a43, #2c5364);
            color: #fff;
            margin: 0;
            padding: 10px;
            text-align: center;
        }
        h1 { font-size: 20px; margin-bottom: 10px; }
        input, select {
            width: 100%;
            padding: 10px;
            margin: 5px auto;
            font-size: 14px;
            border-radius: 6px;
            border: none;
            background: rgba(255, 255, 255, 0.1);
            color: #fff;
            display: block;
        }
        button {
            padding: 10px;
            font-size: 14px;
            border: none;
            border-radius: 6px;
            background: #ff9800;
            color: #fff;
            cursor: pointer;
            margin: 5px;
            width: calc(50% - 10px);
        }
        .inline-input {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 5px;
            max-width: 420px;
            margin: 0 auto 5px;
        }
        .inline-input input { margin: 0; }
        .section-title {
            font-size: 14px;
            margin-top: 15px;
            text-decoration: underline;
            margin-bottom: 5px;
        }
        .display {
            background: rgba(255, 255, 255, 0.15);
            padding: 12px;
            border-radius: 8px;
            max-width: 400px;
            margin: 10px auto;
            font-size: 12px;
            white-space: pre-line;
            text-align: left;
        }
        .section-container {
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 10px;
            padding: 10px;
            margin-bottom: 10px;
        }
        .full-width-button {
            width: 100%;
            margin: 5px 0;
        }
        select {
            margin-bottom: 10px;
        }
        /* ৪টি বাটন এক লাইনে (All time single row) */
        .four-in-one-row {
            display: flex;
            justify-content: space-between;
            flex-wrap: nowrap; /* Ensures buttons stay on one line */
            margin-top: 5px;
        }
        .four-in-one-row button {
            flex: 1 1 22%; /* Adjusted width to fit 4 in a row */
            margin: 2px;
            min-width: 0; /* Allows shrinking on small screens */
            font-size: 13px; /* Smaller default font for these buttons */
            padding: 8px 4px; /* Smaller padding */
        }
        
        @media (max-width: 480px) {
            body { padding: 5px; }
            h1 { font-size: 18px; }
            /* General button style, excluding the small 4-in-one buttons */
            input, select, button:not(.four-in-one-row button) { font-size: 13px; padding: 8px; } 
            .section-title { font-size: 13px; margin-top: 10px; }
            .display { font-size: 11px; padding: 10px; }
            
            /* Mobile specific style for 4-in-one buttons */
            .four-in-one-row button { 
                flex: 1 1 22%; 
                font-size: 10px; /* Force very small font to fit long text */
                padding: 6px 2px;
            } 
        }
    </style>
</head>
<body>

    <h1>📡 🅾🆃🆃 🅿🅻🅰🆃🅵🅾🆁🅼 📡</h1>

    <div class="section-container">
        <div class="section-title">M3U/XUI প্লেলিস্ট দিয়ে কাজ করুন</div>
        <div class="inline-input">
            <input type="text" id="validityLinkInput" placeholder="M3U/XUI প্লেলিস্ট লিংক দিন" />
            <button onclick="pasteValidityClipboard()" style="width: 80px;">Paste</button>
        </div>
        <div class="four-in-one-row">
            <button onclick="generateFromLink()">Generate</button>
            <button onclick="checkConnectionStatusByLink()">স্ট্যাটাস চেক</button>
            <button onclick="checkValidityByLink()">মেয়াদ দেখুন</button>
            <button onclick="showExtendedDetailsByLink()">বিস্তারিত দেখুন</button>
        </div>
        </div>
    
    <div class="section-container">
        <div class="section-title">কাস্টম কোড দিয়ে কাজ করুন</div>
        <div class="inline-input">
            <input type="text" id="customCodeInput" placeholder="Custom Code দিন" />
            <button onclick="pasteCustomCode()" style="width: 80px;">Paste</button>
        </div>
        <select id="validitySelect">
            <option value="6">৬ ঘণ্টা</option> <option value="12">১২ ঘণ্টা</option>
            <option value="24">২৪ ঘন্টা</option>
            <option value="30">১ মাস</option>
            <option value="60">২ মাস</option>
            <option value="90">৩ মাস</option>
            <option value="180">৬ মাস</option>
            <option value="365">১২ মাস</option>
        </select>
            <select id="serverSelect">
            <option value="https://banglavu.top">BanglaVU</option>
            <option value="http://103.112.62.114:8080">BanglaVU SAMSUNG</option>
            <option value="https://ti.bdix.xyz">TITAN</option>
            <option value="https://ba.bdix.xyz">BAHUBALI</option>
            <option value="http://103.112.63.114:8080">LIFETV SAMSUNG</option>
            <option value="http://live.bdix.xyz:8080">DIGITAL TV-1</option>
            <option value="http://live.bdix.xyz:8080">DIGITAL TV-2</option>
            <option value="http://64.120.94.23:8080">DIGITAL SAMSUNG</option>
            <option value="http://ktv.im:8080">TIGER OTT</option>
            <option value="https://dm.bdix.xyz:8880">DHOOM</option>
            <option value="https://atv.bdix.xyz:8880">PUSPA</option>
            <option value="https://d.bdix.xyz">LIFE TV</option>
            <option value="http://xtv.ooo:8080">OPPLEX</option>
            <option value="http://ip24.cc:8880">GEO TV</option>
            <option value="http://ip96.uk:8080">FILEX TV</option>
            <option value="http://maxott.fun:80">ROLEX</option>
            <option value="http://hd9k.xyz">BOSTV</option>
            <option value="http://webhop.xyz:8080">STAR</option>
            <option value="http://webo.asia:80">B1G</option>
        </select>
        <select id="packageSelect">
            <option value=" BanglaVU" data-adult="no">Package Bangla view</option>
            <option value=" TI" data-adult="no">Package LTV-BDIX-1</option>
            <option value=" BAH" data-adult="no">Package LTV-BDIX-2</option>
            <option value=" D-BDIX-1" data-adult="no">Package D-Bdix 1</option>
            <option value=" D-BDIX-2" data-adult="no ">Package D-BDIX-2</option>
            <option value=" BOSTV" data-adult="yes">Package BOSTV</option>
            <option value=" OPPLEX" data-adult="yes">Package OPPLEX</option>
            <option value=" TIGER OTT" data-adult="yes">Package TIGER OTT</option>
            <option value=" GEO" data-adult="yes">Package GEO TV</option>
            <option value=" FILEX TV" data-adult="yes">Package FILEX TV</option>
            <option value=" ROLEX" data-adult="yes">Package Rolex</option>
            <option value=" STAR" data-adult="yes">Package STAR TV</option>
            <option value=" B1G" data-adult="yes">Package B1G</option>
            <option value=" DM" data-adult="no">Package DM</option>
            <option value=" ATV" data-adult="no">Package ATV</option>
            <option value=" CDN" data-adult="no">Package CDN</option>
            <option value=" TV" data-adult="no">Package Tv</option>
        </select>
        <div class="four-in-one-row">
            <button onclick="generateFromCustom()">Generate</button>
            <button onclick="checkConnectionStatus()">স্ট্যাটাস চেক</button> 
            <button onclick="checkValidityByCustom()">মেয়াদ দেখুন</button>
            <button onclick="showExtendedDetailsByCustom()">বিস্তারিত দেখুন</button>
        </div>
        </div>

    <div class="section-container">
        <div class="section-title">Xtream Code Details:</div>
        <div class="display" id="fullDetails">এখানে ডিটেইলস আসবে</div>
        <button onclick="copyFullDetails()" class="full-width-button">Copy All</button>
    </div>

<script>
    const bnMonths = ["জানুয়ারি", "ফেব্রুয়ারি", "মার্চ", "এপ্রিল", "মে", "জুন", "জুলাই", "আগস্ট", "সেপ্টেম্বর", "অক্টোবর", "নভেম্বর", "ডিসেম্বর"];

    function toBanglaNum(num) {
        const bnDigits = ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'];
        return String(num).split('').map(d => bnDigits[d] || d).join('');
    }

    // UNIX timestamp to local Bengali date format
    function fmtUnixToLocal(ts) {
        if (ts === null || ts === undefined || ts === '' || ts === '0' || ts === 0) return 'N/A';
        const n = Number(ts);
        if (isNaN(n)) return String(ts);
        const date = (n < 10000000000) ? new Date(n * 1000) : new Date(n);
        let d = toBanglaNum(String(date.getDate()).padStart(2, '0'));
        let mName = bnMonths[date.getMonth()];
        let y = toBanglaNum(date.getFullYear());
        let h = date.getHours();
        let min = toBanglaNum(String(date.getMinutes()).padStart(2, '0'));
        let ampm = h >= 12 ? 'PM' : 'AM';
        h = h % 12; h = h ? h : 12;
        h = toBanglaNum(h);
        return `${d}-${mName}-${y} ${h}:${min} ${ampm}`;
    }

    // Fetches the URL and returns structured response
    async function tryFetch(url, options) {
        try {
            const resp = await fetch(url, options);
            const text = await resp.text();
            let json;
            try { json = JSON.parse(text); } catch (e) { json = null; }
            return { ok: resp.ok, status: resp.status, text, json };
        } catch (err) {
            return { ok: false, error: err.message, status: 0 };
        }
    }

    /**
     * Now uses all 6 proxies for robust stream/count data fetching.
     */
    async function fetchStreamDataWithFallback(server, username, password, action) {
        const apiUrl = `${server.replace(/\/$/,'')}/player_api.php?username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}&action=${action}`;
        
        // Use all 6 priority routes. Prioritizing PHP and DIRECT because the response is massive 
        // and public proxies will be slow/fail. If they fail, we try public as a final attempt.
        const proxies = ['PHP_PROXY', 'DIRECT', 'CORS_ANYWHERE_DEMO', 'CODETABS', 'CORSPROXY', 'ALLORIGINS']; 

        for (const proxyType of proxies) {
            let fetchUrl = apiUrl;
            let fetchOptions = { method: 'GET' }; 
            
            if (proxyType === 'PHP_PROXY') {
                fetchUrl = `proxy.php?url=${encodeURIComponent(apiUrl)}`;
            } else if (proxyType === 'DIRECT') {
                fetchOptions = { method: 'GET', mode: 'cors' }; 
            } else if (proxyType === 'CORS_ANYWHERE_DEMO') { 
                fetchUrl = `https://cors-anywhere.herokuapp.com/${apiUrl}`;
            } else if (proxyType === 'CODETABS') { 
                fetchUrl = `https://api.codetabs.com/v1/proxy?quest=${encodeURIComponent(apiUrl)}`;
            } else if (proxyType === 'CORSPROXY') {
                fetchUrl = `https://corsproxy.io/?${encodeURIComponent(apiUrl)}`;
            } else if (proxyType === 'ALLORIGINS') {
                fetchUrl = `https://api.allorigins.win/raw?url=${encodeURIComponent(apiUrl)}`;
            }

            const res = await tryFetch(fetchUrl, fetchOptions);
            
            // Success condition for stream/vod/series calls is an array of data
            if (res.ok && Array.isArray(res.json)) return res.json; 
        }
        
        return []; // Return an empty array on total failure
    }

    /**
     * Proxy priority order changed as per user's request.
     * Removed CORS_ANYWHERE_DEMO and CODETABS.
     * New priority: PHP_PROXY, DIRECT, CORSPROXY, ALLORIGINS
     */
    async function fetchDataWithFallback(apiUrl) {
        const fullDetailsDiv = document.getElementById('fullDetails');
        let mainData = null;
        let finalResponseText = '';
        
        // **UPDATED PRIORITY ORDER AS REQUESTED:**
        const proxies = ['PHP_PROXY', 'DIRECT', 'CORSPROXY', 'ALLORIGINS']; 
        
        for (let i = 0; i < proxies.length; i++) {
            const proxyType = proxies[i];
            
            let displayProxyName = '';
            let fetchUrl = apiUrl;
            let fetchOptions = { method: 'GET' }; // Default options for proxies

            if (proxyType === 'PHP_PROXY') {
                displayProxyName = '১. নিজস্ব PHP Proxy (লোকাল সার্ভার)';
                fetchUrl = `proxy.php?url=${encodeURIComponent(apiUrl)}`;
            } else if (proxyType === 'DIRECT') {
                displayProxyName = '২. ডিরেক্ট (সর্বোচ্চ গতি)';
                fetchOptions = { method: 'GET', mode: 'cors' }; 
            } else if (proxyType === 'CORSPROXY') {
                displayProxyName = '৩. corsproxy.io (পাবলিক)';
                fetchUrl = `https://corsproxy.io/?${encodeURIComponent(apiUrl)}`;
            } else if (proxyType === 'ALLORIGINS') {
                displayProxyName = '৪. AllOrigins Proxy (ফলব্যাক)';
                fetchUrl = `https://api.allorigins.win/raw?url=${encodeURIComponent(apiUrl)}`;
            }
            
            fullDetailsDiv.innerHTML = `মেয়াদ যাচাই করা হচ্ছে... (চেষ্টা ${toBanglaNum(i + 1)}: ${displayProxyName}-এর মাধ্যমে)`; 

            const res = await tryFetch(fetchUrl, fetchOptions);
            
            if (res.json) {
                mainData = res.json;
                finalResponseText = res.text;
                // Check if we got valid user info or a specific message (auth failure)
                if (mainData.user_info || mainData.message) break; 
            } else if (res.text) {
                finalResponseText = res.text;
            } else if (res.error) {
                finalResponseText = res.error;
            }
        }
        
        // After all attempts, check result
        if (mainData) {
            if (mainData.user_info && mainData.user_info.auth === 1) {
                return { success: true, data: mainData };
            } else if (mainData.message) {
                return { success: false, error: `লগইন ব্যর্থ: ${mainData.message}` };
            } else {
                return { success: false, error: 'অজানা ত্রুটি। সার্ভার থেকে কোনো বৈধ তথ্য পাওয়া যায়নি।' };
            }
        } else {
            return { success: false, error: `সব পদ্ধতিতে যাচাই ব্যর্থ। শেষ রেসপন্স: ${finalResponseText.substring(0, 100)}...` };
        }
    }


    async function check18Plus(server, username, password) {
        try {
            // This check uses category counts, which is more reliable than stream counts
            const [liveCategories, vodCategories, seriesCategories] = await Promise.all([
                fetchStreamDataWithFallback(server, username, password, 'get_live_categories'),
                fetchStreamDataWithFallback(server, username, password, 'get_vod_categories'),
                fetchStreamDataWithFallback(server, username, password, 'get_series_categories'),
            ]);

            const allCategories = [...liveCategories, ...vodCategories, ...seriesCategories];
            
            const adultCategories = allCategories.filter(cat => 
                cat.category_name && (
                    cat.category_name.toLowerCase().includes('adult') ||
                    cat.category_name.toLowerCase().includes('18+') ||
                    cat.category_name.toLowerCase().includes('xxx')
                )
            );

            return adultCategories.length > 0;
        } catch (error) {
            return false;
        }
    }


    // Function to extract expiry info from API data 
    function extractExpiry(data) {
        const u = data.user_info || data.user || data;

        let expiryTimestamp = null;
        if (u) {
            if (u.exp_date !== undefined && u.exp_date !== null && u.exp_date !== '' && (u.exp_date !== '0' && u.exp_date !== 0)) {
                expiryTimestamp = Number(u.exp_date);
            }
        }
        return expiryTimestamp;
    }

    // Helper functions (kept as is)
    function smartParse(link) {
        if (!link || !link.trim()) return null;
        link = link.trim();

        try {
            if (link.startsWith('//')) link = 'http:' + link;
            if (!/^[a-zA-Z][a-zA-Z0-9+\-.]*:\/\//.test(link)) {
                link = 'http://' + link;
            }
            const u = new URL(link);

            const origin = u.origin;
            const path = u.pathname || '';
            const qs = u.searchParams;

            const playlistMatch = path.match(/\/playlist\/([^\/]+)\/([^\/]+)/i);
            if (playlistMatch) {
                return { url: origin, username: decodeURIComponent(playlistMatch[1]), password: decodeURIComponent(playlistMatch[2]) };
            }

            if (path.toLowerCase().includes('get.php') || path.toLowerCase().includes('player_api.php') || path.toLowerCase().includes('live')) {
                const uname = qs.get('username') || qs.get('user') || qs.get('u');
                const pass = qs.get('password') || qs.get('pass') || qs.get('p');
                if (uname && pass) {
                    return { url: origin, username: uname, password: pass };
                }
            }

            const qU = qs.get('username') || qs.get('user') || qs.get('u');
            const qP = qs.get('password') || qs.get('pass') || qs.get('p');
            if (qU && qP) {
                return { url: origin, username: qU, password: qP };
            }
            
            const loose = path.match(/\/([A-Za-z0-9\-_]+)\/([A-Za-z0-9\-_]+)(?:\/|$)/);
            if (loose) {
                const maybeUser = loose[1], maybePass = loose[2];
                if (maybeUser.length >= 3 && maybePass.length >= 3) {
                    return { url: origin, username: maybeUser, password: maybePass };
                }
            }

            return null;

        } catch (e) {
            console.error("Parse Error:", e);
            return null;
        }
    }
    function pasteValidityClipboard() {
        navigator.clipboard.readText().then(text => {
            document.getElementById('validityLinkInput').value = text;
        }).catch(() => alert("❌ Clipboard থেকে ডাটা নিতে পারিনি।"));
    }
    function pasteCustomCode() {
        navigator.clipboard.readText().then(text => {
            document.getElementById('customCodeInput').value = text;
        }).catch(() => alert("❌ Clipboard থেকে ডাটা নিতে পারিনি।"));
    }
    function showDetails(username, password, url, expiry, packageName, expiryText, isAdult) {
        const adultContent = isAdult ? 'হ্যাঁ' : 'না';
        const result = `📡 আপনার Xtream IPTV কানেকশন ডিটেইলস (Login Info)🎬
📌 নাম= ott
👤 ইউজারনেম= ${username}
🔑 পাসওয়ার্ড= ${password}
🌐 সার্ভার= ${url}
    
⚠ লগইন করার পূর্বে অবশ্যই সব তথ্য সঠিকভাবে মিলিয়ে নিন।
✅ সেভ দেওয়ার আগে আমাদেরকে ১টি ছবি তুলে পাঠিয়ে দিন 

সার্ভিস সংক্রান্ত সকল আপডেট নিউজ পেতে আমাদের গ্রুপে জয়েন হয়ে থাকুন 
https://whatsapp.com/channel/0029VaiF68OKLaHimVWjxm00
      
https://chat.whatsapp.com/JilKFf92ZoxFWaelYyKwr1?mode=ac_t

📦 Package: ${packageName}
🔞 ১৮+ কন্টেন্ট: ${adultContent}
📅 পরবর্তীতে আটো রিনিউ করতে = https://bdix.xyz/iptv
📅 Validity: ${expiryText}
🕓 Expiry Date: ${fmtUnixToLocal(expiry)}`; 
        document.getElementById('fullDetails').innerText = result;
    }

    // 🔥🔥 আপডেট করা ফাংশন: ঘন্টা/মাস ভিত্তিক গণনা 
    function formatExpiryDate(validityNum) {
        const start = new Date();
        let expiry = new Date(start);
        
        const num = Number(validityNum);
        
        // ঘণ্টা ভিত্তিক ভ্যালিডিটি (24 বা তার কম)
        if (num <= 24) {
            expiry.setHours(expiry.getHours() + num);
        } 
        // দিন/মাস ভিত্তিক ভ্যালিডিটি (30, 60, 90, 180, 365)
        else if ([30, 60, 90, 180, 365].includes(num)) {
            const months = num === 365 ? 12 : num / 30;
            expiry.setMonth(expiry.getMonth() + months);
        } else {
             // অন্য কোনো দিন ভিত্তিক হলে 
             expiry.setDate(expiry.getDate() + num);
        }
        return expiry; 
    }
    
    // 🔥🔥 আপডেট করা ফাংশন: মেয়াদ টেক্সট দেখানো
    function getExpiryText(validityNum) {
        const num = Number(validityNum);
        if (num < 30) {
            // 24, 12, 6 ঘন্টা
            return `${toBanglaNum(num)} ঘণ্টা`;
        } else if ([30, 60, 90, 180, 365].includes(num)) {
            const months = num === 365 ? 12 : num / 30;
            const expiryDate = formatExpiryDate(num); // নতুন ফাংশন ব্যবহার
            const today = new Date();
            const days = Math.floor((expiryDate - today) / (1000 * 60 * 60 * 24));
            const daysLeft = days > 0 ? days : 0; 
            return `${toBanglaNum(months)} মাস (~${toBanglaNum(daysLeft)} দিন)`;
        } else {
            return `${toBanglaNum(num)} দিন`;
        }
    }


    // --- M3U/XUI Link Section ---

    function generateFromLink() {
        const link = document.getElementById('validityLinkInput').value.trim();
        const packageSelect = document.getElementById('packageSelect');
        const packageName = packageSelect.options[packageSelect.selectedIndex].value;
        const isAdult = packageSelect.options[packageSelect.selectedIndex].getAttribute('data-adult') === 'yes';
        const validityRaw = parseInt(document.getElementById('validitySelect').value);

        if (!link) {
            alert("❌ অনুগ্রহ করে একটি M3U/XUI লিংক দিন।");
            return;
        }

        const parsed = smartParse(link);
        if (!parsed) return alert("❌ লিংক সঠিক নয়।");

        // 🔥🔥 আপডেট করা ফাংশন ব্যবহার
        const expiryDate = formatExpiryDate(validityRaw); 
        const expiryText = getExpiryText(validityRaw);
        
        showDetails(parsed.username, parsed.password, parsed.url, expiryDate.getTime(), packageName, expiryText, isAdult);
    }

    async function checkValidityByLink() {
        const playlistURL = document.getElementById('validityLinkInput').value.trim();
        const fullDetailsDiv = document.getElementById('fullDetails');
        
        if (!playlistURL) {
            fullDetailsDiv.innerHTML = '<span style="color:red;">দয়া করে একটি M3U/XUI লিংক দিন।</span>';
            return;
        }

        const parsed = smartParse(playlistURL);
        if (!parsed) {
            fullDetailsDiv.innerHTML = '<span style="color:red;">লিঙ্কটি সঠিক ফরম্যাটে নেই।</span>';
            return;
        }
        
        const server = parsed.url;
        const username = parsed.username;
        const password = parsed.password;

        const apiUrl = `${server.replace(/\/$/,'')}/player_api.php?username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}&action=get_profile`;
        
        const fetchResult = await fetchDataWithFallback(apiUrl);

        if (fetchResult.success) {
            const data = fetchResult.data;
            const userInfo = data.user_info;
            const packageSelect = document.getElementById('packageSelect');
            const packageName = packageSelect.options[packageSelect.selectedIndex].value;
            const isAdult = await check18Plus(server, username, password);
            
            const expiryTimestamp = extractExpiry(data);
            const maxConnections = userInfo.max_connections !== undefined ? userInfo.max_connections : 'N/A';
            const statusText = userInfo.status || 'Active'; // Added Status

            let timeLeftText;
            let expiryDateText;

            if (expiryTimestamp) {
                const currentDate = Date.now() / 1000;
                const timeLeftInSeconds = expiryTimestamp - currentDate;
                expiryDateText = fmtUnixToLocal(expiryTimestamp);

                if (timeLeftInSeconds <= 0) {
                    timeLeftText = 'মেয়াদ শেষ হয়ে গেছে';
                } else if (timeLeftInSeconds < 86400) {
                    const hoursLeft = Math.ceil(timeLeftInSeconds / 3600);
                    timeLeftText = `${toBanglaNum(hoursLeft)} ঘণ্টা`;
                } else {
                    const daysLeft = Math.ceil(timeLeftInSeconds / 86400);
                    timeLeftText = `${toBanglaNum(daysLeft)} দিন`;
                }
            } else {
                timeLeftText = 'N/A (মেয়াদ তথ্য পাওয়া যায়নি)';
                expiryDateText = 'N/A (মেয়াদ তথ্য পাওয়া যায়নি)';
            }
            
            const resultText = `
                📡 আপনার Xtream IPTV কানেকশন ডিটেইলস (Login Info)🎬
                
                📌 নাম= ott
                👤 ইউজারনেম= ${username}
                🔑 পাসওয়ার্ড= ${password}
                🌐 সার্ভার= ${server}
                
✅ সেভ দেওয়ার আগে আমাদেরকে ১টি ছবি তুলে পাঠিয়ে দিন 

সার্ভিস সংক্রান্ত সকল আপডেট নিউজ পেতে আমাদের গ্রুপে জয়েন হয়ে থাকুন 
https://whatsapp.com/channel/0029VaiF68OKLaHimVWjxm00
      
https://chat.whatsapp.com/JilKFf92ZoxFWaelYyKwr1?mode=ac_t

                ✅ অবস্থা: ${statusText}
                📦 Package: ${packageName}
                🔞 18+ প্যাকেজ: ${isAdult ? 'হ্যাঁ' : 'না'}
                🔗 সর্বোচ্চ কানেকশন: ${toBanglaNum(maxConnections)} টি
                📅 পরবর্তীতে আটো রিনিউ করতে = https://bdix.xyz/iptv
                📅 মেয়াদ শেষ হবে: ${expiryDateText}
                📅 আর বাকি: ${timeLeftText}
                `;
            fullDetailsDiv.innerHTML = resultText;
        } else {
            fullDetailsDiv.innerHTML = `<span style="color:red;">${fetchResult.error}</span>`;
        }
    }

    async function showExtendedDetailsByLink() {
        const playlistURL = document.getElementById('validityLinkInput').value.trim();
        const fullDetailsDiv = document.getElementById('fullDetails');
        
        if (!playlistURL) {
            fullDetailsDiv.innerHTML = '<span style="color:red;">দয়া করে একটি বৈধ ইউআরএল দিন।</span>';
            return;
        }

        const parsed = smartParse(playlistURL);
        if (!parsed) {
            fullDetailsDiv.innerHTML = '<span style="color:red;">লিঙ্কটি সঠিক ফরম্যাটে নেই।</span>';
            return;
        }

        const server = parsed.url;
        const username = parsed.username;
        const password = parsed.password;

        const apiUrl = `${server.replace(/\/$/,'')}/player_api.php?username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}&action=get_profile`;
        
        fullDetailsDiv.innerHTML = 'বিস্তারিত তথ্য লোড করা হচ্ছে...<br>প্রথমে ইউজার প্রোফাইল যাচাই করা হচ্ছে...';
        const fetchResult = await fetchDataWithFallback(apiUrl);

        if (!fetchResult.success) {
            fullDetailsDiv.innerHTML = `<span style="color:red;">${fetchResult.error}</span>`;
            return;
        }

        const mainData = fetchResult.data;
        const userInfo = mainData.user_info;

        fullDetailsDiv.innerHTML = 'বিস্তারিত তথ্য লোড করা হচ্ছে...<br>চ্যানেল ও মুভি কাউন্ট যাচাই করা হচ্ছে... (এখন সব রুট দিয়ে চেষ্টা করা হবে)';

        // These three calls now use the streamlined fetchStreamDataWithFallback (PHP Proxy + All Fallbacks)
        const [liveResponse, moviesResponse, seriesResponse] = await Promise.all([
            fetchStreamDataWithFallback(server, username, password, 'get_live_streams'),
            fetchStreamDataWithFallback(server, username, password, 'get_vod_streams'),
            fetchStreamDataWithFallback(server, username, password, 'get_series'),
        ]);

        const packageSelect = document.getElementById('packageSelect');
        const packageName = packageSelect.options[packageSelect.selectedIndex].value;
        const isAdult = await check18Plus(server, username, password);

        const expiryTimestamp = extractExpiry(mainData);
        const maxConnections = userInfo.max_connections !== undefined ? userInfo.max_connections : 'N/A';
        const statusText = userInfo.status || 'Active'; // Added Status
        
        let timeLeftText;
        let expiryDateText;

        if (expiryTimestamp) {
            const currentDate = Date.now() / 1000;
            const timeLeftInSeconds = expiryTimestamp - currentDate;
            expiryDateText = fmtUnixToLocal(expiryTimestamp);

            if (timeLeftInSeconds <= 0) {
                timeLeftText = 'মেয়াদ শেষ হয়ে গেছে';
            } else if (timeLeftInSeconds < 86400) {
                const hoursLeft = Math.ceil(timeLeftInSeconds / 3600);
                timeLeftText = `${toBanglaNum(hoursLeft)} ঘণ্টা`;
            } else {
                const daysLeft = Math.ceil(timeLeftInSeconds / 86400);
                timeLeftText = `${toBanglaNum(daysLeft)} দিন`;
            }
        } else {
            timeLeftText = 'N/A (মেয়াদ তথ্য পাওয়া যায়নি)';
            expiryDateText = 'N/A (মেয়াদ তথ্য পাওয়া যায়নি)';
        }
        
        const liveCount = Array.isArray(liveResponse) ? toBanglaNum(liveResponse.length) : 'নেই';
        const moviesCount = Array.isArray(moviesResponse) ? toBanglaNum(moviesResponse.length) : 'নেই';
        const seriesCount = Array.isArray(seriesResponse) ? toBanglaNum(seriesResponse.length) : 'নেই';
        
        const resultText = `
            📡 আপনার Xtream IPTV কানেকশন ডিটেইলস (Login Info)🎬
            
            📌 নাম= ott
            👤 ইউজারনেম= ${username}
            🔑 পাসওয়ার্ড= ${password}
            🌐 সার্ভার= ${server}
            
✅ সেভ দেওয়ার আগে আমাদেরকে ১টি ছবি তুলে পাঠিয়ে দিন 

সার্ভিস সংক্রান্ত সকল আপডেট নিউজ পেতে আমাদের গ্রুপে জয়েন হয়ে থাকুন 
https://whatsapp.com/channel/0029VaiF68OKLaHimVWjxm00
      
https://chat.whatsapp.com/JilKFf92ZoxFWaelYyKwr1?mode=ac_t

            ✅ অবস্থা: ${statusText}
            📦 Package: ${packageName}
            🔞 18+ প্যাকেজ: ${isAdult ? 'হ্যাঁ' : 'না'}
            🔗 সর্বোচ্চ কানেকশন: ${toBanglaNum(maxConnections)} টি
            📺 মোট চ্যানেল: ${liveCount} টি
            🎞️ মোট মুভি: ${moviesCount} টি
            🍿 মোট সিরিজ: ${seriesCount} টি
            📅 পরবর্তীতে আটো রিনিউ করতে = https://bdix.xyz/iptv
            📅 মেয়াদ শেষ হবে: ${expiryDateText}
            📅 আর বাকি: ${timeLeftText}
            `;
        fullDetailsDiv.innerHTML = resultText;
    }
    
    // নতুন ফাংশন: M3U/XUI Link-এর জন্য কানেকশন স্ট্যাটাস চেক করা
    async function checkConnectionStatusByLink() {
        const playlistURL = document.getElementById('validityLinkInput').value.trim();
        const fullDetailsDiv = document.getElementById('fullDetails');
        
        if (!playlistURL) {
            fullDetailsDiv.innerHTML = '<span style="color:red;">দয়া করে একটি M3U/XUI লিংক দিন।</span>';
            return;
        }

        const parsed = smartParse(playlistURL);
        if (!parsed) {
            fullDetailsDiv.innerHTML = '<span style="color:red;">লিঙ্কটি সঠিক ফরম্যাটে নেই।</span>';
            return;
        }
        
        const serverUrl = parsed.url;
        const username = parsed.username;
        const password = parsed.password;

        const apiUrl = `${serverUrl.replace(/\/$/,'')}/player_api.php?username=${encodeURIComponent(username)}&password=${encodeURIComponent(password)}&action=get_profile`;
        
        fullDetailsDiv.innerHTML = 'কানেকশন স্ট্যাটাস যাচাই করা হচ্ছে...';
        const fetchResult = await fetchDataWithFallback(apiUrl);

        if (!fetchResult.success) {
            fullDetailsDiv.innerHTML = `<span style="color:red;">${fetchResult.error}</span>`;
            return;
        }

        const mainData = fetchResult.data;
        const userInfo = mainData.user_info;

        const activeConnections = Number(userInfo.active_cons) || 0;
        const maxConnections = userInfo.max_connections !== undefined ? userInfo.max_connections : 'N/A';
        const activeSessions = userInfo.active_streams || [];
        const statusText = userInfo.status || 'Active'; // Added Status

        let sessionDetails = '';
        if (activeSessions.length > 0) {
            sessionDetails = '\n\n**🔴 বর্তমানে দেখছেন:**\n';
            activeSessions.forEach(session => {
                const startTimeSeconds = session.start_time;
                const currentTimeSeconds = Date.now() / 1000;
                
                let durationText = 'কিছু সময় ধরে';

                if (startTimeSeconds) {
                    const elapsedSeconds = Math.floor(currentTimeSeconds - startTimeSeconds);
                    
                    if (elapsedSeconds < 0) {
                        durationText = 'সময় গণনা করা যায়নি';
                    } else if (elapsedSeconds < 60) {
                        durationText = `${toBanglaNum(elapsedSeconds)} সেকেন্ড ধরে`;
                    } else {
                        const hours = Math.floor(elapsedSeconds / 3600);
                        const minutes = Math.floor((elapsedSeconds % 3600) / 60);

                        let parts = [];
                        if (hours > 0) parts.push(`${toBanglaNum(hours)} ঘণ্টা`);
                        if (minutes > 0) parts.push(`${toBanglaNum(minutes)} মিনিট`);
                        
                        durationText = parts.length > 0 ? parts.join(' ') + ' ধরে' : '১ মিনিটের কম সময় ধরে';
                    }
                }
                
                sessionDetails += `  - ${session.stream_name || 'অজানা কন্টেন্ট'} ( ${durationText} )\n`;
            });
        } else if (activeConnections > 0) {
            // যদি activeConnections > 0 হয়, কিন্তু activeSessions খালি থাকে
            sessionDetails = '\n**🔴 বর্তমানে দেখছেন:** সক্রিয় কানেকশন আছে, কিন্তু চ্যানেল বা কন্টেন্টের নাম দেখাচ্ছে না (API সীমাবদ্ধতা)।\n';
        } else {
            sessionDetails = '\n**🔴 বর্তমানে দেখছেন:** কেউ সক্রিয় নেই\n';
        }

        const expiryTimestamp = extractExpiry(mainData);
        let timeLeftText = 'N/A';
        let expiryDateText = 'N/A';
        
        if (expiryTimestamp) {
            const currentDate = Date.now() / 1000;
            const timeLeftInSeconds = expiryTimestamp - currentDate;
            expiryDateText = fmtUnixToLocal(expiryTimestamp);

            if (timeLeftInSeconds <= 0) {
                timeLeftText = 'মেয়াদ শেষ হয়ে গেছে';
            } else if (timeLeftInSeconds < 86400) {
                const hoursLeft = Math.ceil(timeLeftInSeconds / 3600);
                timeLeftText = `${toBanglaNum(hoursLeft)} ঘণ্টা`;
            } else {
                const daysLeft = Math.ceil(timeLeftInSeconds / 86400);
                timeLeftText = `${toBanglaNum(daysLeft)} দিন`;
            }
        }

        let warningNote = '';
        if (activeConnections > 0 && activeSessions.length === 0) {
            warningNote = `\n\n⚠️ **API নোট:** রানিং কানেকশন (${toBanglaNum(activeConnections)} টি) দেখালেও কন্টেন্টের নাম না দেখানোর কারণ হলো, আপনার Xtream সার্ভার 'player_api' এর মাধ্যমে এই বিস্তারিত ডেটা (active_streams) প্রদান করছে না। এটি সার্ভার-প্রান্তিক সীমাবদ্ধতা।`;
        }

        const resultText = `
            📡 আপনার Xtream IPTV কানেকশন স্ট্যাটাস 🎬
            
            📌 নাম= ott
            👤 ইউজারনেম= ${username}
            🌐 সার্ভার= ${serverUrl}
            
-----------------------------------------
            
            **📶 কানেকশন স্ট্যাটাস 📶**
            ✅ অবস্থা: ${statusText}
            🔴 রানিং কানেকশন: ${toBanglaNum(activeConnections)} টি
            🔗 সর্বোচ্চ কানেকশন: ${toBanglaNum(maxConnections)} টি
            
            ${sessionDetails}
            
            📅 মেয়াদ শেষ হবে: ${expiryDateText}
            📅 আর বাকি: ${timeLeftText}
            
            ${warningNote}
            `;
            
        fullDetailsDiv.innerHTML = resultText;
    }


    // --- Custom Code Section ---

    function generateFromCustom() {
        const custom = document.getElementById('customCodeInput').value.trim();
        const validityRaw = parseInt(document.getElementById('validitySelect').value);
        const packageSelect = document.getElementById('packageSelect');
        const packageName = packageSelect.options[packageSelect.selectedIndex].value;
        const serverUrl = document.getElementById('serverSelect').value;
        const isAdult = packageSelect.options[packageSelect.selectedIndex].getAttribute('data-adult') === 'yes';

        if (!custom) return alert("❌ Custom Code দিন।");
        
        // 🔥🔥 আপডেট করা ফাংশন ব্যবহার
        const expiryDate = formatExpiryDate(validityRaw);

        const expiryText = getExpiryText(validityRaw);
        showDetails(custom, custom, serverUrl, expiryDate.getTime(), packageName, expiryText, isAdult); 
    }

    async function checkValidityByCustom() {
        const customCode = document.getElementById('customCodeInput').value.trim();
        const serverUrl = document.getElementById('serverSelect').value;
        const fullDetailsDiv = document.getElementById('fullDetails');
        
        if (!customCode) {
            fullDetailsDiv.innerHTML = '<span style="color:red;">দয়া করে একটি বৈধ কাস্টম কোড দিন।</span>';
            return;
        }

        const apiUrl = `${serverUrl.replace(/\/$/,'')}/player_api.php?username=${encodeURIComponent(customCode)}&password=${encodeURIComponent(customCode)}&action=get_profile`;

        const fetchResult = await fetchDataWithFallback(apiUrl);
        
        if (fetchResult.success) {
            const data = fetchResult.data;
            const userInfo = data.user_info;
            const packageSelect = document.getElementById('packageSelect');
            const packageName = packageSelect.options[packageSelect.selectedIndex].value;
            const isAdult = await check18Plus(serverUrl, customCode, customCode);
            const maxConnections = userInfo.max_connections !== undefined ? userInfo.max_connections : 'N/A';
            const statusText = userInfo.status || 'Active'; // Added Status

            const expiryTimestamp = extractExpiry(data);
            
            let timeLeftText;
            let expiryDateText;

            if (expiryTimestamp) {
                const currentDate = Date.now() / 1000;
                const timeLeftInSeconds = expiryTimestamp - currentDate;
                expiryDateText = fmtUnixToLocal(expiryTimestamp);

                if (timeLeftInSeconds <= 0) {
                    timeLeftText = 'মেয়াদ শেষ হয়ে গেছে';
                } else if (timeLeftInSeconds < 86400) {
                    const hoursLeft = Math.ceil(timeLeftInSeconds / 3600);
                    timeLeftText = `${toBanglaNum(hoursLeft)} ঘণ্টা`;
                } else {
                    const daysLeft = Math.ceil(timeLeftInSeconds / 86400);
                    timeLeftText = `${toBanglaNum(daysLeft)} দিন`;
                }
            } else {
                timeLeftText = 'N/A (মেয়াদ তথ্য পাওয়া যায়নি)';
                expiryDateText = 'N/A (মেয়াদ তথ্য পাওয়া যায়নি)';
            }
            
            const resultText = `
                📡 আপনার Xtream IPTV কানেকশন ডিটেইলস (Login Info)🎬
                
                📌 নাম= ott
                👤 ইউজারনেম= ${customCode}
                🔑 পাসওয়ার্ড= ${customCode}
                🌐 সার্ভার= ${serverUrl}
                
✅ সেভ দেওয়ার আগে আমাদেরকে ১টি ছবি তুলে পাঠিয়ে দিন 

সার্ভিস সংক্রান্ত সকল আপডেট নিউজ পেতে আমাদের গ্রুপে জয়েন হয়ে থাকুন 
https://whatsapp.com/channel/0029VaiF68OKLaHimVWjxm00
      
https://chat.whatsapp.com/JilKFf92ZoxFWaelYyKwr1?mode=ac_t

                ✅ অবস্থা: ${statusText}
                📦 Package: ${packageName}
                🔞 18+ প্যাকেজ: ${isAdult ? 'হ্যাঁ' : 'না'}
                🔗 সর্বোচ্চ কানেকশন: ${toBanglaNum(maxConnections)} টি
                📅 পরবর্তীতে আটো রিনিউ করতে = https://bdix.xyz/iptv
                📅 মেয়াদ শেষ হবে: ${expiryDateText}
                📅 আর বাকি: ${timeLeftText}
                `;
            fullDetailsDiv.innerHTML = resultText;
        } else {
            fullDetailsDiv.innerHTML = `<span style="color:red;">${fetchResult.error}</span>`;
        }
    }

    async function showExtendedDetailsByCustom() {
        const customCode = document.getElementById('customCodeInput').value.trim();
        const serverUrl = document.getElementById('serverSelect').value;
        const fullDetailsDiv = document.getElementById('fullDetails');
        
        if (!customCode) {
            fullDetailsDiv.innerHTML = '<span style="color:red;">দয়া করে একটি বৈধ কাস্টম কোড দিন।</span>';
            return;
        }

        const apiUrl = `${serverUrl.replace(/\/$/,'')}/player_api.php?username=${encodeURIComponent(customCode)}&password=${encodeURIComponent(customCode)}&action=get_profile`;
        
        fullDetailsDiv.innerHTML = 'বিস্তারিত তথ্য লোড করা হচ্ছে...<br>প্রথমে ইউজার প্রোফাইল যাচাই করা হচ্ছে...';
        const fetchResult = await fetchDataWithFallback(apiUrl);

        if (!fetchResult.success) {
            fullDetailsDiv.innerHTML = `<span style="color:red;">${fetchResult.error}</span>`;
            return;
        }

        const mainData = fetchResult.data;
        const userInfo = mainData.user_info;

        fullDetailsDiv.innerHTML = 'বিস্তারিত তথ্য লোড করা হচ্ছে...<br>চ্যানেল ও মুভি কাউন্ট যাচাই করা হচ্ছে... (এখন সব রুট দিয়ে চেষ্টা করা হবে)';
        
        // These three calls now use the streamlined fetchStreamDataWithFallback (PHP Proxy + All Fallbacks)
        const [liveResponse, moviesResponse, seriesResponse] = await Promise.all([
            fetchStreamDataWithFallback(serverUrl, customCode, customCode, 'get_live_streams'),
            fetchStreamDataWithFallback(serverUrl, customCode, customCode, 'get_vod_streams'),
            fetchStreamDataWithFallback(serverUrl, customCode, customCode, 'get_series'),
        ]);

        const packageSelect = document.getElementById('packageSelect');
        const packageName = packageSelect.options[packageSelect.selectedIndex].value;
        const isAdult = await check18Plus(serverUrl, customCode, customCode);
        const maxConnections = userInfo.max_connections !== undefined ? userInfo.max_connections : 'N/A';
        const statusText = userInfo.status || 'Active'; // Added Status

        const expiryTimestamp = extractExpiry(mainData);
        
        let timeLeftText;
        let expiryDateText;

        if (expiryTimestamp) {
            const currentDate = Date.now() / 1000;
            const timeLeftInSeconds = expiryTimestamp - currentDate;
            expiryDateText = fmtUnixToLocal(expiryTimestamp);

            if (timeLeftInSeconds <= 0) {
                timeLeftText = 'মেয়াদ শেষ হয়ে গেছে';
            } else if (timeLeftInSeconds < 86400) {
                const hoursLeft = Math.ceil(timeLeftInSeconds / 3600);
                timeLeftText = `${toBanglaNum(hoursLeft)} ঘণ্টা`;
            } else {
                const daysLeft = Math.ceil(timeLeftInSeconds / 86400);
                timeLeftText = `${toBanglaNum(daysLeft)} দিন`;
            }
        } else {
            timeLeftText = 'N/A (মেয়াদ তথ্য পাওয়া যায়নি)';
            expiryDateText = 'N/A (মেয়াদ তথ্য পাওয়া যায়নি)';
        }

        const liveCount = Array.isArray(liveResponse) ? toBanglaNum(liveResponse.length) : 'নেই';
        const moviesCount = Array.isArray(moviesResponse) ? toBanglaNum(moviesResponse.length) : 'নেই';
        const seriesCount = Array.isArray(seriesResponse) ? toBanglaNum(seriesResponse.length) : 'নেই';
        
        const resultText = `
            📡 আপনার Xtream IPTV কানেকশন ডিটেইলস (Login Info)🎬
            
            📌 নাম= ott
            👤 ইউজারনেম= ${customCode}
            🔑 পাসওয়ার্ড= ${customCode}
            🌐 সার্ভার= ${serverUrl}
 
✅ সেভ দেওয়ার আগে আমাদেরকে ১টি ছবি তুলে পাঠিয়ে দিন 

সার্ভিস সংক্রান্ত সকল আপডেট নিউজ পেতে আমাদের গ্রুপে জয়েন হয়ে থাকুন 
https://whatsapp.com/channel/0029VaiF68OKLaHimVWjxm00
      
https://chat.whatsapp.com/JilKFf92ZoxFWaelYyKwr1?mode=ac_t

            ✅ অবস্থা: ${statusText}
            📦 Package: ${packageName}
            🔞 18+ প্যাকেজ: ${isAdult ? 'হ্যাঁ' : 'না'}
            🔗 সর্বোচ্চ কানেকশন: ${toBanglaNum(maxConnections)} টি
            📺 মোট চ্যানেল: ${liveCount} টি
            🎞️ মোট মুভি: ${moviesCount} টি
            🍿 মোট সিরিজ: ${seriesCount} টি
            📅 পরবর্তীতে আটো রিনিউ করতে = https://bdix.xyz/iptv
            📅 মেয়াদ শেষ হবে: ${expiryDateText}
            📅 আর বাকি: ${timeLeftText}
            `;
        fullDetailsDiv.innerHTML = resultText;
    }

    // কাস্টম কোডের জন্য কানেকশন স্ট্যাটাস চেক ফাংশন
    async function checkConnectionStatus() {
        const customCode = document.getElementById('customCodeInput').value.trim();
        const serverUrl = document.getElementById('serverSelect').value;
        const fullDetailsDiv = document.getElementById('fullDetails');
        
        if (!customCode) {
            fullDetailsDiv.innerHTML = '<span style="color:red;">দয়া করে একটি বৈধ কাস্টম কোড দিন।</span>';
            return;
        }

        const apiUrl = `${serverUrl.replace(/\/$/,'')}/player_api.php?username=${encodeURIComponent(customCode)}&password=${encodeURIComponent(customCode)}&action=get_profile`;
        
        fullDetailsDiv.innerHTML = 'কানেকশন স্ট্যাটাস যাচাই করা হচ্ছে...';
        const fetchResult = await fetchDataWithFallback(apiUrl);

        if (!fetchResult.success) {
            fullDetailsDiv.innerHTML = `<span style="color:red;">${fetchResult.error}</span>`;
            return;
        }

        const mainData = fetchResult.data;
        const userInfo = mainData.user_info;

        const activeConnections = Number(userInfo.active_cons) || 0;
        const maxConnections = userInfo.max_connections !== undefined ? userInfo.max_connections : 'N/A';
        const activeSessions = userInfo.active_streams || [];
        const statusText = userInfo.status || 'Active'; // Added Status

        let sessionDetails = '';
        if (activeSessions.length > 0) {
            sessionDetails = '\n\n**🔴 বর্তমানে দেখছেন:**\n';
            activeSessions.forEach(session => {
                const startTimeSeconds = session.start_time;
                const currentTimeSeconds = Date.now() / 1000;
                
                let durationText = 'কিছু সময় ধরে';

                if (startTimeSeconds) {
                    const elapsedSeconds = Math.floor(currentTimeSeconds - startTimeSeconds);
                    
                    if (elapsedSeconds < 0) {
                        durationText = 'সময় গণনা করা যায়নি';
                    } else if (elapsedSeconds < 60) {
                        durationText = `${toBanglaNum(elapsedSeconds)} সেকেন্ড ধরে`;
                    } else {
                        const hours = Math.floor(elapsedSeconds / 3600);
                        const minutes = Math.floor((elapsedSeconds % 3600) / 60);

                        let parts = [];
                        if (hours > 0) parts.push(`${toBanglaNum(hours)} ঘণ্টা`);
                        if (minutes > 0) parts.push(`${toBanglaNum(minutes)} মিনিট`);
                        
                        durationText = parts.length > 0 ? parts.join(' ') + ' ধরে' : '১ মিনিটের কম সময় ধরে';
                    }
                }
                
                sessionDetails += `  - ${session.stream_name || 'অজানা কন্টেন্ট'} ( ${durationText} )\n`;
            });
        } else if (activeConnections > 0) {
            // যদি activeConnections > 0 হয়, কিন্তু activeSessions খালি থাকে
            sessionDetails = '\n**🔴 বর্তমানে দেখছেন:** সক্রিয় কানেকশন আছে, কিন্তু চ্যানেল বা কন্টেন্টের নাম দেখাচ্ছে না (API সীমাবদ্ধতা)।\n';
        } else {
            sessionDetails = '\n**🔴 বর্তমানে দেখছেন:** কেউ সক্রিয় নেই\n';
        }


        // মেয়াদ/Validity এর তথ্য
        const expiryTimestamp = extractExpiry(mainData);
        let timeLeftText = 'N/A';
        let expiryDateText = 'N/A';
        
        if (expiryTimestamp) {
            const currentDate = Date.now() / 1000;
            const timeLeftInSeconds = expiryTimestamp - currentDate;
            expiryDateText = fmtUnixToLocal(expiryTimestamp);

            if (timeLeftInSeconds <= 0) {
                timeLeftText = 'মেয়াদ শেষ হয়ে গেছে';
            } else if (timeLeftInSeconds < 86400) {
                const hoursLeft = Math.ceil(timeLeftInSeconds / 3600);
                timeLeftText = `${toBanglaNum(hoursLeft)} ঘণ্টা`;
            } else {
                const daysLeft = Math.ceil(timeLeftInSeconds / 86400);
                timeLeftText = `${toBanglaNum(daysLeft)} দিন`;
            }
        }

        let warningNote = '';
        // API সীমাবদ্ধতার নোটটি কেবল তখনই দেখানো হবে, যদি ডেটাটি অসম্পূর্ণ আসে।
        if (activeConnections > 0 && activeSessions.length === 0) {
            warningNote = `\n\n⚠️ **API নোট:** রানিং কানেকশন (${toBanglaNum(activeConnections)} টি) দেখালেও কন্টেন্টের নাম না দেখানোর কারণ হলো, আপনার Xtream সার্ভার 'player_api' এর মাধ্যমে এই বিস্তারিত ডেটা (active_streams) প্রদান করছে না। এটি সার্ভার-প্রান্তিক সীমাবদ্ধতা।`;
        }

        const resultText = `
            📡 আপনার Xtream IPTV কানেকশন স্ট্যাটাস 🎬
            
            📌 নাম= ott
            👤 ইউজারনেম= ${customCode}
            🌐 সার্ভার= ${serverUrl}
            
-----------------------------------------
            
            **📶 কানেকশন স্ট্যাটাস 📶**
            ✅ অবস্থা: ${statusText}
            🔴 রানিং কানেকশন: ${toBanglaNum(activeConnections)} টি
            🔗 সর্বোচ্চ কানেকশন: ${toBanglaNum(maxConnections)} টি
            
            ${sessionDetails}
            
            📅 মেয়াদ শেষ হবে: ${expiryDateText}
            📅 আর বাকি: ${timeLeftText}
            
            ${warningNote}
            `;
            
        fullDetailsDiv.innerHTML = resultText;
    }
    
    // --- Copy Function ---
    function copyFullDetails() {
        const text = document.getElementById('fullDetails').innerText;
        navigator.clipboard.writeText(text).then(() => alert("✅ কপি হয়েছে!"));
    }
</script>