// --- Firebase কনফিগারেশন ---
const firebaseConfig = {
    apiKey: "AIzaSyAX4a0mNLi9GD4sZRFQlY0XEXYbrMvyvWs",
    authDomain: "iptvshamim.firebaseapp.com",
    databaseURL: "https://iptvshamim-default-rtdb.asia-southeast1.firebasedatabase.app",
    projectId: "iptvshamim",
    storageBucket: "iptvshamim.firebasestorage.app",
    messagingSenderId: "269528132340",
    appId: "1:269528132340:web:ecabc4af701fb5ad114ca1",
    measurementId: "G-SGNKKWNYZC"
};

// --- Firebase চালু করা ---
firebase.initializeApp(firebaseConfig);
const auth = firebase.auth();
const db = firebase.database();
const siteContentRef = db.ref('site_content'); 
const packagesRef = db.ref('packages'); 
const customRemindersRef = db.ref('custom_reminders');

// --- HTML এলিমেন্টগুলো সিলেক্ট করা ---
const loginContainer = document.querySelector('.login-container');
const dashboard = document.getElementById('dashboard');
const loginButton = document.getElementById('loginButton');
const logoutButton = document.getElementById('logoutButton');
const emailInput = document.getElementById('email');
const passwordInput = document.getElementById('password');
const errorMessage = document.getElementById('error-message');
const successMessage = document.getElementById('success-message');

// সাধারণ সেটিং
const newsTickerInput = document.getElementById('news_ticker_input');
const trialEnabledCheckbox = document.getElementById('trial_enabled_checkbox');
const saveGeneralSettingsButton = document.getElementById('saveGeneralSettingsButton');

// স্লাইডার
const slideKeyInput = document.getElementById('slide_key_input');
const slideTypeSelect = document.getElementById('slide_type_select');
const slideTitleInput = document.getElementById('slide_title_input');
const slideContentInput = document.getElementById('slide_content_input');
const slideImageUrlInput = document.getElementById('slide_image_url_input');
const slideOrderInput = document.getElementById('slide_order_input');
const saveSlideButton = document.getElementById('saveSlideButton');
const clearSlideFormButton = document.getElementById('clearSlideFormButton');
const slideListContainer = document.getElementById('slide-list-container');
const textFields = document.getElementById('text-fields');
const imageFields = document.getElementById('image-fields');
const noticeSliderRef = db.ref('site_content/notice_slider'); 

// প্যাকেজ
const packageKeyInput = document.getElementById('package_key_input');
const packageNameInput = document.getElementById('package_name_input');
const packageOrderInput = document.getElementById('package_order_input'); 
const packagePriceMonthInput = document.getElementById('package_price_month_input');
const packageChannelUrlInput = document.getElementById('package_channel_url_input');
const packageBalanceInput = document.getElementById('package_balance_input'); 
const packageFeaturesInput = document.getElementById('package_features_input');
const packageHasAdultInput = document.getElementById('package_has_adult_input');
// ❇️❇️ নতুন: প্যাকেজ এডিটর চেকবক্স (এটি admin.html এ যোগ করতে হবে) ❇️❇️
const packageIsPublishedInput = document.getElementById('package_is_published_input');
const savePackageButton = document.getElementById('savePackageButton');
const clearFormButton = document.getElementById('clearFormButton');
const packageListContainer = document.getElementById('package-list-container');
const addPriceButton = document.getElementById('addPriceButton');
const pricingLabelInput = document.getElementById('pricing_label_input');
const pricingAmountInput = document.getElementById('pricing_amount_input');
const pricingDiscountInput = document.getElementById('pricing_discount_input');
const pricingListContainer = document.getElementById('pricing-list-container');

// স্টক
const stockPackageSelect = document.getElementById('stock-package-select');
const stockCurrentBalanceDisplay = document.getElementById('stock-current-balance-display');
const stockCurrentBalanceEl = document.getElementById('stock-current-balance');
const stockAddAmountInput = document.getElementById('stock-add-amount');
const addStockButton = document.getElementById('addStockButton');
const stockSetAmountInput = document.getElementById('stock-set-amount'); 
const setStockButton = document.getElementById('setStockButton'); 
let packageListForStock = {}; 

// রিভিউ, অ্যাপ, FAQ, ভিডিও, পেমেন্ট সেটিং
const reviewKeyInput = document.getElementById('review_key_input');
const reviewUrlInput = document.getElementById('review_url_input');
const reviewAltInput = document.getElementById('review_alt_input');
const saveReviewButton = document.getElementById('saveReviewButton');
const clearReviewFormButton = document.getElementById('clearReviewFormButton');
const reviewListContainer = document.getElementById('review-list-container');
const reviewsRef = db.ref('site_content/reviews'); 

const appKeyInput = document.getElementById('app_key_input');
const appNameInput = document.getElementById('app_name_input');
const appCategoryInput = document.getElementById('app_category_input'); 
const appLinkInput = document.getElementById('app_link_input');
const appMobileGuideInput = document.getElementById('app_mobile_guide_input');
const appTvGuideInput = document.getElementById('app_tv_guide_input');
const saveAppButton = document.getElementById('saveAppButton');
const clearAppFormButton = document.getElementById('clearAppFormButton');
const appListContainer = document.getElementById('app-list-container');
const appsRef = db.ref('site_content/dynamic_apps'); 

const faqKeyInput = document.getElementById('faq_key_input');
const faqQuestionInput = document.getElementById('faq_question_input');
const faqAnswerInput = document.getElementById('faq_answer_input');
const faqOrderInput = document.getElementById('faq_order_input'); 
const saveFaqButton = document.getElementById('saveFaqButton');
const clearFaqFormButton = document.getElementById('clearFaqFormButton');
const faqListContainer = document.getElementById('faq-list-container');
const faqsRef = db.ref('site_content/faqs'); 

const paymentBkashInput = document.getElementById('payment_bkash');
const paymentNagadInput = document.getElementById('payment_nagad');
const paymentRocketInput = document.getElementById('payment_rocket');
const paymentUpayInput = document.getElementById('payment_upay');
const paymentVideoGuideInput = document.getElementById('payment_video_guide');
const paymentWhatsappInput = document.getElementById('payment_whatsapp');
const paymentDeviceListInput = document.getElementById('payment_device_list');
const paymentEnableUsernameInput = document.getElementById('payment_enable_username');
const savePaymentSettingsButton = document.getElementById('savePaymentSettingsButton');
const paymentSettingsRef = db.ref('site_content/payment_settings'); 

const videoKeyInput = document.getElementById('video_key_input');
const videoTitleInput = document.getElementById('video_title_input');
const videoUrlInput = document.getElementById('video_url_input');
const videoThumbnailInput = document.getElementById('video_thumbnail_input');
const videoDescriptionInput = document.getElementById('video_description_input');
const videoOrderInput = document.getElementById('video_order_input');
const saveVideoButton = document.getElementById('saveVideoButton');
const clearVideoFormButton = document.getElementById('clearVideoFormButton');
const videoListContainer = document.getElementById('video-list-container');
const videosRef = db.ref('site_content/videos'); 

const saveMainSupportButton = document.getElementById('saveMainSupportButton');
const supportMainWhatsapp = document.getElementById('support_main_whatsapp');
const supportMainMessenger = document.getElementById('support_main_messenger');
const supportSections = document.querySelectorAll('.sub-editor-section[data-list-name]'); 
const supportLinksRef = db.ref('site_content/support_links'); 

const mainMenu = document.getElementById('main-menu');
const editorPages = document.querySelectorAll('.editor-page');
const menuButtons = document.querySelectorAll('.menu-button');
const backButtons = document.querySelectorAll('.back-btn');

const adminTodaySalesEl = document.getElementById('adminTodaySales');
const adminTodayOrdersEl = document.getElementById('adminTodayOrders');
const visitCountsRef = db.ref('visit_counts'); 

// সেলস রিপোর্ট এলিমেন্ট
const salesLogRef = db.ref('sales_log');
const salesLogTbody = document.getElementById('sales-log-tbody');
const salesStartDateInput = document.getElementById('salesStartDate');
const salesEndDateInput = document.getElementById('salesEndDate');
const filterSalesButton = document.getElementById('filterSalesButton');
const clearFilterSalesButton = document.getElementById('clearFilterSalesButton');
const filteredTotalSalesEl = document.getElementById('filteredTotalSales');
const filteredTotalOrdersEl = document.getElementById('filteredTotalOrders');

const salesSearchInput = document.getElementById('salesSearchInput');
const salesSearchBtn = document.getElementById('salesSearchBtn');
const salesSearchClearBtn = document.getElementById('salesSearchClearBtn');

const orderTypeFilterButtonsContainer = document.getElementById('order-type-filters');
const orderTypeFilterButtons = document.querySelectorAll('#order-type-filters .stat-filter-btn');

const last7DaysSalesEl = document.getElementById('last7DaysSales');
const last30DaysSalesEl = document.getElementById('last30DaysSales');
const allTimeSalesEl = document.getElementById('allTimeSales');
const last7DaysOrdersEl = document.getElementById('last7DaysOrders');
const last30DaysOrdersEl = document.getElementById('last30DaysOrders');
const allTimeOrdersEl = document.getElementById('allTimeOrders');

const paymentStatsFilterButtonsContainer = document.querySelector('#payment-stats-filters');
const paymentStatsFilterButtons = document.querySelectorAll('#payment-stats-filters .stat-filter-btn');
const bkashSalesEl = document.getElementById('bkashSales');
const nagadSalesEl = document.getElementById('nagadSales');
const rocketSalesEl = document.getElementById('rocketSales');
const upaySalesEl = document.getElementById('upaySales');

const packageStatsFilterButtonsContainer = document.querySelector('#package-stats-filters');
const packageStatsFilterButtons = document.querySelectorAll('#package-stats-filters .stat-filter-btn');
const packageSalesStatsContainer = document.getElementById('package-sales-stats-container');

const salesStatsWrapper = document.getElementById('sales-stats-wrapper'); 
const salesReportTitle = document.getElementById('sales-report-title'); 
const backToFullReportBtn = document.getElementById('backToFullReportBtn'); 

// সেলস এডিট Modal
const salesEditModal = document.getElementById('salesEditModal');
const modalCloseButton = document.getElementById('modalCloseButton');
const cancelSalesEditButton = document.getElementById('cancelSalesEditButton');
const saveSalesEditButton = document.getElementById('saveSalesEditButton');
const editSalesKeyInput = document.getElementById('editSalesKey');
const editSalesTimestampInput = document.getElementById('editSalesTimestamp');
const editPackageNameInput = document.getElementById('editPackageName');
const editSalesUsernameInput = document.getElementById('editSalesUsername');
const editDurationInput = document.getElementById('editDuration');
const editTrxIdInput = document.getElementById('editTrxId');
const editAmountInput = document.getElementById('editAmount');
const editCustomerWhatsappInput = document.getElementById('editCustomerWhatsapp');

// রিমাইন্ডার
const reminderEditModal = document.getElementById('reminderEditModal');
const reminderModalCloseButton = document.getElementById('reminderModalCloseButton');
const cancelReminderEditButton = document.getElementById('cancelReminderEditButton');
const saveReminderEditButton = document.getElementById('saveReminderEditButton');
const reminderLogKeyInput = document.getElementById('reminderLogKeyInput');
const reminderCustomerWhatsappInput = document.getElementById('reminderCustomerWhatsappInput');
const reminderTimestampInput = document.getElementById('reminderTimestampInput');

const reminderSearchInput = document.getElementById('reminderSearchInput');
const reminderSearchBtn = document.getElementById('reminderSearchBtn');
const reminderSearchClearBtn = document.getElementById('reminderSearchClearBtn');

const reminderTemplateInput = document.getElementById('reminderTemplateInput');
const saveReminderTemplateBtn = document.getElementById('saveReminderTemplateBtn');
const expiringTomorrowList = document.getElementById('expiringTomorrowList');
const expiringTodayList = document.getElementById('expiringTodayList');
const expiredRecentlyList = document.getElementById('expiredRecentlyList');
const manualReminderNumberInput = document.getElementById('manualReminderNumber'); 
const sendManualReminderBtn = document.getElementById('sendManualReminderBtn'); 
const copyTomorrowListBtn = document.getElementById('copyTomorrowListBtn'); 
const copyTodayListBtn = document.getElementById('copyTodayListBtn'); 
const copyExpiredListBtn = document.getElementById('copyExpiredListBtn'); 
const copyActiveListBtn = document.getElementById('copyActiveListBtn'); 
const activeNowList = document.getElementById('activeNowList'); 

const sentMessagesList = document.getElementById('sentMessagesList');
const copySentListBtn = document.getElementById('copySentListBtn');

let reminderMessageTemplate = "প্রিয় গ্রাহক [username], আপনার [package] প্যাকেজটির মেয়াদ [date] তারিখে শেষ হয়ে যাচ্ছে। রিনিউ করতে যোগাযোগ করুন।"; 

let allSalesLogs = []; 
let currentPricingList = {}; 
let currentEditKey = null; 
let currentOrderTypeFilter = 'all'; 

const sentRemindersKey = 'ottAdminSentReminders';
let sentReminders = new Set(); 

let serverOffset = 0; 
let paymentMethodStats = {
    bkash: { today: 0, yesterday: 0, '7days': 0, '30days': 0, all: 0 },
    nagad: { today: 0, yesterday: 0, '7days': 0, '30days': 0, all: 0 },
    rocket: { today: 0, yesterday: 0, '7days': 0, '30days': 0, all: 0 },
    upay: { today: 0, yesterday: 0, '7days': 0, '30days': 0, all: 0 }
};
let packageSalesStats = {}; 

let currentPackageFilter = null; 


// --- localStorage ---
function loadSentReminders() {
    try {
        const storedData = localStorage.getItem(sentRemindersKey);
        if (storedData) {
            return new Set(JSON.parse(storedData)); 
        }
    } catch (e) {
        console.error("Failed to load sent reminders from localStorage:", e);
        localStorage.removeItem(sentRemindersKey); 
    }
    return new Set(); 
}

function saveSentReminders(sentSet) {
    try {
        localStorage.setItem(sentRemindersKey, JSON.stringify(Array.from(sentSet)));
    } catch (e) {
        console.error("Failed to save sent reminders to localStorage:", e);
    }
}


if(loginButton) {
    loginButton.addEventListener('click', () => {
        errorMessage.textContent = "লগইন করা হচ্ছে..."; // ব্যবহারকারীকে ফিডব্যাক দিন
        auth.signInWithEmailAndPassword(emailInput.value, passwordInput.value)
            .catch((error) => { 
                // Firebase থেকে আসা আসল এরর মেসেজটি দেখান
                console.error("Firebase Login Error:", error); // Console-এ বিস্তারিত এরর
                errorMessage.textContent = `এরর: ${error.message}`; 
            });
    });
}

if(logoutButton) {
    logoutButton.addEventListener('click', () => {
        auth.signOut();
    });
}

function getBdtDateString(timestamp) {
    const bdtOffsetInMinutes = 6 * 60; 
    const date = new Date(timestamp);
    const utcTime = date.getTime() + (date.getTimezoneOffset() * 60000);
    const bdtDate = new Date(utcTime + (bdtOffsetInMinutes * 60000));
    const year = bdtDate.getFullYear();
    const month = String(bdtDate.getMonth() + 1).padStart(2, '0');
    const day = String(bdtDate.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}`;
}


function toEnglishNumber(str) {
    if (!str) return '';
    const bengaliDigits = ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'];
    const englishDigits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    let newStr = String(str);
    for (let i = 0; i < 10; i++) {
        newStr = newStr.replace(new RegExp(bengaliDigits[i], 'g'), englishDigits[i]);
    }
    return newStr;
}

function formatTimestampToInput(timestamp) {
    const date = new Date(timestamp);
    const localDate = new Date(timestamp - (new Date().getTimezoneOffset() * 60000));
    return localDate.toISOString().slice(0, 16);
}
function formatInputToTimestamp(inputString) {
    const localTime = new Date(inputString).getTime();
    const timezoneOffset = new Date().getTimezoneOffset() * 60000;
    return localTime + timezoneOffset;
}

function getOrderType(durationFullString) {
    const safeDuration = toEnglishNumber((durationFullString || "").toLowerCase());
    const match = safeDuration.match(/^(\d+)/);
    const durationValue = match ? parseInt(match[0]) : NaN;

    if (isNaN(durationValue)) {
        return 'paid'; 
    }

    if (safeDuration.includes("ঘন্টা") || safeDuration.includes("hour")) {
        if (durationValue < 72) {
            return 'trial'; 
        } else {
            return 'paid'; 
        }
    }
    
    if (safeDuration.includes("দিন") || safeDuration.includes("day")) {
        const hours = durationValue * 24; 
        if (hours < 72) {
            return 'trial'; 
        } else {
            return 'paid'; 
        }
    }
    
    return 'paid';
}


auth.onAuthStateChanged((user) => {
    if (user) {
        sentReminders = loadSentReminders(); 

        loginContainer.classList.add('hidden');
        dashboard.classList.remove('hidden');
        showPage('main-menu'); 
        
        db.ref("/.info/serverTimeOffset").once("value", (offsetSnap) => {
            serverOffset = offsetSnap.val() || 0;
            const now = Date.now() + serverOffset; 
            const today_bdt = getBdtDateString(now); 

            visitCountsRef.child('lastResetDate').once("value", (snap) => {
                const lastResetDate = snap.val();
                
                if (lastResetDate !== today_bdt) {
                    visitCountsRef.update({
                        todaySales: 0,
                        todayOrders: 0,
                        lastResetDate: today_bdt
                    }).then(() => {
                        console.log("Daily stats reset to BDT: " + today_bdt);
                        loadAllAdminData(); 
                    });
                } else {
                    loadAllAdminData();
                }
            });
        });
        
        initializeSalesLogListeners(); 
        initializeStockManagerListeners(); 
        initializeReminderListeners(); 
        
    } else {
        loginContainer.classList.remove('hidden');
        dashboard.classList.add('hidden');
        showPage(null); 
        siteContentRef.child('general').off();
        siteContentRef.child('reminders/template').off(); 
        visitCountsRef.off(); 
        salesLogRef.off(); 
        packagesRef.off(); 
        appsRef.off();
        faqsRef.off(); 
        paymentSettingsRef.off(); 
        videosRef.off(); 
        reviewsRef.off();
        supportLinksRef.off();
        noticeSliderRef.off(); 
    }
});

function loadAllAdminData() {
    
    if(adminTodaySalesEl && adminTodayOrdersEl) {
        visitCountsRef.child('todaySales').on('value', (snapshot) => {
            const sales = snapshot.val() || 0;
            adminTodaySalesEl.textContent = `৳ ${sales}`;
        });
        visitCountsRef.child('todayOrders').on('value', (snapshot) => {
            const orders = snapshot.val() || 0;
            adminTodayOrdersEl.textContent = orders;
        });
    }

    // সাধারণ সেটিং লোড
    siteContentRef.child('general').on('value', (snapshot) => {
        const data = snapshot.val() || {};
        if(newsTickerInput) newsTickerInput.value = data.news_ticker || '';
        if(trialEnabledCheckbox) trialEnabledCheckbox.checked = data.isTrialEnabled || false;
    });
    
    loadSlidesForAdmin();
    loadPackagesForAdmin(); 
    loadPackagesForStockManager(); 
    loadReviewsForAdmin(); 
    loadAppsForAdmin(); 
    loadFaqsForAdmin(); 
    loadPaymentSettings(); 
    loadVideosForAdmin();
    loadSupportLinksForAdmin();
    loadReminderTemplate(); 
    loadSalesLog(); 
}

if(saveGeneralSettingsButton) {
    saveGeneralSettingsButton.addEventListener('click', () => {
        const settingsData = {
            news_ticker: newsTickerInput.value,
            isTrialEnabled: trialEnabledCheckbox.checked
        };
        
        siteContentRef.child('general').update(settingsData)
            .then(() => showSuccessMessage("সাধারণ সেটিং সেভ হয়েছে!"))
            .catch(showError);
    });
}

function toggleSlideFields() { if (slideTypeSelect.value === 'image') { textFields.style.display = 'none'; imageFields.style.display = 'block'; } else { textFields.style.display = 'block'; imageFields.style.display = 'none'; } }
window.toggleSlideFields = toggleSlideFields;
if(clearSlideFormButton) clearSlideFormButton.addEventListener('click', clearSlideForm);
function clearSlideForm() { slideKeyInput.value = ''; slideTypeSelect.value = 'text'; slideTitleInput.value = ''; slideContentInput.value = ''; slideImageUrlInput.value = ''; slideOrderInput.value = ''; toggleSlideFields(); }
if(saveSlideButton) { saveSlideButton.addEventListener('click', () => { const key = slideKeyInput.value; const order = parseInt(slideOrderInput.value) || 0; const slideData = { type: slideTypeSelect.value, title: slideTitleInput.value, content: slideContentInput.value, imageUrl: slideImageUrlInput.value, order: order }; if (key) { noticeSliderRef.child(key).update(slideData) .then(() => { showSuccessMessage("স্লাইড সফলভাবে আপডেট হয়েছে!"); clearSlideForm(); }) .catch(showError); } else { noticeSliderRef.push(slideData) .then(() => { showSuccessMessage("নতুন স্লাইড সফলভাবে যোগ হয়েছে!"); clearSlideForm(); }) .catch(showError); } }); }
function loadSlidesForAdmin() { noticeSliderRef.orderByChild("order").on('value', (snapshot) => { if(!slideListContainer) return; slideListContainer.innerHTML = ''; if (!snapshot.exists()) { slideListContainer.innerHTML = '<p>কোনো স্লাইড পাওয়া যায়নি।</p>'; return; } snapshot.forEach(childSnapshot => { const slideKey = childSnapshot.key; const slideData = childSnapshot.val(); let displayText = slideData.type === 'image' ? `[ছবি] ${slideData.imageUrl.substring(0, 30)}...` : `[টেক্সট] ${slideData.title}`; const slideItem = document.createElement('div'); slideItem.classList.add('review-item'); slideItem.innerHTML = ` <span>(Order: ${slideData.order || 'N/A'}) ${displayText}</span> <div class="actions"> <button class="edit-btn" data-key="${slideKey}">✏️ এডিট</button> <button class="delete-btn" data-key="${slideKey}">❌ ডিলিট</button> </div> `; slideListContainer.appendChild(slideItem); }); slideListContainer.querySelectorAll('.edit-btn').forEach(button => { button.addEventListener('click', (e) => selectSlideForEdit(e.target.dataset.key)); }); slideListContainer.querySelectorAll('.delete-btn').forEach(button => { button.addEventListener('click', (e) => deleteSlide(e.target.dataset.key)); }); }); }
function selectSlideForEdit(key) { noticeSliderRef.child(key).once('value', (snapshot) => { const data = snapshot.val(); slideKeyInput.value = key; slideTypeSelect.value = data.type || 'text'; slideTitleInput.value = data.title || ''; slideContentInput.value = data.content || ''; slideImageUrlInput.value = data.imageUrl || ''; slideOrderInput.value = data.order || ''; toggleSlideFields(); document.getElementById('slide-editor-form').scrollIntoView({ behavior: 'smooth' }); }); }
function deleteSlide(key) { if (confirm("আপনি কি সত্যিই এই স্লাইডটি ডিলিট করতে চান?")) { noticeSliderRef.child(key).remove() .then(() => { showSuccessMessage("স্লাইড ডিলিট করা হয়েছে।"); clearSlideForm(); }) .catch(showError); } }


// ❇️❇️ পরিবর্তন: loadPackagesForAdmin ফাংশনে লাইভ চেকবক্স যোগ করা ❇️❇️
function loadPackagesForAdmin() { 
    packagesRef.orderByChild("order").on('value', (snapshot) => {
        if(!packageListContainer) return;
        packageListContainer.innerHTML = ''; 
        if (!snapshot.exists()) {
            packageListContainer.innerHTML = '<p>কোনো প্যাকেজ পাওয়া যায়নি।</p>';
            return;
        }
        snapshot.forEach(childSnapshot => {
            const packageKey = childSnapshot.key;
            const packageData = childSnapshot.val();
            const packageItem = document.createElement('div');
            packageItem.classList.add('package-item'); 
            packageItem.setAttribute('data-key', packageKey); 
            
            // isPublished স্ট্যাটাস চেক (ডিফল্ট true)
            const isPublished = (packageData.isPublished === undefined) ? true : packageData.isPublished;

            let balanceHtml = '';
            if (packageData.balance === null || packageData.balance === undefined) {
                balanceHtml = `<span class="balance-info unlimited">(ব্যালেন্স: আনলিমিটেড)</span>`;
            } else {
                const balance = parseInt(packageData.balance);
                if (balance <= 5) {
                    balanceHtml = `<span class="balance-info low-stock">(ব্যালেন্স: ${balance})</span>`;
                } else {
                    balanceHtml = `<span class="balance-info">(ব্যালেন্স: ${balance})</span>`;
                }
            }

            // লাইভ টগল চেকবক্স HTML
            const toggleHtml = `
                <input type="checkbox" class="live-publish-toggle" data-key="${packageKey}" ${isPublished ? 'checked' : ''} title="সাইটে দেখানো/লুকানো">
            `;

            packageItem.innerHTML = `
                ${toggleHtml} <span>${packageData.name} (Order: ${packageData.order || 'N/A'})</span>
                ${balanceHtml}
                <div class="actions">
                    <button class="edit-btn" data-key="${packageKey}">✏️ এডিট</button>
                    <button class="delete-btn" data-key="${packageKey}">❌ ডিলিট</button>
                </div>
            `;
            packageListContainer.appendChild(packageItem);
        });

        // ❇️❇️ নতুন: সব লাইভ টগল চেকবক্সের জন্য ইভেন্ট লিসেনার ❇️❇️
        packageListContainer.querySelectorAll('.live-publish-toggle').forEach(toggle => {
            toggle.addEventListener('change', (e) => {
                const packageKey = e.target.dataset.key;
                const isPublished = e.target.checked;
                
                // সাথে সাথে Firebase আপডেট করুন
                packagesRef.child(packageKey).child('isPublished').set(isPublished)
                    .then(() => {
                        showSuccessMessage('প্যাকেজের স্ট্যাটাস আপডেট হয়েছে।');
                    })
                    .catch(showError);
            });
        });
        
        // পুরানো এডিট/ডিলিট লিসেনার
        packageListContainer.querySelectorAll('.edit-btn').forEach(button => {
            button.addEventListener('click', (e) => selectPackageForEdit(e.target.dataset.key));
        });
        packageListContainer.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', (e) => deletePackage(e.target.dataset.key));
        });
    });
}

if(addPriceButton) { 
    addPriceButton.addEventListener('click', () => { 
        const label = pricingLabelInput.value.trim(); 
        const amount = parseInt(pricingAmountInput.value);
        const discount = parseInt(pricingDiscountInput.value) || 0;

        if (!label || isNaN(amount) || amount <= 0) { 
            alert("অনুগ্রহ করে সঠিক মেয়াদ (Label) এবং মূল্য (Price) দিন।"); 
            return; 
        }
        if (isNaN(discount) || discount < 0 || discount > 100) {
            alert("ছাড় (Discount) অবশ্যই ০ থেকে ১০০ এর মধ্যে একটি সংখ্যা হতে হবে।");
            return;
        }
        
        currentPricingList[label] = {
            price: amount,
            discount: discount
        }; 

        renderPricingList(); 
        pricingLabelInput.value = ''; 
        pricingAmountInput.value = ''; 
        pricingDiscountInput.value = '';
    }); 
}

function renderPricingList() { 
    if(!pricingListContainer) return; 
    pricingListContainer.innerHTML = ''; 
    if (Object.keys(currentPricingList).length === 0) { 
        pricingListContainer.innerHTML = '<p><small>এখনো কোনো মূল্য যোগ করা হয়নি।</small></p>'; 
        return; 
    } 
    
    for (const label in currentPricingList) { 
        const priceData = currentPricingList[label];
        
        let amount, discount;
        if (typeof priceData === 'object' && priceData !== null) {
            amount = priceData.price;
            discount = priceData.discount || 0;
        } else {
            amount = priceData;
            discount = 0;
        }

        const itemEl = document.createElement('div'); 
        itemEl.classList.add('pricing-item'); 
        
        let displayText = `(৳${amount})`;
        if (discount > 0) {
            displayText += ` - ${discount}% ছাড়`;
        }

        itemEl.innerHTML = ` 
            <span>${label} <span class="price-value">${displayText}</span></span> 
            <div class="actions"> 
                <button class="edit-price-btn" data-label="${label}">✏️ এডিট</button> 
                <button class="delete-price-btn" data-label="${label}">❌</button> 
            </div> 
        `; 
        pricingListContainer.appendChild(itemEl); 
    } 
    
    pricingListContainer.querySelectorAll('.delete-price-btn').forEach(button => { 
        button.addEventListener('click', (e) => { 
            const labelToDelete = e.target.dataset.label; 
            delete currentPricingList[labelToDelete]; 
            renderPricingList(); 
        }); 
    }); 
    
    pricingListContainer.querySelectorAll('.edit-price-btn').forEach(button => { 
        button.addEventListener('click', (e) => { 
            const labelToEdit = e.target.dataset.label; 
            const priceData = currentPricingList[labelToEdit]; 
            
            let amount, discount;
            if (typeof priceData === 'object' && priceData !== null) {
                amount = priceData.price;
                discount = priceData.discount || 0;
            } else {
                amount = priceData;
                discount = 0;
            }
            
            pricingLabelInput.value = labelToEdit; 
            pricingAmountInput.value = amount;
            pricingDiscountInput.value = discount;
            
            delete currentPricingList[labelToEdit]; 
            renderPricingList(); 
        }); 
    }); 
}

// ❇️❇️ পরিবর্তন: savePackageButton এ isPublished সেভ করা ❇️❇️
if(savePackageButton) {
    savePackageButton.addEventListener('click', () => {
        const key = packageKeyInput.value;
        const order = parseInt(packageOrderInput.value); 
        const featuresArray = packageFeaturesInput.value.split('\n').filter(f => f.trim() !== '');
        
        let balanceValue = null; 
        if (packageBalanceInput.value !== '') {
            balanceValue = parseInt(packageBalanceInput.value);
            if (isNaN(balanceValue)) {
                balanceValue = 0; 
            }
        }
        
        const packageData = {
            name: packageNameInput.value,
            order: isNaN(order) ? 0 : order,
            price_month: packagePriceMonthInput.value,
            channel_list_url: packageChannelUrlInput.value,
            balance: balanceValue, 
            features: featuresArray,
            has_adult_option: packageHasAdultInput.checked,
            pricing: currentPricingList,
            isPublished: packageIsPublishedInput.checked // ❇️ নতুন
        };
        
        if (key) {
            packagesRef.child(key).update(packageData)
                .then(() => {
                    showSuccessMessage("প্যাকেজ সফলভাবে আপডেট হয়েছে!");
                    clearPackageForm();
                })
                .catch(showError);
        } else {
            if (!packageData.order || packageData.order === 0) {
                packagesRef.orderByChild('order').limitToLast(1).once('value', (snapshot) => {
                    let newOrder = 1; 
                    if (snapshot.exists()) {
                        snapshot.forEach(child => { newOrder = (child.val().order || 0) + 1; });
                    }
                    packageData.order = newOrder; 
                    pushNewPackage(packageData); 
                });
            } else {
                pushNewPackage(packageData);
            }
        }
    });
}

function pushNewPackage(packageData) {
    packagesRef.push(packageData)
        .then(() => {
            showSuccessMessage("নতুন প্যাকেজ সফলভাবে যোগ হয়েছে!");
            clearPackageForm();
        })
        .catch(showError);
}

// ❇️❇️ পরিবর্তন: selectPackageForEdit এ isPublished লোড করা ❇️❇️
function selectPackageForEdit(key) {
    packagesRef.child(key).once('value', (snapshot) => {
        const data = snapshot.val();
        packageKeyInput.value = key;
        packageNameInput.value = data.name;
        packageOrderInput.value = data.order || ''; 
        packagePriceMonthInput.value = data.price_month || '';
        packageChannelUrlInput.value = data.channel_list_url;
        
        packageBalanceInput.value = (data.balance === null || data.balance === undefined) ? '' : data.balance; 
        
        packageFeaturesInput.value = (data.features || []).join('\n'); 
        packageHasAdultInput.checked = data.has_adult_option || false; 
        currentPricingList = data.pricing || {}; 
        renderPricingList();
        
        // isPublished চেকবক্স সেট করা (ডিফল্ট true যদি ডেটাবেসে না থাকে)
        packageIsPublishedInput.checked = (data.isPublished === undefined) ? true : data.isPublished;
        
        document.getElementById('package-editor-form').scrollIntoView({ behavior: 'smooth' });
    });
}

function deletePackage(key) {
    if (confirm("আপনি কি সত্যিই এই প্যাকেজটি ডিলিট করতে চান?")) {
        packagesRef.child(key).remove()
            .then(() => {
                showSuccessMessage("প্যাকেজ ডিলিট করা হয়েছে।");
                clearPackageForm();
            })
            .catch(showError);
    }
}

// ❇️❇️ পরিবর্তন: clearPackageForm এ isPublished রিসেট করা ❇️❇️
if(clearFormButton) clearFormButton.addEventListener('click', clearPackageForm);
function clearPackageForm() {
    packageKeyInput.value = '';
    packageNameInput.value = '';
    packageOrderInput.value = ''; 
    packagePriceMonthInput.value = '';
    packageChannelUrlInput.value = '';
    packageBalanceInput.value = ''; 
    packageFeaturesInput.value = '';
    packageHasAdultInput.checked = false;
    currentPricingList = {};
    pricingLabelInput.value = '';
    pricingAmountInput.value = '';
    pricingDiscountInput.value = ''; 
    renderPricingList();
    
    // নতুন প্যাকেজের জন্য ডিফল্ট 'checked'
    packageIsPublishedInput.checked = true;
}


function loadPackagesForStockManager() {
    if (!stockPackageSelect) return;

    packagesRef.orderByChild("name").on('value', (snapshot) => {
        stockPackageSelect.innerHTML = '<option value="">-- প্যাকেজ সিলেক্ট করুন --</option>';
        packageListForStock = {}; 

        if (!snapshot.exists()) {
            stockPackageSelect.innerHTML = '<option value="">-- কোনো প্যাকেজ পাওয়া যায়নি --</option>';
            return;
        }
        
        snapshot.forEach(childSnapshot => {
            const packageKey = childSnapshot.key;
            const packageData = childSnapshot.val();
            
            const option = document.createElement('option');
            option.value = packageKey;
            option.text = packageData.name;
            stockPackageSelect.appendChild(option);
            
            packageListForStock[packageKey] = {
                name: packageData.name,
                balance: packageData.balance
            };
        });
        
        updateCurrentStockDisplay();
    });
}

function updateCurrentStockDisplay() {
    const selectedKey = stockPackageSelect.value;
    if (selectedKey && packageListForStock[selectedKey]) {
        const balance = packageListForStock[selectedKey].balance;
        
        if (balance === null || balance === undefined) {
            stockCurrentBalanceEl.textContent = "আনলিমিটেড";
            stockCurrentBalanceEl.className = 'unlimited';
        } else {
            const balanceNum = parseInt(balance);
            stockCurrentBalanceEl.textContent = balanceNum;
            stockCurrentBalanceEl.className = balanceNum <= 5 ? 'low-stock' : '';
        }
        stockCurrentBalanceDisplay.classList.remove('hidden');
    } else {
        stockCurrentBalanceDisplay.classList.add('hidden');
    }
}

function initializeStockManagerListeners() {
    if (stockPackageSelect) {
        stockPackageSelect.addEventListener('change', updateCurrentStockDisplay);
    }
    
    if (addStockButton) {
        addStockButton.addEventListener('click', () => {
            const selectedKey = stockPackageSelect.value;
            const amountToAdd = parseInt(stockAddAmountInput.value);

            if (!selectedKey) {
                alert("অনুগ্রহ করে একটি প্যাকেজ সিলেক্ট করুন।");
                return;
            }
            if (isNaN(amountToAdd) || amountToAdd <= 0) {
                alert("অনুগ্রহ করে সঠিক পরিমাণ লিখুন (যেমন: 50)।");
                return;
            }
            
            const packageStockRef = packagesRef.child(selectedKey).child('balance');
            
            packageStockRef.transaction((currentBalance) => {
                if (currentBalance === null || currentBalance === undefined) {
                    return amountToAdd;
                } else {
                    return (parseInt(currentBalance) || 0) + amountToAdd;
                }
            }, (error, committed, snapshot) => {
                if (error) {
                    showError(error);
                } else if (committed) {
                    showSuccessMessage(`${amountToAdd} টি স্টক সফলভাবে যোগ করা হয়েছে!`);
                    stockAddAmountInput.value = ''; 
                } else {
                    showError({ message: "স্টক আপডেট ব্যর্থ হয়েছে।" });
                }
            });
        });
    }
    
    if (setStockButton) {
        setStockButton.addEventListener('click', () => {
            const selectedKey = stockPackageSelect.value;
            const amountToSet = stockSetAmountInput.value; 

            if (!selectedKey) {
                alert("অনুগ্রহ করে একটি প্যাকেজ সিলেক্ট করুন।");
                return;
            }
            
            let newBalance = null; 
            if (amountToSet !== '') { 
                newBalance = parseInt(amountToSet);
                if (isNaN(newBalance) || newBalance < 0) {
                    alert("অনুগ্রহ করে সঠিক সংখ্যা লিখুন (যেমন: 100), অথবা আনলিমিটেড করতে খালি রাখুন।");
                    return;
                }
            }

            const packageStockRef = packagesRef.child(selectedKey).child('balance');
            
            packageStockRef.set(newBalance) 
                .then(() => {
                    showSuccessMessage(`ব্যালেন্স সফলভাবে "${newBalance === null ? 'আনলিমিটেড' : newBalance}" সেট করা হয়েছে!`);
                    stockSetAmountInput.value = ''; 
                })
                .catch(showError);
        });
    }
}


function loadReviewsForAdmin() { reviewsRef.on('value', (snapshot) => { if(!reviewListContainer) return; reviewListContainer.innerHTML = ''; if (!snapshot.exists()) { reviewListContainer.innerHTML = '<p>কোনো রিভিউ পাওয়া যায়নি।</p>'; return; } let index = 0; snapshot.forEach(childSnapshot => { const review = childSnapshot.val(); if (!review) return; const reviewItem = document.createElement('div'); reviewItem.classList.add('review-item'); reviewItem.innerHTML = ` <span>${review.alt || 'Review Image'}</span> <div class="actions"> <button class="edit-btn" data-index="${index}">✏️ এডিট</button> <button class="delete-btn" data-index="${index}">❌ ডিলিট</button> </div> `; reviewListContainer.appendChild(reviewItem); index++; }); reviewListContainer.querySelectorAll('.edit-btn').forEach(btn => { btn.addEventListener('click', () => selectReviewForEdit(btn.dataset.index)); }); reviewListContainer.querySelectorAll('.delete-btn').forEach(btn => { btn.addEventListener('click', () => deleteReview(btn.dataset.index)); }); }); }
if(saveReviewButton) { saveReviewButton.addEventListener('click', () => { const key = reviewKeyInput.value; const reviewData = { url: reviewUrlInput.value, alt: reviewAltInput.value }; if (!reviewData.url) { alert("⚠️ অনুগ্রহ করে ছবির URL দিন।"); return; } reviewsRef.once('value', snapshot => { let reviews = snapshot.val() || []; if (!Array.isArray(reviews)) { reviews = Object.values(reviews).filter(r => r != null); } if (key !== "") { const index = parseInt(key); if (index >= 0 && index < reviews.length) { reviews[index] = reviewData; } } else { reviews.push(reviewData); } const finalReviews = reviews.filter(r => r && r.url); reviewsRef.set(finalReviews) .then(() => { showSuccessMessage("রিভিউ সেভ হয়েছে!"); clearReviewForm(); }) .catch(showError); }); }); }
function selectReviewForEdit(index) { reviewsRef.once('value', snapshot => { let reviews = snapshot.val() || []; if (!Array.isArray(reviews)) { reviews = Object.values(reviews).filter(r => r != null); } const data = reviews[parseInt(index)]; if (data) { reviewKeyInput.value = index.toString(); reviewUrlInput.value = data.url; reviewAltInput.value = data.alt; } }); }
function deleteReview(index) { if (!confirm("আপনি কি সত্যিই এই রিভিউটি ডিলিট করতে চান?")) return; reviewsRef.once('value', snapshot => { let reviews = snapshot.val() || []; if (!Array.isArray(reviews)) { reviews = Object.values(reviews).filter(r => r != null); } const deleteIndex = parseInt(index); if (deleteIndex >= 0 && deleteIndex < reviews.length) { reviews.splice(deleteIndex, 1); } const finalReviews = reviews.filter(r => r && r.url); reviewsRef.set(finalReviews) .then(() => { showSuccessMessage("রিভিউ ডিলিট হয়েছে।"); clearReviewForm(); }) .catch(showError); }); }
if(clearReviewFormButton) clearReviewFormButton.addEventListener('click', clearReviewForm);
function clearReviewForm() { reviewKeyInput.value = ''; reviewUrlInput.value = ''; reviewAltInput.value = ''; }


function loadAppsForAdmin() { if(!appListContainer) return; appsRef.on('value', (snapshot) => { appListContainer.innerHTML = ''; if (!snapshot.exists()) { appListContainer.innerHTML = '<p>কোনো অ্যাপ যোগ করা হয়নি।</p>'; return; } snapshot.forEach(childSnapshot => { const appKey = childSnapshot.key; const appData = childSnapshot.val(); const appItem = document.createElement('div'); appItem.classList.add('app-item'); appItem.innerHTML = ` <span>${appData.name} <small>(${appData.app_category || 'N/A'})</small></span> <div class="actions"> <button class="edit-btn" data-key="${appKey}">✏️ এডিট</button> <button class="delete-btn" data-key="${appKey}">❌ ডিলিট</button> </div> `; appListContainer.appendChild(appItem); }); appListContainer.querySelectorAll('.edit-btn').forEach(button => { button.addEventListener('click', (e) => selectAppForEdit(e.target.dataset.key)); }); appListContainer.querySelectorAll('.delete-btn').forEach(button => { button.addEventListener('click', (e) => deleteApp(e.target.dataset.key)); }); }); }
if(saveAppButton) { saveAppButton.addEventListener('click', () => { const key = appKeyInput.value; const appData = { name: appNameInput.value, app_category: appCategoryInput.value, app_link: appLinkInput.value, mobile_guide: appMobileGuideInput.value, tv_guide: appTvGuideInput.value }; if (!appData.name || !appData.app_link) { alert("অনুগ্রহ করে অ্যাপের নাম এবং অ্যাপের লিঙ্ক দিন।"); return; } if (key) { appsRef.child(key).update(appData) .then(() => { showSuccessMessage("অ্যাপ সফলভাবে আপডেট হয়েছে!"); clearAppForm(); }) .catch(showError); } else { appsRef.push(appData) .then(() => { showSuccessMessage("নতুন অ্যাপ সফলভাবে যোগ হয়েছে!"); clearAppForm(); }) .catch(showError); } }); }
function selectAppForEdit(key) { appsRef.child(key).once('value', (snapshot) => { const data = snapshot.val(); appKeyInput.value = key; appNameInput.value = data.name; appCategoryInput.value = data.app_category || 'Android'; appLinkInput.value = data.app_link; appMobileGuideInput.value = data.mobile_guide || ''; appTvGuideInput.value = data.tv_guide || ''; document.getElementById('app-editor-form').scrollIntoView({ behavior: 'smooth' }); }); }
function deleteApp(key) { if (confirm("আপনি কি সত্যিই এই অ্যাপটি ডিলিট করতে চান?")) { appsRef.child(key).remove() .then(() => { showSuccessMessage("অ্যাপ ডিলিট করা হয়েছে।"); clearAppForm(); }) .catch(showError); } }
if(clearAppFormButton) clearAppFormButton.addEventListener('click', clearAppForm);
function clearAppForm() { appKeyInput.value = ''; appNameInput.value = ''; appCategoryInput.value = 'Android'; appLinkInput.value = ''; appMobileGuideInput.value = ''; appTvGuideInput.value = ''; }


function loadFaqsForAdmin() { if(!faqListContainer) return; faqsRef.orderByChild("order").on('value', (snapshot) => { faqListContainer.innerHTML = ''; if (!snapshot.exists()) { faqListContainer.innerHTML = '<p>কোনো প্রশ্নাবলী যোগ করা হয়নি।</p>'; return; } snapshot.forEach(childSnapshot => { const faqKey = childSnapshot.key; const faqData = childSnapshot.val(); const faqItem = document.createElement('div'); faqItem.classList.add('faq-item'); faqItem.innerHTML = ` <span> (Order: ${faqData.order || 'N/A'}) ${faqData.question} <p>${(faqData.answer || '').substring(0, 100)}...</p> </span> <div class="actions"> <button class="edit-btn" data-key="${faqKey}">✏️ এডিট</button> <button class="delete-btn" data-key="${faqKey}">❌ ডিলিট</button> </div> `; faqListContainer.appendChild(faqItem); }); faqListContainer.querySelectorAll('.edit-btn').forEach(button => { button.addEventListener('click', (e) => selectFaqForEdit(e.target.dataset.key)); }); faqListContainer.querySelectorAll('.delete-btn').forEach(button => { button.addEventListener('click', (e) => deleteFaq(e.target.dataset.key)); }); }); }
if(saveFaqButton) { saveFaqButton.addEventListener('click', () => { const key = faqKeyInput.value; const order = parseInt(faqOrderInput.value); const faqData = { question: faqQuestionInput.value, answer: faqAnswerInput.value, order: isNaN(order) ? 0 : order }; if (!faqData.question || !faqData.answer) { alert("অনুগ্রহ করে প্রশ্ন এবং উত্তর উভয়ই দিন।"); return; } if (key) { faqsRef.child(key).update(faqData) .then(() => { showSuccessMessage("প্রশ্ন সফলভাবে আপডেট হয়েছে!"); clearFaqForm(); }) .catch(showError); } else { faqsRef.push(faqData) .then(() => { showSuccessMessage("নতুন প্রশ্ন সফলভাবে যোগ হয়েছে!"); clearFaqForm(); }) .catch(showError); } }); }
function selectFaqForEdit(key) { faqsRef.child(key).once('value', (snapshot) => { const data = snapshot.val(); faqKeyInput.value = key; faqQuestionInput.value = data.question; faqAnswerInput.value = data.answer; faqOrderInput.value = data.order || ''; document.getElementById('faq-editor-form').scrollIntoView({ behavior: 'smooth' }); }); }
function deleteFaq(key) { if (confirm("আপনি কি সত্যিই এই প্রশ্নটি ডিলিট করতে চান?")) { faqsRef.child(key).remove() .then(() => { showSuccessMessage("প্রশ্ন ডিলিট করা হয়েছে।"); clearFaqForm(); }) .catch(showError); } }
if(clearFaqFormButton) clearFaqFormButton.addEventListener('click', clearFaqForm);
function clearFaqForm() { faqKeyInput.value = ''; faqQuestionInput.value = ''; faqAnswerInput.value = ''; faqOrderInput.value = ''; }


function loadPaymentSettings() { paymentSettingsRef.on('value', (snapshot) => { const data = snapshot.val(); if (data) { if(paymentBkashInput) paymentBkashInput.value = data.bkash || ''; if(paymentNagadInput) paymentNagadInput.value = data.nagad || ''; if(paymentRocketInput) paymentRocketInput.value = data.rocket || ''; if(paymentUpayInput) paymentUpayInput.value = data.upay || ''; if(paymentVideoGuideInput) paymentVideoGuideInput.value = data.video_guide || ''; if(paymentWhatsappInput) paymentWhatsappInput.value = data.whatsapp || ''; if(paymentDeviceListInput) paymentDeviceListInput.value = (data.device_list || []).join('\n'); if(paymentEnableUsernameInput) paymentEnableUsernameInput.checked = data.enable_username || false; } }); }
if(savePaymentSettingsButton) { savePaymentSettingsButton.addEventListener('click', () => { const deviceListArray = paymentDeviceListInput.value.split('\n').filter(d => d.trim() !== ''); const settingsData = { bkash: paymentBkashInput.value, nagad: paymentNagadInput.value, rocket: paymentRocketInput.value, upay: paymentUpayInput.value, video_guide: paymentVideoGuideInput.value, whatsapp: paymentWhatsappInput.value, device_list: deviceListArray, enable_username: paymentEnableUsernameInput.checked }; paymentSettingsRef.update(settingsData) .then(() => showSuccessMessage("পেমেন্ট সেটিং সফলভাবে সেভ হয়েছে!")) .catch(showError); }); }


function getYouTubeVideoID(url) { let videoId = ''; if (!url) return null; if (url.includes("watch?v=")) videoId = url.split('v=')[1].split('&')[0]; else if (url.includes("youtu.be/")) videoId = url.split('youtu.be/')[1].split('?')[0]; else if (url.includes("/embed/")) videoId = url.split('/embed/')[1].split('?')[0]; else if (url.includes("/shorts/")) videoId = url.split('/shorts/')[1].split('?')[0]; return videoId || null; }
function loadVideosForAdmin() { if(!videoListContainer) return; videosRef.orderByChild("order").on('value', (snapshot) => { videoListContainer.innerHTML = ''; if (!snapshot.exists()) { videoListContainer.innerHTML = '<p>কোনো ভিডিও যোগ করা হয়নি।</p>'; return; } snapshot.forEach(childSnapshot => { const videoKey = childSnapshot.key; const videoData = childSnapshot.val(); const videoItem = document.createElement('div'); videoItem.classList.add('video-item'); videoItem.innerHTML = ` <span> (Order: ${videoData.order || 'N/A'}) ${videoData.title} </span> <div class="actions"> <button class="edit-btn" data-key="${videoKey}">✏️ এডিট</button> <button class="delete-btn" data-key="${videoKey}">❌ ডিলিট</button> </div> `; videoListContainer.appendChild(videoItem); }); videoListContainer.querySelectorAll('.edit-btn').forEach(button => { button.addEventListener('click', (e) => selectVideoForEdit(e.target.dataset.key)); }); videoListContainer.querySelectorAll('.delete-btn').forEach(button => { button.addEventListener('click', (e) => deleteVideo(e.target.dataset.key)); }); }); }
if(saveVideoButton) { saveVideoButton.addEventListener('click', () => { const key = videoKeyInput.value; const originalUrl = videoUrlInput.value; const videoId = getYouTubeVideoID(originalUrl); if (!videoTitleInput.value || !originalUrl) { alert("অনুগ্রহ করে ভিডিওর টাইটেল এবং URL উভয়ই দিন।"); return; } if (!videoId) { alert("অবৈধ ইউটিউব লিঙ্ক। দয়া করে 'watch?v=', 'youtu.be/' বা 'shorts/' লিঙ্ক ব্যবহার করুন।"); return; } let thumbnailUrl = videoThumbnailInput.value; if (!thumbnailUrl) { thumbnailUrl = `https://i.ytimg.com/vi/${videoId}/hqdefault.jpg`; } const order = parseInt(videoOrderInput.value); const videoData = { title: videoTitleInput.value, url: `https://www.youtube.com/embed/${videoId}`, thumbnail: thumbnailUrl, description: videoDescriptionInput.value, order: isNaN(order) ? 0 : order }; if (key) { videosRef.child(key).update(videoData) .then(() => { showSuccessMessage("ভিডিও সফলভাবে আপডেট হয়েছে!"); clearVideoForm(); }) .catch(showError); } else { videosRef.push(videoData) .then(() => { showSuccessMessage("নতুন ভিডিও সফলভাবে যোগ হয়েছে!"); clearVideoForm(); }) .catch(showError); } }); }
function selectVideoForEdit(key) { videosRef.child(key).once('value', (snapshot) => { const data = snapshot.val(); videoKeyInput.value = key; videoTitleInput.value = data.title; videoUrlInput.value = data.url; videoThumbnailInput.value = data.thumbnail || ''; videoDescriptionInput.value = data.description || ''; videoOrderInput.value = data.order || ''; document.getElementById('video-editor-form').scrollIntoView({ behavior: 'smooth' }); }); }
function deleteVideo(key) { if (confirm("আপনি কি সত্যিই এই ভিডিওটি ডিলিট করতে চান?")) { videosRef.child(key).remove() .then(() => { showSuccessMessage("ভিডিও ডিলিট করা হয়েছে।"); clearVideoForm(); }) .catch(showError); } }
if(clearVideoFormButton) clearVideoFormButton.addEventListener('click', clearVideoForm);
function clearVideoForm() { videoKeyInput.value = ''; videoTitleInput.value = ''; videoUrlInput.value = ''; videoThumbnailInput.value = ''; videoDescriptionInput.value = ''; videoOrderInput.value = ''; }


function loadSupportLinksForAdmin() { supportLinksRef.on('value', snapshot => { const supportData = snapshot.val() || {}; if(supportMainWhatsapp) supportMainWhatsapp.value = supportData.main_whatsapp || ''; if(supportMainMessenger) supportMainMessenger.value = supportData.main_messenger || ''; supportSections.forEach(section => { const listName = section.dataset.listName; const container = section.querySelector('.support-link-list') || document.getElementById(`${listName}_list_container`); if(!container) return; container.innerHTML = ''; const list = supportData[listName] || []; const listArray = Array.isArray(list) ? list : Object.values(list); if (listArray.length === 0) { container.innerHTML = '<p>কোনো লিঙ্ক পাওয়া যায়নি।</p>'; return; } listArray.forEach((item, index) => { if (!item) return; const itemEl = document.createElement('div'); itemEl.classList.add('link-item'); itemEl.innerHTML = ` <span>${item.name}</span> <div class="actions"> <button class="edit-btn" data-index="${index}" data-list="${listName}">✏️ এডিট</button> <button class="delete-btn" data-index="${index}" data-list="${listName}">❌ ডিলিট</button> </div> `; container.appendChild(itemEl); }); container.querySelectorAll('.edit-btn').forEach(btn => { btn.addEventListener('click', () => selectSupportLinkForEdit(btn.dataset.list, btn.dataset.index)); }); container.querySelectorAll('.delete-btn').forEach(btn => { btn.addEventListener('click', () => deleteSupportLink(btn.dataset.list, btn.dataset.index)); }); }); }); }
if(saveMainSupportButton) { saveMainSupportButton.addEventListener('click', () => { supportLinksRef.update({ main_whatsapp: supportMainWhatsapp.value, main_messenger: supportMainMessenger.value }) .then(() => showSuccessMessage("প্রধান সাপোর্ট লিঙ্ক সেভ হয়েছে!")) .catch(showError); }); }
function selectSupportLinkForEdit(listName, index) { const listRef = supportLinksRef.child(listName); listRef.once('value', snapshot => { let list = snapshot.val() || []; if (!Array.isArray(list)) list = Object.values(list); const item = list[parseInt(index)]; if (!item) return; const section = document.querySelector(`.sub-editor-section[data-list-name="${listName}"]`); if (!section) return; const nameInput = section.querySelector('.new-link-name'); const urlInput = section.querySelector('.new-link-url'); const addButton = section.querySelector('.add-link-btn'); nameInput.value = item.name; urlInput.value = item.url; addButton.textContent = '💾 সেভ পরিবর্তন'; addButton.dataset.editingIndex = index; }); }
supportSections.forEach(section => { const listName = section.dataset.listName; const addButton = section.querySelector('.add-link-btn'); if (!addButton) return; const nameInput = section.querySelector('.new-link-name'); const urlInput = section.querySelector('.new-link-url'); const originalButtonText = addButton.textContent; addButton.addEventListener('click', () => { const newLink = { name: nameInput.value, url: urlInput.value }; if (!newLink.name || !newLink.url) { alert("অনুগ্রহ করে নাম এবং URL উভয়ই দিন।"); return; } const listRef = supportLinksRef.child(listName); const editingIndex = addButton.dataset.editingIndex; listRef.once('value', snapshot => { let list = snapshot.val() || []; if (!Array.isArray(list)) { list = Object.values(list).filter(item => item != null); } if (editingIndex !== undefined) { list[parseInt(editingIndex)] = newLink; } else { list.push(newLink); } listRef.set(list.filter(item => item != null)) .then(() => { showSuccessMessage(editingIndex !== undefined ? "লিঙ্ক সফলভাবে আপডেট হয়েছে!" : "নতুন লিঙ্ক সফলভাবে যোগ হয়েছে!"); nameInput.value = ''; urlInput.value = ''; delete addButton.dataset.editingIndex; addButton.textContent = originalButtonText; }) .catch(showError); }); }); });
function deleteSupportLink(listName, index) { if (!confirm("আপনি কি সত্যিই এই লিঙ্কটি ডিলিট করতে চান?")) return; const listRef = supportLinksRef.child(listName); listRef.once('value', snapshot => { let list = snapshot.val() || []; if (!Array.isArray(list)) { list = Object.values(list).filter(item => item != null); } list.splice(index, 1); listRef.set(list.filter(item => item != null)) .then(() => showSuccessMessage("লিঙ্ক ডিলিট হয়েছে।")) .catch(showError); }); }


function initializeSalesLogListeners() {
    if(filterSalesButton) {
        filterSalesButton.addEventListener('click', filterSalesByDate);
    }

    if(clearFilterSalesButton) {
        clearFilterSalesButton.addEventListener('click', () => {
            salesStartDateInput.value = '';
            salesEndDateInput.value = '';
            if(salesSearchInput) salesSearchInput.value = '';
            
            currentPackageFilter = null; 
            showFullReportView(); 
            
            orderTypeFilterButtons.forEach(btn => btn.classList.remove('active'));
            document.querySelector('#order-type-filters .stat-filter-btn[data-type="all"]').classList.add('active');
            currentOrderTypeFilter = 'all';

            refreshSalesTableView();
            
            calculateLifetimeStats(allSalesLogs);
            calculatePaymentMethodStats(allSalesLogs);
            calculatePackageSalesStats(allSalesLogs);
            
            displayPaymentMethodStats(getActivePaymentPeriod());
            displayPackageSalesStats(getActivePackagePeriod(), getActiveOrderType());
        });
    }

    if (orderTypeFilterButtonsContainer) {
        orderTypeFilterButtons.forEach(button => {
            button.addEventListener('click', () => {
                orderTypeFilterButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
                currentOrderTypeFilter = button.dataset.type;
                
                refreshSalesTableView();
                displayPackageSalesStats(getActivePackagePeriod(), currentOrderTypeFilter);
            });
        });
    }
    
    if (salesLogTbody) {
        salesLogTbody.addEventListener('click', (e) => {
            const target = e.target.closest('button'); 
            if (!target) return; 

            if (target.classList.contains('edit-sales-btn')) {
                openSalesEditModal(target.dataset.key);
            } else if (target.classList.contains('delete-sales-btn')) {
                deleteSalesLog(target.dataset.key);
            }
        });
    }
    
    if(modalCloseButton) modalCloseButton.addEventListener('click', closeSalesEditModal);
    if(cancelSalesEditButton) cancelSalesEditButton.addEventListener('click', closeSalesEditModal);
    if(saveSalesEditButton) saveSalesEditButton.addEventListener('click', saveSalesEdit);
    
    paymentStatsFilterButtons.forEach(button => {
        button.addEventListener('click', () => {
            paymentStatsFilterButtons.forEach(btn => btn.classList.remove('active'));
            button.classList.add('active');
            const period = button.dataset.period;
            displayPaymentMethodStats(period);
        });
    });
    
    packageStatsFilterButtons.forEach(button => {
        button.addEventListener('click', () => {
            packageStatsFilterButtons.forEach(btn => btn.classList.remove('active'));
            button.classList.add('active');
            const period = button.dataset.period;
            displayPackageSalesStats(period, getActiveOrderType());
        });
    });

    if (packageSalesStatsContainer) {
        packageSalesStatsContainer.addEventListener('click', (e) => {
            const target = e.target.closest('.package-stat-item');
            if (target && target.dataset.packageName) {
                filterByPackage(target.dataset.packageName);
            }
        });
    }

    if (backToFullReportBtn) {
        backToFullReportBtn.addEventListener('click', () => {
            currentPackageFilter = null; 
            showFullReportView();
            refreshSalesTableView(); 
            
            calculateLifetimeStats(allSalesLogs);
            calculatePaymentMethodStats(allSalesLogs);
            calculatePackageSalesStats(allSalesLogs);
            displayPaymentMethodStats(getActivePaymentPeriod());
            displayPackageSalesStats(getActivePackagePeriod(), getActiveOrderType());
        });
    }

    if(salesSearchBtn) {
        salesSearchBtn.addEventListener('click', filterSalesBySearch);
    }
    if(salesSearchClearBtn) {
        salesSearchClearBtn.addEventListener('click', () => {
            if(salesSearchInput) salesSearchInput.value = '';
            refreshSalesTableView();
        });
    }
}

function filterSalesBySearch() {
    const query = salesSearchInput.value.trim();
    if (!query) {
        alert("অনুগ্রহ করে সার্চ বক্সে একটি WhatsApp নম্বর লিখুন।");
        return;
    }
    
    const filteredLogs = allSalesLogs.filter(logItem => {
        const whatsapp = logItem.data.customerWhatsapp || "";
        return whatsapp.includes(query);
    });
    
    displaySales(filteredLogs);
    let totalSales = 0;
    let totalOrders = 0;
    filteredLogs.forEach(log => {
        totalSales += log.data.amount || 0;
        totalOrders++;
    });
    filteredTotalSalesEl.textContent = `৳ ${totalSales}`;
    filteredTotalOrdersEl.textContent = totalOrders;
}

function refreshSalesTableView() {
    const startDateValue = salesStartDateInput.value;
    const endDateValue = salesEndDateInput.value;

    let logsToShow = [];

    if (currentPackageFilter) {
        let packageLogs = allSalesLogs.filter(logItem => (logItem.data.packageName || "Unknown Package") === currentPackageFilter);
        
        if (startDateValue && endDateValue) {
            const startTime = new Date(startDateValue + "T00:00:00Z").getTime();
            const endTime = new Date(endDateValue + "T23:59:59Z").getTime();
            logsToShow = packageLogs.filter(logItem => {
                return logItem.data.timestamp >= startTime && logItem.data.timestamp <= endTime;
            });
        } else {
            logsToShow = packageLogs;
        }
    } else if (startDateValue && endDateValue) {
        const startTime = new Date(startDateValue + "T00:00:00Z").getTime();
        const endTime = new Date(endDateValue + "T23:59:59Z").getTime();
        logsToShow = allSalesLogs.filter(logItem => {
            return logItem.data.timestamp >= startTime && logItem.data.timestamp <= endTime;
        });
    } else {
        logsToShow = getTodayLogs();
    }
    
    displaySales(logsToShow);
}


function showPackageReportView(packageName) {
    if (salesStatsWrapper) salesStatsWrapper.classList.add('hidden');
    if (backToFullReportBtn) backToFullReportBtn.classList.remove('hidden');
    if (salesReportTitle) salesReportTitle.innerHTML = `<i class="fas fa-box-open"></i> প্যাকেজ রিপোর্ট: ${packageName}`;
}

function showFullReportView() {
    if (salesStatsWrapper) salesStatsWrapper.classList.remove('hidden');
    if (backToFullReportBtn) backToFullReportBtn.classList.add('hidden');
    if (salesReportTitle) salesReportTitle.innerHTML = `<i class="fas fa-chart-line"></i> সেলস রিপোর্ট (সম্পূর্ণ)`;
}


function formatTimestampToDateTime(timestamp) {
    const date = new Date(timestamp);
    const options = {
        year: 'numeric', month: 'short', day: 'numeric',
        hour: '2-digit', minute: '2-digit', hour12: true
    };
    const yyyyMmDd = date.toISOString().split('T')[0];
    const displayTime = date.toLocaleString('en-US', options);
    return { yyyyMmDd, displayTime };
}

function getTodayLogs() {
    const now = Date.now() + serverOffset;
    const today_bdt_string = getBdtDateString(now);
    
    return allSalesLogs.filter(logItem => {
        const log_bdt_string = getBdtDateString(logItem.data.timestamp);
        return log_bdt_string === today_bdt_string;
    });
}

function getYesterdayLogs() {
    const now = Date.now() + serverOffset;
    const yesterdayTimestamp = now - (24 * 60 * 60 * 1000); 
    const yesterday_bdt_string = getBdtDateString(yesterdayTimestamp);
    
    return allSalesLogs.filter(logItem => {
        const log_bdt_string = getBdtDateString(logItem.data.timestamp);
        return log_bdt_string === yesterday_bdt_string;
    });
}


function loadSalesLog() {
    if (!salesLogTbody) return;
    
    salesLogRef.orderByChild("timestamp").on('value', (snapshot) => {
        allSalesLogs = []; 
        if (!snapshot.exists()) {
            displaySales([]); 
            calculateLifetimeStats([]); 
            calculatePaymentMethodStats([]); 
            calculatePackageSalesStats([]); 
            calculateAndDisplayReminders([]); 
            displayPaymentMethodStats('today'); 
            displayPackageSalesStats('today', 'all'); 
            return;
        }
        
        snapshot.forEach(childSnapshot => {
            allSalesLogs.push({
                key: childSnapshot.key, 
                data: childSnapshot.val()
            });
        });
        
        allSalesLogs.reverse();
        
        calculateLifetimeStats(allSalesLogs); 
        calculatePaymentMethodStats(allSalesLogs); 
        calculatePackageSalesStats(allSalesLogs);
        calculateAndDisplayReminders(allSalesLogs);
        
        displayPaymentMethodStats(getActivePaymentPeriod()); 
        displayPackageSalesStats(getActivePackagePeriod(), getActiveOrderType()); 

        refreshSalesTableView();
    });
}

function displaySales(logs) {
    if (!salesLogTbody) return;
    
    let filteredLogs = logs;
    if (currentOrderTypeFilter === 'paid') {
        filteredLogs = logs.filter(logItem => getOrderType(logItem.data.duration) === 'paid');
    } else if (currentOrderTypeFilter === 'trial') {
        filteredLogs = logs.filter(logItem => getOrderType(logItem.data.duration) === 'trial');
    }

    salesLogTbody.innerHTML = '';
    
    if (filteredLogs.length === 0) {
        salesLogTbody.innerHTML = '<tr class="no-data-row"><td colspan="9">এই ফিল্টারে কোনো সেলস পাওয়া যায়নি।</td></tr>';
        filteredTotalSalesEl.textContent = '৳ ০';
        filteredTotalOrdersEl.textContent = '০';
        return;
    }

    let totalSales = 0;
    let totalOrders = 0;

    filteredLogs.forEach(logItem => { 
        const log = logItem.data; 
        const key = logItem.key; 
        
        const { displayTime } = formatTimestampToDateTime(log.timestamp);
        const amount = log.amount || 0;
        
        const row = document.createElement('tr');
        row.innerHTML = `
            <td>${displayTime}</td>
            <td>${log.packageName || 'N/A'}</td>
            <td>${log.username || '-'}</td>
            <td>${log.duration || 'N/A'}</td>
            <td>${log.paymentMethod || 'N/A'}</td>
            <td>${log.trxId || 'N/A'}</td>
            <td>${log.customerWhatsapp || 'N/A'}</td> 
            <td>${amount}</td>
            <td>
                <button class="sales-action-btn edit-btn edit-sales-btn" data-key="${key}">✏️</button>
                <button class="sales-action-btn delete-btn delete-sales-btn" data-key="${key}">❌</button>
            </td>
        `;
        salesLogTbody.appendChild(row);

        totalSales += amount;
        totalOrders++;
    });

    filteredTotalSalesEl.textContent = `৳ ${totalSales}`;
    filteredTotalOrdersEl.textContent = totalOrders;
}

function calculateLifetimeStats(logs) {
    let totalSales7 = 0;
    let totalSales30 = 0;
    let allTimeSales = 0;
    
    let totalOrders7 = 0; 
    let totalOrders30 = 0; 
    let allTimeOrders = 0; 

    const now = Date.now() + serverOffset;
    const today = new Date(now + (6 * 3600 * 1000)).setUTCHours(0, 0, 0, 0); 
    
    const sevenDaysAgo = today - (6 * 24 * 60 * 60 * 1000); 
    const thirtyDaysAgo = today - (29 * 24 * 60 * 60 * 1000); 

    logs.forEach(logItem => {
        const log = logItem.data;
        const amount = log.amount || 0;
        const timestamp = log.timestamp;

        allTimeSales += amount;
        allTimeOrders++; 

        if (timestamp >= thirtyDaysAgo) {
            totalSales30 += amount;
            totalOrders30++; 
        }

        if (timestamp >= sevenDaysAgo) {
            totalSales7 += amount;
            totalOrders7++; 
        }
    });

    if (last7DaysSalesEl) last7DaysSalesEl.textContent = `৳ ${totalSales7}`;
    if (last30DaysSalesEl) last30DaysSalesEl.textContent = `৳ ${totalSales30}`;
    if (allTimeSalesEl) allTimeSalesEl.textContent = `৳ ${allTimeSales}`;
    
    if (last7DaysOrdersEl) last7DaysOrdersEl.textContent = totalOrders7;
    if (last30DaysOrdersEl) last30DaysOrdersEl.textContent = totalOrders30;
    if (allTimeOrdersEl) allTimeOrdersEl.textContent = allTimeOrders;
}

function calculatePaymentMethodStats(logs) {
    paymentMethodStats = {
        bkash: { today: 0, yesterday: 0, '7days': 0, '30days': 0, all: 0 },
        nagad: { today: 0, yesterday: 0, '7days': 0, '30days': 0, all: 0 },
        rocket: { today: 0, yesterday: 0, '7days': 0, '30days': 0, all: 0 },
        upay: { today: 0, yesterday: 0, '7days': 0, '30days': 0, all: 0 }
    };

    const now = Date.now() + serverOffset;
    const today_bdt_string = getBdtDateString(now);
    const yesterday_bdt_string = getBdtDateString(now - (24 * 60 * 60 * 1000));
    
    const today = new Date(now + (6 * 3600 * 1000)).setUTCHours(0, 0, 0, 0); 
    const sevenDaysAgo = today - (6 * 24 * 60 * 60 * 1000); 
    const thirtyDaysAgo = today - (29 * 24 * 60 * 60 * 1000); 

    logs.forEach(logItem => {
        const log = logItem.data;
        const amount = log.amount || 0;
        const timestamp = log.timestamp;
        const method = (log.paymentMethod || 'N/A').toLowerCase();
        
        const logDateStr_bdt = getBdtDateString(timestamp);
        
        let statsKey = null;
        if (method === 'bkash') statsKey = 'bkash';
        else if (method === 'nagad') statsKey = 'nagad';
        else if (method === 'rocket') statsKey = 'rocket';
        else if (method === 'upay') statsKey = 'upay';
        
        if (statsKey) {
            paymentMethodStats[statsKey].all += amount;
            
            if (timestamp >= thirtyDaysAgo) {
                paymentMethodStats[statsKey]['30days'] += amount;
            }
            
            if (timestamp >= sevenDaysAgo) {
                paymentMethodStats[statsKey]['7days'] += amount;
            }

            if (logDateStr_bdt === yesterday_bdt_string) {
                paymentMethodStats[statsKey].yesterday += amount;
            }
            
            if (logDateStr_bdt === today_bdt_string) {
                paymentMethodStats[statsKey].today += amount;
            }
        }
    });
}

function displayPaymentMethodStats(period) {
    if (!bkashSalesEl || !nagadSalesEl || !rocketSalesEl || !upaySalesEl) return;
    
    bkashSalesEl.textContent = `৳ ${paymentMethodStats.bkash[period] || 0}`;
    nagadSalesEl.textContent = `৳ ${paymentMethodStats.nagad[period] || 0}`;
    rocketSalesEl.textContent = `৳ ${paymentMethodStats.rocket[period] || 0}`;
    upaySalesEl.textContent = `৳ ${paymentMethodStats.upay[period] || 0}`;
}

function getActivePaymentPeriod() {
    const activeButton = paymentStatsFilterButtonsContainer.querySelector('.stat-filter-btn.active');
    return activeButton ? activeButton.dataset.period : 'today'; 
}

function getActiveOrderType() {
    const activeButton = orderTypeFilterButtonsContainer.querySelector('.stat-filter-btn.active');
    return activeButton ? activeButton.dataset.type : 'all';
}


function calculatePackageSalesStats(logs) {
    packageSalesStats = {}; 

    const now = Date.now() + serverOffset;
    const today_bdt_string = getBdtDateString(now);
    const yesterday_bdt_string = getBdtDateString(now - (24 * 60 * 60 * 1000));

    const today = new Date(now + (6 * 3600 * 1000)).setUTCHours(0, 0, 0, 0); 
    const sevenDaysAgo = today - (6 * 24 * 60 * 60 * 1000); 
    const thirtyDaysAgo = today - (29 * 24 * 60 * 60 * 1000); 

    logs.forEach(logItem => {
        const log = logItem.data;
        const timestamp = log.timestamp;
        const packageName = log.packageName || "Unknown Package";
        
        const orderType = getOrderType(log.duration);
        
        if (!packageSalesStats[packageName]) {
            packageSalesStats[packageName] = {
                today: { all: 0, paid: 0, trial: 0 },
                yesterday: { all: 0, paid: 0, trial: 0 },
                '7days': { all: 0, paid: 0, trial: 0 },
                '30days': { all: 0, paid: 0, trial: 0 },
                all: { all: 0, paid: 0, trial: 0 }
            };
        }
        
        const logDateStr_bdt = getBdtDateString(timestamp);
        
        packageSalesStats[packageName].all.all++;
        packageSalesStats[packageName].all[orderType]++;
        
        if (timestamp >= thirtyDaysAgo) {
            packageSalesStats[packageName]['30days'].all++;
            packageSalesStats[packageName]['30days'][orderType]++;
        }
        
        if (timestamp >= sevenDaysAgo) {
            packageSalesStats[packageName]['7days'].all++;
            packageSalesStats[packageName]['7days'][orderType]++;
        }

        if (logDateStr_bdt === yesterday_bdt_string) {
            packageSalesStats[packageName].yesterday.all++;
            packageSalesStats[packageName].yesterday[orderType]++;
        }
        
        if (logDateStr_bdt === today_bdt_string) {
            packageSalesStats[packageName].today.all++;
            packageSalesStats[packageName].today[orderType]++;
        }
    });
}

function displayPackageSalesStats(period, orderType) {
    if (!packageSalesStatsContainer) return;
    packageSalesStatsContainer.innerHTML = ''; 

    const sortedPackages = Object.keys(packageSalesStats).sort((a, b) => {
        const countB = (packageSalesStats[b][period] && packageSalesStats[b][period][orderType]) ? packageSalesStats[b][period][orderType] : 0;
        const countA = (packageSalesStats[a][period] && packageSalesStats[a][period][orderType]) ? packageSalesStats[a][period][orderType] : 0;
        return countB - countA;
    });

    if (sortedPackages.length === 0) {
        packageSalesStatsContainer.innerHTML = '<p>কোনো প্যাকেজ সেলস ডেটা পাওয়া যায়নি।</p>';
        return;
    }

    let itemsFound = false; 
    sortedPackages.forEach(packageName => {
        const count = (packageSalesStats[packageName][period] && packageSalesStats[packageName][period][orderType]) ? packageSalesStats[packageName][period][orderType] : 0;
        
        if (count > 0) { 
            itemsFound = true; 
            const itemEl = document.createElement('div');
            itemEl.classList.add('package-stat-item');
            itemEl.dataset.packageName = packageName; 
            itemEl.innerHTML = `
                <span class="package-name">${packageName}</span>
                <span class="package-count">${count}</span>
            `;
            packageSalesStatsContainer.appendChild(itemEl);
        }
    });
    
    if (!itemsFound) { 
        packageSalesStatsContainer.innerHTML = '<p>এই ফিল্টারে কোনো প্যাকেজ সেল হয়নি।</p>';
    }
}

function getActivePackagePeriod() {
    const activeButton = packageStatsFilterButtonsContainer.querySelector('.stat-filter-btn.active');
    return activeButton ? activeButton.dataset.period : 'today'; 
}


function filterByPackage(packageName) {
    currentPackageFilter = packageName; 
    showPackageReportView(packageName); 
    refreshSalesTableView();
}


function filterSalesByDate() {
    currentPackageFilter = null;
    showFullReportView();
    
    const startDateValue = salesStartDateInput.value;
    const endDateValue = salesEndDateInput.value;

    if (!startDateValue || !endDateValue) {
        alert("অনুগ্রহ করে শুরু এবং শেষ উভয় তারিখ সিলেক্ট করুন।");
        return;
    }
    
    refreshSalesTableView();
}

function deleteSalesLog(key) {
    if (confirm("আপনি কি সত্যিই এই সেলস লগটি ডিলিট করতে চান? এটি মোট সেলস এবং মোট অর্ডার থেকেও বিয়োগ হয়ে যাবে।")) {
        
        salesLogRef.child(key).once('value', (snapshot) => {
            if (!snapshot.exists()) {
                showError({ message: "লগটি পাওয়া যায়নি, সম্ভবত আগেই ডিলিট করা হয়েছে।" });
                return;
            }
            
            const logData = snapshot.val();
            const amountToDelete = logData.amount || 0; 
            
            const duration = logData.duration || "";
            const packageNameFromLog = logData.packageName || "";
            let amountToRefund = 0; 

            const safeDuration = toEnglishNumber(duration.toLowerCase());
            
            if (safeDuration.includes("ঘন্টা") || safeDuration.includes("hour")) {
                amountToRefund = 0;
            } 
            else if (safeDuration.includes("12 মাস") || safeDuration.includes("1 বছর") || safeDuration.includes("1 year") || safeDuration.includes("12 month")) {
                amountToRefund = 10;
            } 
            else if (safeDuration.includes("6 মাস") || safeDuration.includes("6 month")) {
                amountToRefund = 5;
            } 
            else if (safeDuration.includes("3 মাস") || safeDuration.includes("3 month")) {
                amountToRefund = 3;
            } 
            else if (safeDuration.includes("1 মাস") || safeDuration.includes("1 month")) {
                amountToRefund = 1;
            }


            salesLogRef.child(key).remove()
                .then(() => {
                    showSuccessMessage("সেলস লগ সফলভাবে ডিলিট হয়েছে।");
                    
                    const today_bdt = getBdtDateString(Date.now() + serverOffset);
                    const logDate_bdt = getBdtDateString(logData.timestamp);

                    if (logDate_bdt === today_bdt) {
                        if (amountToDelete > 0) {
                            visitCountsRef.child('todaySales').transaction((currentSales) => {
                                const newSales = (currentSales || 0) - amountToDelete;
                                return newSales < 0 ? 0 : newSales;
                            });
                        }
                        visitCountsRef.child('todayOrders').transaction((currentOrders) => {
                            const newOrders = (currentOrders || 0) - 1;
                            return newOrders < 0 ? 0 : newOrders;
                        });
                    }
                    
                    if (amountToRefund > 0 && packageNameFromLog) {
                        packagesRef.once("value", (pkgSnapshot) => {
                            pkgSnapshot.forEach((child) => {
                                const basePackageName = packageNameFromLog.split(" (")[0];
                                
                                if (child.val().name === basePackageName) {
                                    const packageKey = child.key;
                                    const packageStockRef = packagesRef.child(packageKey).child('balance');
                                    
                                    packageStockRef.transaction((currentBalance) => {
                                        if (currentBalance !== null && currentBalance !== undefined) {
                                            return (parseInt(currentBalance) || 0) + amountToRefund; 
                                        }
                                        return currentBalance; 
                                    });
                                }
                            });
                        });
                    }
                })
                .catch(showError);
                
        }, (error) => {
            showError(error);
        });
    }
}

function openSalesEditModal(key) {
    const logItem = allSalesLogs.find(item => item.key === key);
    if (!logItem) {
        alert("লগ খুঁজে পাওয়া যায়নি।");
        return;
    }
    
    const log = logItem.data;
    
    currentEditKey = key; 
    editSalesTimestampInput.value = formatTimestampToInput(log.timestamp);
    editPackageNameInput.value = log.packageName || '';
    editSalesUsernameInput.value = log.username || ''; 
    editDurationInput.value = log.duration || '';
    editTrxIdInput.value = log.trxId || '';
    editAmountInput.value = log.amount || 0;
    editCustomerWhatsappInput.value = log.customerWhatsapp || ''; 
    
    salesEditModal.classList.remove('hidden');
    salesEditModal.style.display = 'flex'; 
}

function closeSalesEditModal() {
    currentEditKey = null;
    salesEditModal.classList.add('hidden');
    salesEditModal.style.display = 'none'; 
    
    editSalesTimestampInput.value = '';
    editPackageNameInput.value = '';
    editSalesUsernameInput.value = ''; 
    editDurationInput.value = '';
    editTrxIdInput.value = '';
    editAmountInput.value = '';
    editCustomerWhatsappInput.value = ''; 
}

function saveSalesEdit() {
    if (!currentEditKey) {
        alert("একটি সমস্যা হয়েছে। দয়া করে আবার চেষ্টা করুন।");
        return;
    }

    const logItem = allSalesLogs.find(item => item.key === currentEditKey);
    if (!logItem) {
        alert("লগ খুঁজে পাওয়া যায়নি।");
        return;
    }
    
    const oldAmount = logItem.data.amount || 0;
    const oldTimestamp = logItem.data.timestamp; 
    
    const newAmount = parseInt(editAmountInput.value) || 0;
    const newTimestamp = formatInputToTimestamp(editSalesTimestampInput.value);
    
    if (isNaN(newTimestamp)) {
        alert("তারিখ ও সময় সঠিক নয়। দয়া করে আবার চেষ্টা করুন।");
        return;
    }
    
    const amountDifference = newAmount - oldAmount; 

    const updatedLogData = {
        packageName: editPackageNameInput.value,
        username: editSalesUsernameInput.value, 
        duration: editDurationInput.value,
        trxId: editTrxIdInput.value,
        amount: newAmount,
        customerWhatsapp: editCustomerWhatsappInput.value, 
        timestamp: newTimestamp, 
        paymentMethod: logItem.data.paymentMethod,
        device: logItem.data.device
    };

    salesLogRef.child(currentEditKey).update(updatedLogData)
        .then(() => {
            showSuccessMessage("সেলস লগ সফলভাবে আপডেট হয়েছে!");
            closeSalesEditModal();

            const today_bdt = getBdtDateString(Date.now() + serverOffset);
            const oldLogDate_bdt = getBdtDateString(oldTimestamp);
            const newLogDate_bdt = getBdtDateString(newTimestamp);

            if (oldLogDate_bdt === today_bdt && newLogDate_bdt !== today_bdt) {
                visitCountsRef.child('todaySales').transaction(current => (current || 0) - oldAmount);
                visitCountsRef.child('todayOrders').transaction(current => (current || 0) - 1);
            } 
            else if (oldLogDate_bdt !== today_bdt && newLogDate_bdt === today_bdt) {
                visitCountsRef.child('todaySales').transaction(current => (current || 0) + newAmount);
                visitCountsRef.child('todayOrders').transaction(current => (current || 0) + 1);
            } 
            else if (oldLogDate_bdt === today_bdt && newLogDate_bdt === today_bdt) {
                if (amountDifference !== 0) {
                    visitCountsRef.child('todaySales').transaction(current => (current || 0) + amountDifference);
                }
            }
        })
        .catch(showError);
}


function initializeReminderListeners() {
    if (saveReminderTemplateBtn) {
        saveReminderTemplateBtn.addEventListener('click', () => {
            const newTemplate = reminderTemplateInput.value;
            siteContentRef.child('reminders/template').set(newTemplate)
                .then(() => {
                    reminderMessageTemplate = newTemplate; 
                    showSuccessMessage("রিমাইন্ডার টেমপ্লেট সেভ হয়েছে!");
                })
                .catch(showError);
        });
    }
    
    const listsContainer = document.querySelector('.reminder-lists');
    if (listsContainer) {
        listsContainer.addEventListener('click', (e) => {
            const sendBtn = e.target.closest('.send-reminder-btn');
            const editBtn = e.target.closest('.reminder-edit-btn'); 

            if (sendBtn && !sendBtn.disabled) {
                let whatsappNum = sendBtn.dataset.whatsapp;
                const packageName = sendBtn.dataset.package;
                const expiryDate = sendBtn.dataset.expiry;
                const username = sendBtn.dataset.username || ""; // ❇️❇️ ইউজার নেম গ্রহণ ❇️❇️

                if (!whatsappNum || whatsappNum === 'N/A') {
                    alert("এই অর্ডারের সাথে কোনো WhatsApp নম্বর সেভ করা নেই।");
                    return;
                }
                
                const uniqueId = `${whatsappNum}_${packageName}_${expiryDate}`;
                
                if (whatsappNum.startsWith('01')) {
                    whatsappNum = '880' + whatsappNum.substring(1);
                } else if (whatsappNum.startsWith('+880')) {
                    whatsappNum = whatsappNum.substring(1); 
                }
                
                if (!whatsappNum.startsWith('880') || whatsappNum.length < 13) {
                     alert("এই WhatsApp নম্বরটি সঠিক নয়: " + sendBtn.dataset.whatsapp + "\nসঠিক ফরম্যাট: 01... অথবা 880...");
                     return;
                }
                
                // ❇️❇️ মেসেজ টেমপ্লেটে [username] রিপ্লেস করা ❇️❇️
                const message = reminderMessageTemplate
                    .replace(/\[package]/g, packageName)
                    .replace(/\[date]/g, expiryDate)
                    .replace(/\[username]/g, username);
                
                const url = `https://api.whatsapp.com/send?phone=${whatsappNum}&text=${encodeURIComponent(message)}`;
                window.open(url, '_blank');
                
                sentReminders.add(uniqueId); 
                saveSentReminders(sentReminders); 
                
                calculateAndDisplayReminders(allSalesLogs);
            } 
            else if (editBtn) { 
                const logKey = editBtn.dataset.logkey;
                const currentWhatsapp = editBtn.dataset.whatsapp;
                const currentTimestamp = parseInt(editBtn.dataset.timestamp);
                
                if (logKey) {
                    openReminderEditModal(logKey, currentWhatsapp, currentTimestamp); 
                } else {
                    alert("ত্রুটি: অর্ডার আইডি খুঁজে পাওয়া যায়নি।");
                }
            }
        });
    }
    
    if (sendManualReminderBtn) {
        sendManualReminderBtn.addEventListener('click', () => {
            let whatsappNum = manualReminderNumberInput.value;
            if (!whatsappNum || whatsappNum.length < 10) {
                alert("অনুগ্রহ করে একটি সঠিক WhatsApp নম্বর দিন।");
                return;
            }

            if (whatsappNum.startsWith('01')) {
                whatsappNum = '880' + whatsappNum.substring(1);
            } else if (!whatsappNum.startsWith('880')) {
                alert("অনুগ্রহ করে 880... অথবা 01... দিয়ে শুরু হওয়া সঠিক নম্বর দিন।");
                return;
            }
            
            const message = reminderMessageTemplate
                    .replace(/\[package]/g, 'আপনার প্যাকেজ')
                    .replace(/\[date]/g, 'শীঘ্রই')
                    .replace(/\[username]/g, ''); 
            
            const url = `https://api.whatsapp.com/send?phone=${whatsappNum}&text=${encodeURIComponent(message)}`;
            window.open(url, '_blank');
            manualReminderNumberInput.value = ''; 
        });
    }
    
    if (reminderModalCloseButton) reminderModalCloseButton.addEventListener('click', closeReminderEditModal);
    if (cancelReminderEditButton) cancelReminderEditButton.addEventListener('click', closeReminderEditModal);
    if (saveReminderEditButton) saveReminderEditButton.addEventListener('click', saveReminderEdit);
    
    if (copyTomorrowListBtn) copyTomorrowListBtn.addEventListener('click', () => copyReminderList('expiringTomorrowList'));
    if (copyTodayListBtn) copyTodayListBtn.addEventListener('click', () => copyReminderList('expiringTodayList'));
    if (copyExpiredListBtn) copyExpiredListBtn.addEventListener('click', () => copyReminderList('expiredRecentlyList'));
    if (copyActiveListBtn) copyActiveListBtn.addEventListener('click', () => copyReminderList('activeNowList'));
    if (copySentListBtn) copySentListBtn.addEventListener('click', () => copyReminderList('sentMessagesList'));

    if (reminderSearchBtn) {
        reminderSearchBtn.addEventListener('click', filterRemindersBySearch);
    }
    if (reminderSearchClearBtn) {
        reminderSearchClearBtn.addEventListener('click', () => {
            if (reminderSearchInput) reminderSearchInput.value = '';
            document.querySelectorAll('.reminder-item').forEach(item => item.style.display = '');
        });
    }
}

function filterRemindersBySearch() {
    const query = reminderSearchInput.value.trim();
    if (!query) {
        alert("অনুগ্রহ করে সার্চ বক্সে একটি WhatsApp নম্বর লিখুন।");
        return;
    }

    const allReminderItems = document.querySelectorAll('.reminder-item');
    let found = false;

    allReminderItems.forEach(item => {
        const whatsappNum = item.querySelector('.whatsapp-num').textContent;
        if (whatsappNum.includes(query)) {
            item.style.display = ''; 
            found = true;
            const details = item.closest('details');
            if(details) details.open = true;
        } else {
            item.style.display = 'none'; 
        }
    });

    if (!found) {
        alert("কোনো রিমাইন্ডার খুঁজে পাওয়া যায়নি।");
    }
}

function copyReminderList(listId) {
    const listContainer = document.getElementById(listId);
    if (!listContainer) return;
    
    const numbers = [];
    listContainer.querySelectorAll('.reminder-item').forEach(item => {
        if (item.style.display !== 'none') {
            const num = item.querySelector('.whatsapp-num').textContent;
            if (num && num !== 'N/A') {
                numbers.push(num);
            }
        }
    });
    
    if (numbers.length === 0) {
        alert("এই লিস্টে কপি করার মতো কোনো নম্বর নেই।");
        return;
    }
    
    const numberString = numbers.join(',');
    navigator.clipboard.writeText(numberString)
        .then(() => {
            showSuccessMessage(`${numbers.length} টি নম্বর ক্লিপবোর্ডে কপি করা হয়েছে।`);
        })
        .catch(err => {
            showError({ message: "নম্বর কপি করা যায়নি।" });
            console.error('Copy failed', err);
        });
}


function loadReminderTemplate() {
    siteContentRef.child('reminders/template').on('value', (snapshot) => {
        if (snapshot.exists()) {
            const template = snapshot.val();
            reminderMessageTemplate = template;
            if (reminderTemplateInput) {
                reminderTemplateInput.value = template;
            }
        } else {
            if (reminderTemplateInput) {
                reminderMessageTemplate = "প্রিয় গ্রাহক [username], আপনার [package] প্যাকেজটির মেয়াদ [date] তারিখে শেষ হয়ে যাচ্ছে। রিনিউ করতে যোগাযোগ করুন।";
                reminderTemplateInput.value = reminderMessageTemplate;
            }
        }
    });
}


function calculateExpiryDate(log, customTimestamp = null) {
    const durationFullString = log.duration || "";
    const englishDurationString = toEnglishNumber(durationFullString);
    const match = englishDurationString.match(/^(\d+)/); 
    const durationValue = match ? parseInt(match[0]) : NaN; 
    
    if (isNaN(durationValue)) {
        return null;
    }

    const startDate = new Date(customTimestamp || log.timestamp); 
    
    const options = { 
        day: 'numeric', 
        month: 'short', 
        year: 'numeric', 
        hour: '2-digit', 
        minute: '2-digit', 
        hour12: true 
    };
    
    const lowerCaseDuration = durationFullString.toLowerCase();

    try {
        if (lowerCaseDuration.includes("ঘন্টা") || lowerCaseDuration.includes("hour")) {
            startDate.setHours(startDate.getHours() + durationValue);
        } else if (lowerCaseDuration.includes("দিন") || lowerCaseDuration.includes("day")) {
            startDate.setDate(startDate.getDate() + durationValue);
        } else if (lowerCaseDuration.includes("মাস") || lowerCaseDuration.includes("month")) {
            startDate.setMonth(startDate.getMonth() + durationValue);
        } else if (lowerCaseDuration.includes("বছর") || lowerCaseDuration.includes("year")) {
            startDate.setFullYear(startDate.getFullYear() + durationValue);
        } else {
            return null;
        }
        return { date: startDate, display: startDate.toLocaleString('bn-BD', options), timestamp: startDate.getTime() };
    } catch (e) {
        console.error("Expiry calculation error:", e, log);
        return null;
    }
}


function calculateAndDisplayReminders(logs) {
    customRemindersRef.once('value').then(snapshot => {
        const customRemindersData = snapshot.val() || {};

        const now = new Date(Date.now() + serverOffset);
        const nowTime = now.getTime(); 
        const today = new Date(now.getFullYear(), now.getMonth(), now.getDate()).getTime();
        const tomorrow = today + (24 * 60 * 60 * 1000);
        const dayAfterTomorrow = tomorrow + (24 * 60 * 60 * 1000); 
        const sevenDaysAgo = today - (7 * 24 * 60 * 60 * 1000);

        let expiringToday = [];
        let expiringTomorrow = [];
        let expiredRecently = [];
        let activeNow = []; 
        let sentMessages = []; 

        logs.forEach(logItem => {
            const log = logItem.data;
            const logKey = logItem.key;
            
            const customData = customRemindersData[logKey];
            const whatsapp = customData ? customData.whatsapp : log.customerWhatsapp;
            const baseTimestamp = customData ? customData.timestamp : log.timestamp;
            
            if (!whatsapp || whatsapp === 'N/A') {
                return; 
            }
            
            const expiry = calculateExpiryDate(log, baseTimestamp);
            if (!expiry) {
                return; 
            }
            
            const expiryDateOnly = new Date(expiry.date.getFullYear(), expiry.date.getMonth(), expiry.date.getDate()).getTime();
            const expiryFullTime = expiry.date.getTime(); 

            const reminderData = {
                whatsapp: whatsapp,
                username: log.username || '', 
                package: log.packageName,
                expiryDateDisplay: expiry.display,
                expiryTimestamp: expiry.timestamp, 
                logKey: logKey 
            };
            
            const uniqueId = `${reminderData.whatsapp}_${reminderData.package}_${reminderData.expiryDateDisplay}`;
            if (sentReminders.has(uniqueId)) {
                sentMessages.push(reminderData);
                return;
            }
            
            if (expiryDateOnly === today) {
                expiringToday.push(reminderData);
            } 
            else if (expiryDateOnly === tomorrow) {
                expiringTomorrow.push(reminderData);
            } 
            else if (expiryDateOnly < today && expiryDateOnly >= sevenDaysAgo) {
                expiredRecently.push(reminderData);
            } 
            else if (expiryFullTime > nowTime) { 
                activeNow.push(reminderData);
            }
        });

        displayReminderList(sentMessagesList, sentMessages, 'countSent', true); 
        displayReminderList(expiringTomorrowList, expiringTomorrow, 'countTomorrow');
        displayReminderList(expiringTodayList, expiringToday, 'countToday');
        displayReminderList(expiredRecentlyList, expiredRecently, 'countExpired');
        displayReminderList(activeNowList, activeNow, 'countActive');
    });
}

// ❇️❇️ পরিবর্তন: রিমাইন্ডার কার্ডে ইউজার নেম এবং বাটনে data-username যোগ করা ❇️❇️
function displayReminderList(container, list, countElementId, isSentList = false) {
    
    const countElement = document.getElementById(countElementId);
    if (countElement) {
        countElement.textContent = `(${list.length})`;
    }
    
    if (!container) return;
    container.innerHTML = '';
    
    if (list.length === 0) {
        container.innerHTML = '<p class="no-reminders">এই তালিকায় কোনো গ্রাহক নেই।</p>';
        return;
    }

    list.forEach(item => {
        const itemEl = document.createElement('div');
        itemEl.classList.add('reminder-item');
        
        let actionButtonHtml = '';
        let statusHtml = '';
        
        if (isSentList) {
            itemEl.classList.add('sent-item'); 
            statusHtml = '<span class="sent-status sent">মেসেজ সেন্ড করা হয়েছে</span>';
            actionButtonHtml = `
                <button class="send-reminder-btn sent-btn" disabled>
                    <i class="fas fa-check"></i> সেন্ট
                </button>
            `;
        } else {
            statusHtml = '<span class="sent-status"></span>';
            actionButtonHtml = `
                <button class="send-reminder-btn" data-whatsapp="${item.whatsapp}" data-package="${item.package}" data-expiry="${item.expiryDateDisplay}" data-username="${item.username || ''}">
                    <i class="fab fa-whatsapp"></i> পাঠান
                </button>
            `;
        }
        
        itemEl.innerHTML = `
            <div class="reminder-info">
                <span class="whatsapp-num">${item.whatsapp}</span>
                <span class="username-display" style="font-size: 0.9em; color: var(--info-color); font-weight: bold;">User: ${item.username || 'N/A'}</span>
                <span class="package-name">${item.package}</span>
                <span class="expiry-date">মেয়াদ শেষ: ${item.expiryDateDisplay}</span>
                ${statusHtml}
            </div>
            <div class="reminder-actions">
                ${actionButtonHtml}
                <button class="reminder-edit-btn" data-logkey="${item.logKey}" data-whatsapp="${item.whatsapp}" data-timestamp="${item.expiryTimestamp}">
                    <i class="fas fa-edit"></i> এডিট
                </button>
            </div>
        `;
        container.appendChild(itemEl);
    });
}

function openReminderEditModal(logKey, currentWhatsapp, currentTimestamp) {
    if (!reminderEditModal) {
        console.error("reminderEditModal খুঁজে পাওয়া যায়নি।");
        return;
    }
    
    reminderLogKeyInput.value = logKey;
    reminderCustomerWhatsappInput.value = currentWhatsapp;

    const logItem = allSalesLogs.find(item => item.key === logKey);
    if (!logItem) {
        alert("মূল অর্ডার খুঁজে পাওয়া যায়নি।");
        return;
    }
    
    const durationFullString = logItem.data.duration || "";
    const englishDurationString = toEnglishNumber(durationFullString);
    const match = englishDurationString.match(/^(\d+)/);
    const durationValue = match ? parseInt(match[0]) : NaN;
    
    let originalStartDate = new Date(currentTimestamp); 

    if (!isNaN(durationValue)) {
        const lowerCaseDuration = durationFullString.toLowerCase();
        try {
            if (lowerCaseDuration.includes("ঘন্টা") || lowerCaseDuration.includes("hour")) {
                originalStartDate.setHours(originalStartDate.getHours() - durationValue);
            } else if (lowerCaseDuration.includes("দিন") || lowerCaseDuration.includes("day")) {
                originalStartDate.setDate(originalStartDate.getDate() - durationValue);
            } else if (lowerCaseDuration.includes("মাস") || lowerCaseDuration.includes("month")) {
                originalStartDate.setMonth(originalStartDate.getMonth() - durationValue);
            } else if (lowerCaseDuration.includes("বছর") || lowerCaseDuration.includes("year")) {
                originalStartDate.setFullYear(originalStartDate.getFullYear() - durationValue);
            }
        } catch(e) {
            console.error("Error calculating original start date:", e);
        }
    }
    
    reminderTimestampInput.value = formatTimestampToInput(originalStartDate.getTime());
    
    reminderEditModal.classList.remove('hidden');
    reminderEditModal.style.display = 'flex';
}

function closeReminderEditModal() {
    if (!reminderEditModal) return;
    reminderEditModal.classList.add('hidden');
    reminderEditModal.style.display = 'none';
}

function saveReminderEdit() {
    const logKey = reminderLogKeyInput.value;
    const newWhatsapp = reminderCustomerWhatsappInput.value;
    const newTimestamp = formatInputToTimestamp(reminderTimestampInput.value);

    if (!logKey) {
        alert("ত্রুটি: অর্ডার আইডি নেই।");
        return;
    }
    if (isNaN(newTimestamp)) {
        alert("তারিখ ও সময় সঠিক নয়।");
        return;
    }

    const dataToSave = {
        whatsapp: newWhatsapp,
        timestamp: newTimestamp
    };

    customRemindersRef.child(logKey).set(dataToSave)
        .then(() => {
            showSuccessMessage("রিমাইন্ডার সফলভাবে আপডেট করা হয়েছে!");
            closeReminderEditModal();
            calculateAndDisplayReminders(allSalesLogs); 
        })
        .catch(showError);
}


function showPage(pageId) {
    editorPages.forEach(page => page.classList.add('hidden'));
    if(mainMenu) mainMenu.classList.add('hidden');
    
    if (pageId) {
        const pageToShow = document.getElementById(pageId);
        if (pageToShow) {
            pageToShow.classList.remove('hidden');
        }
    }
}
menuButtons.forEach(button => {
    button.addEventListener('click', () => {
        const targetPage = button.dataset.target; 
        showPage(targetPage);
    });
});
backButtons.forEach(button => {
    button.addEventListener('click', () => {
        showPage('main-menu'); 
    });
});

function showSuccessMessage(message) {
    if(!successMessage) return;
    successMessage.textContent = message;
    setTimeout(() => { successMessage.textContent = ""; }, 3000); 
}

function showError(error) {
    if(!errorMessage) return;
    const combinedMessage = "একটি সমস্যা হয়েছে: " + error.message;
    errorMessage.textContent = combinedMessage;
    console.error(error);
}

if(document.getElementById('clearAppFormButton')) {
    document.getElementById('clearAppFormButton').addEventListener('click', clearAppForm);
}