// --- Firebase কনফিগারেশন (আপনার আগের কনফিগ) ---
const firebaseConfig = {
    apiKey: "AIzaSyCql5HDGJVx3GXyLnLMHvAIAiRE7sDiYIY",
    authDomain: "ip-tv-peyment.firebaseapp.com",
    databaseURL: "https://ip-tv-peyment-default-rtdb.asia-southeast1.firebasedatabase.app/",
    projectId: "ip-tv-peyment",
    storageBucket: "ip-tv-peyment.appspot.com",
    messagingSenderId: "4072999206",
    appId: "1:4072999206:web:d24c972655f02f634d8567",
    measurementId: "G-HW8BBBF6Q5"
};

// --- Firebase চালু করা ---
firebase.initializeApp(firebaseConfig);
const auth = firebase.auth();
const db = firebase.database();
const resellerRef = db.ref('reseller_content'); 
const packagesRef = resellerRef.child('packages');
const settingsRef = resellerRef.child('settings');

// --- সাধারণ এলিমেন্ট ---
const loginContainer = document.querySelector('.login-container');
const dashboard = document.getElementById('dashboard');
const loginButton = document.getElementById('loginButton');
const logoutButton = document.getElementById('logoutButton');
const emailInput = document.getElementById('email');
const passwordInput = document.getElementById('password');
const errorMessage = document.getElementById('error-message');
const successMessage = document.getElementById('success-message');

// --- নেভিগেশন এলিমেন্ট ---
const mainMenu = document.getElementById('main-menu');
const editorPages = document.querySelectorAll('.editor-page');
const menuButtons = document.querySelectorAll('.menu-button');
const backButtons = document.querySelectorAll('.back-btn');

// --- প্যাকেজ ম্যানেজার এলিমেন্ট ---
const packageKeyInput = document.getElementById('package_key_input');
const packageNameInput = document.getElementById('package_name_input');
const packageOrderInput = document.getElementById('package_order_input');
const packageIconInput = document.getElementById('package_icon_input');
const packageBestDealInput = document.getElementById('package_best_deal_input');
const packageFeaturesInput = document.getElementById('package_features_input');
const packageMinCreditNewInput = document.getElementById('package_min_credit_new_input');
const packageMinCreditExistingInput = document.getElementById('package_min_credit_existing_input');
const packageDisclaimerInput = document.getElementById('package_disclaimer_input');
const savePackageButton = document.getElementById('savePackageButton');
const clearFormButton = document.getElementById('clearFormButton');
const packageListContainer = document.getElementById('package-list-container');
const package_details_input = document.getElementById('package_details_input');
const package_channel_list_url = document.getElementById('package_channel_list_url');
const package_tutorial_url = document.getElementById('package_tutorial_url');

// --- প্যাকেজ মূল্য তালিকা এলিমেন্ট ---
const addPriceButton = document.getElementById('addPriceButton');
const pricingCreditInput = document.getElementById('pricing_credit_input');
const pricingRateInput = document.getElementById('pricing_rate_input');
const pricingListContainer = document.getElementById('pricing-list-container');
let currentPricingList = {}; 

// --- সেটিংস এলিমেন্ট ---
const settingsWhatsappInput = document.getElementById('settings_whatsapp_input');
const settingsPaymentInput = document.getElementById('settings_payment_input');
const settingsTrialPaymentInput = document.getElementById('settings_trial_payment_input');
const settingsTrialFeeInput = document.getElementById('settings_trial_fee_input');
const saveSettingsButton = document.getElementById('saveSettingsButton');

// --- লগইন/লগআউট এবং Auth স্টেট ---
loginButton.addEventListener('click', () => {
    auth.signInWithEmailAndPassword(emailInput.value, passwordInput.value)
        .then(() => { /* Auth স্টেট চেঞ্জ হ্যান্ডেল করবে */ })
        .catch(error => { errorMessage.textContent = "ভুল ইমেইল অথবা পাসওয়ার্ড।"; });
});

logoutButton.addEventListener('click', () => {
    auth.signOut();
});

auth.onAuthStateChanged(user => {
    if (user) {
        loginContainer.classList.add('hidden');
        dashboard.classList.remove('hidden');
        showPage('main-menu');
        loadAllAdminData();
    } else {
        loginContainer.classList.remove('hidden');
        dashboard.classList.add('hidden');
        showPage(null);
        packagesRef.off(); 
        settingsRef.off(); 
    }
});

function loadAllAdminData() {
    loadPackagesForAdmin();
    loadSettings();
}

// --- পেজ নেভিগেশন ---
function showPage(pageId) {
    editorPages.forEach(page => page.classList.add('hidden'));
    mainMenu.classList.add('hidden');
    if (pageId) {
        const pageToShow = document.getElementById(pageId);
        if (pageToShow) pageToShow.classList.remove('hidden');
    } else {
        loginContainer.classList.remove('hidden');
    }
}
menuButtons.forEach(button => {
    button.addEventListener('click', () => showPage(button.dataset.target));
});
backButtons.forEach(button => {
    button.addEventListener('click', () => showPage('main-menu'));
});

// --- সেটিংস পেজ ফাংশন ---
function loadSettings() {
    settingsRef.on('value', snapshot => {
        const data = snapshot.val();
        if (data) {
            settingsWhatsappInput.value = data.whatsappNumber || '';
            settingsPaymentInput.value = data.paymentNumber || '';
            settingsTrialPaymentInput.value = data.trialPaymentNumber || '';
            settingsTrialFeeInput.value = data.trialFee || '';
        }
    });
}

saveSettingsButton.addEventListener('click', () => {
    const settingsData = {
        whatsappNumber: settingsWhatsappInput.value,
        paymentNumber: settingsPaymentInput.value,
        trialPaymentNumber: settingsTrialPaymentInput.value,
        trialFee: Number(settingsTrialFeeInput.value) || 0
    };
    settingsRef.update(settingsData)
        .then(() => showSuccessMessage("সেটিংস সেভ হয়েছে!"))
        .catch(showError);
});

// --- প্যাকেজ মূল্য তালিকা ফাংশন ---
addPriceButton.addEventListener('click', () => {
    const credit = Number(pricingCreditInput.value);
    const rate = Number(pricingRateInput.value);
    if (!credit || !rate || credit <= 0 || rate <= 0) {
        alert("অনুগ্রহ করে সঠিক ক্রেডিট এবং মূল্য দিন।");
        return;
    }
    currentPricingList[credit] = rate; 
    renderPricingList();
    pricingCreditInput.value = '';
    pricingRateInput.value = '';
});

function renderPricingList() {
    pricingListContainer.innerHTML = '';
    if (Object.keys(currentPricingList).length === 0) {
        pricingListContainer.innerHTML = '<p><small>এখনো কোনো মূল্য যোগ করা হয়নি।</small></p>';
        return;
    }
    const sortedCredits = Object.keys(currentPricingList).map(Number).sort((a, b) => a - b);
    
    for (const credit of sortedCredits) {
        const rate = currentPricingList[credit];
        const itemEl = document.createElement('div');
        itemEl.classList.add('pricing-item');
        itemEl.innerHTML = `
            <span>${credit} ক্রেডিট <span class="price-value">(প্রতিটি ${rate} টাকা)</span></span>
            <div class="actions">
                <button class="edit-price-btn" data-credit="${credit}" data-rate="${rate}">✏️ এডিট</button>
                <button class="delete-price-btn" data-credit="${credit}">❌ ডিলিট</button>
            </div>
        `;
        pricingListContainer.appendChild(itemEl);
    }
    
    pricingListContainer.querySelectorAll('.delete-price-btn').forEach(button => {
        button.addEventListener('click', e => {
            const creditToDelete = e.target.dataset.credit;
            delete currentPricingList[creditToDelete];
            renderPricingList();
        });
    });
    
    pricingListContainer.querySelectorAll('.edit-price-btn').forEach(button => {
        button.addEventListener('click', e => {
            const creditToEdit = e.target.dataset.credit;
            const rateToEdit = e.target.dataset.rate;
            
            pricingCreditInput.value = creditToEdit;
            pricingRateInput.value = rateToEdit;
            
            delete currentPricingList[creditToEdit];
            renderPricingList();
        });
    });
}

// --- প্যাকেজ ম্যানেজার ফাংশন ---
clearFormButton.addEventListener('click', clearPackageForm);

function clearPackageForm() {
    packageKeyInput.value = '';
    packageNameInput.value = '';
    packageNameInput.readOnly = false; 
    packageOrderInput.value = '';
    packageIconInput.value = '';
    packageBestDealInput.value = '';
    packageFeaturesInput.value = '';
    packageMinCreditNewInput.value = '';
    packageMinCreditExistingInput.value = '';
    packageDisclaimerInput.value = '';
    package_details_input.value = '';
    package_channel_list_url.value = '';
    package_tutorial_url.value = '';
    currentPricingList = {};
    renderPricingList();
}

// ✅ আপডেট করা: loadPackagesForAdmin
function loadPackagesForAdmin() {
    packagesRef.orderByChild("order").on('value', snapshot => {
        packageListContainer.innerHTML = '';
        if (!snapshot.exists()) {
            packageListContainer.innerHTML = '<p>কোনো প্যাকেজ পাওয়া যায়নি।</p>';
            return;
        }
        snapshot.forEach(childSnapshot => {
            const packageKey = childSnapshot.key; // ✅ এটি এখন Firebase-এর ইউনিক ID (-Nq_abc...)
            const packageData = childSnapshot.val();
            const item = document.createElement('div');
            item.classList.add('package-item');
            item.innerHTML = `
                <span>(Order: ${packageData.order || 'N/A'}) ${packageData.name}</span>
                <div class="actions">
                    <button class="edit-btn" data-key="${packageKey}">✏️ এডিট</button>
                    <button class="delete-btn" data-key="${packageKey}">❌ ডিলিট</button>
                </div>
            `;
            packageListContainer.appendChild(item);
        });

        packageListContainer.querySelectorAll('.edit-btn').forEach(btn => {
            btn.addEventListener('click', e => selectPackageForEdit(e.target.dataset.key));
        });
        packageListContainer.querySelectorAll('.delete-btn').forEach(btn => {
            btn.addEventListener('click', e => deletePackage(e.target.dataset.key));
        });
    });
}

// ✅ আপডেট করা: savePackageButton
savePackageButton.addEventListener('click', () => {
    const key = packageKeyInput.value; // এডিট করার সময় এখানে Firebase ID থাকবে
    const packageName = packageNameInput.value.trim();
    if (!packageName) {
        alert("প্যাকেজের নাম অবশ্যই দিতে হবে।");
        return;
    }
    
    const order = Number(packageOrderInput.value) || 0;
    const disclaimerNotes = packageDisclaimerInput.value.split('\n').filter(f => f.trim() !== '');
    const details = package_details_input.value; 

    const packageData = {
        name: packageName,
        order: order,
        iconClass: packageIconInput.value.trim(),
        bestDealText: packageBestDealInput.value.trim(),
        featuresText: packageFeaturesInput.value.trim(),
        pricing: currentPricingList,
        minCreditNew: Number(packageMinCreditNewInput.value) || 0,
        minCreditExisting: Number(packageMinCreditExistingInput.value) || 0,
        disclaimerNotes: disclaimerNotes,
        details: details, 
        channelListURL: package_channel_list_url.value,
        tutorialURL: package_tutorial_url.value
    };

    if (key) {
        // --- এডিট মোড ---
        // আমাদের কাছে Firebase ID (key) আছে, তাই আমরা update() ব্যবহার করব
        packagesRef.child(key).update(packageData)
            .then(() => {
                showSuccessMessage("প্যাকেজ সফলভাবে আপডেট হয়েছে!");
                clearPackageForm();
            })
            .catch(showError);
    } else {
        // --- নতুন প্যাকেজ মোড ---
        // আমাদের কাছে key নেই, তাই push() ব্যবহার করব
        packagesRef.push(packageData)
            .then(() => {
                showSuccessMessage("নতুন প্যাকেজ সফলভাবে যোগ হয়েছে!");
                clearPackageForm();
            })
            .catch(showError);
    }
});

// ✅ আপডেট করা: selectPackageForEdit
function selectPackageForEdit(key) { // key এখন Firebase ID
    packagesRef.child(key).once('value', snapshot => {
        const data = snapshot.val();
        if (!data) {
            alert("প্যাকেজ খুঁজে পাওয়া যায়নি।");
            return;
        }
        
        packageKeyInput.value = key; // ✅ Firebase ID এখানে সেভ করা হলো
        packageNameInput.value = data.name;
        packageNameInput.readOnly = false; // ✅ নাম এডিট করার অনুমতি দেওয়া হলো
        
        packageOrderInput.value = data.order || '';
        packageIconInput.value = data.iconClass || '';
        packageBestDealInput.value = data.bestDealText || '';
        packageFeaturesInput.value = data.featuresText || '';
        packageMinCreditNewInput.value = data.minCreditNew || '';
        packageMinCreditExistingInput.value = data.minCreditExisting || '';
        packageDisclaimerInput.value = (data.disclaimerNotes || []).join('\n');
        package_details_input.value = data.details || ''; 
        package_channel_list_url.value = data.channelListURL || '';
        package_tutorial_url.value = data.tutorialURL || '';

        currentPricingList = data.pricing || {};
        renderPricingList();
        
        document.getElementById('package-editor-form').scrollIntoView({ behavior: 'smooth' });
    });
}

// ✅ আপডেট করা: deletePackage
function deletePackage(key) { // key এখন Firebase ID
    if (confirm(`আপনি কি সত্যিই এই প্যাকেজটি ডিলিট করতে চান?`)) {
        packagesRef.child(key).remove()
            .then(() => showSuccessMessage("প্যাকেজ ডিলিট করা হয়েছে।"))
            .catch(showError);
    }
}

// --- হেল্পার ফাংশন ---
function showSuccessMessage(message) {
    successMessage.textContent = message;
    setTimeout(() => { successMessage.textContent = ""; }, 3000); 
}
function showError(error) {
    errorMessage.textContent = "একটি সমস্যা হয়েছে: " + error.message;
    console.error(error);
}
