// --- Firebase রেফারেন্স ---
// এই ফাইল থেকে সব রেফারেন্স (যেমন salesLogRef, visitCountsRef) মুছে ফেলা হয়েছে।
// এগুলো এখন admin.js ফাইল থেকে গ্লোবালি লোড হবে।

// --- HTML এলিমেন্ট (শুধুমাত্র রিপোর্ট সংশ্লিষ্ট) ---
const adminTodaySalesEl = document.getElementById('adminTodaySales');
const adminTodayOrdersEl = document.getElementById('adminTodayOrders');
const adminTodayPurchaseEl = document.getElementById('adminTodayPurchase'); 
const adminTodayProfitEl = document.getElementById('adminTodayProfit'); 

// সেলস রিপোর্ট এলিমেন্ট
const salesLogTbody = document.getElementById('sales-log-tbody');
const salesStartDateInput = document.getElementById('salesStartDate');
const salesEndDateInput = document.getElementById('salesEndDate');
const filterSalesButton = document.getElementById('filterSalesButton');
const clearFilterSalesButton = document.getElementById('clearFilterSalesButton');
const filteredTotalSalesEl = document.getElementById('filteredTotalSales');
const filteredTotalOrdersEl = document.getElementById('filteredTotalOrders');

const salesMonthInput = document.getElementById('salesMonthInput'); 
const filterSalesByMonthButton = document.getElementById('filterSalesByMonthButton'); 
const salesPaymentMethodFilter = document.getElementById('salesPaymentMethodFilter');

const salesSearchInput = document.getElementById('salesSearchInput');
const salesSearchBtn = document.getElementById('salesSearchBtn');
const salesSearchClearBtn = document.getElementById('salesSearchClearBtn');

const saleTypeFilterButtonsContainer = document.getElementById('sale-type-filters'); 
const saleTypeFilterButtons = document.querySelectorAll('#sale-type-filters .stat-filter-btn'); 

const orderTypeFilterButtonsContainer = document.getElementById('order-type-filters');
const orderTypeFilterButtons = document.querySelectorAll('#order-type-filters .stat-filter-btn');

// বাল্ক ডিলিট এলিমেন্ট
const deleteSelectedSalesButton = document.getElementById('deleteSelectedSalesButton');
const selectAllSalesLogsCheckbox = document.getElementById('selectAllSalesLogs');

// ৪-কলাম গ্রিড (সাধারণ)
const last7DaysSalesEl = document.getElementById('last7DaysSales');
const last7DaysPurchaseEl = document.getElementById('last7DaysPurchase'); 
const last7DaysProfitEl = document.getElementById('last7DaysProfit'); 
const last7DaysOrdersEl = document.getElementById('last7DaysOrders');
const last30DaysSalesEl = document.getElementById('last30DaysSales');
const last30DaysPurchaseEl = document.getElementById('last30DaysPurchase'); 
const last30DaysProfitEl = document.getElementById('last30DaysProfit'); 
const last30DaysOrdersEl = document.getElementById('last30DaysOrders');
const lastMonthSalesEl = document.getElementById('lastMonthSales');
const lastMonthPurchaseEl = document.getElementById('lastMonthPurchase');
const lastMonthProfitEl = document.getElementById('lastMonthProfit');
const lastMonthOrdersEl = document.getElementById('lastMonthOrders');
const allTimeSalesEl = document.getElementById('allTimeSales');
const allTimePurchaseEl = document.getElementById('allTimePurchase'); 
const allTimeProfitEl = document.getElementById('allTimeProfit'); 
const allTimeOrdersEl = document.getElementById('allTimeOrders');

// রিসেলার পরিসংখ্যান কার্ড সেলেক্টর
const last7DaysResellerSalesEl = document.getElementById('resellerLast7DaysSales');
const last30DaysResellerSalesEl = document.getElementById('resellerLast30DaysSales');
const lastMonthResellerSalesEl = document.getElementById('resellerLastMonthSales');
const allTimeResellerSalesEl = document.getElementById('resellerAllTimeSales');
const last7DaysResellerProfitEl = document.getElementById('resellerLast7DaysProfit');
const last30DaysResellerProfitEl = document.getElementById('resellerLast30DaysProfit');
const lastMonthResellerProfitEl = document.getElementById('resellerLastMonthProfit');
const allTimeResellerProfitEl = document.getElementById('resellerAllTimeProfit');

// পেমেন্ট ও প্যাকেজ স্ট্যাটাস
const paymentStatsFilterButtonsContainer = document.querySelector('#payment-stats-filters');
const paymentStatsFilterButtons = document.querySelectorAll('#payment-stats-filters .stat-filter-btn');
const bkashSalesEl = document.getElementById('bkashSales');
const nagadSalesEl = document.getElementById('nagadSales');
const rocketSalesEl = document.getElementById('rocketSales');
const upaySalesEl = document.getElementById('upaySales');

const packageStatsFilterButtonsContainer = document.querySelector('#package-stats-filters');
const packageStatsFilterButtons = document.querySelectorAll('#package-stats-filters .stat-filter-btn');
const packageSearchInput = document.getElementById('packageSearchInput');
const packageSalesStatsContainer = document.getElementById('package-sales-stats-container');

const salesStatsWrapper = document.getElementById('sales-stats-wrapper'); 
const salesReportTitle = document.getElementById('sales-report-title'); 
const backToFullReportBtn = document.getElementById('backToFullReportBtn'); 

// সেলস এডিট Modal
const salesEditModal = document.getElementById('salesEditModal');
const modalCloseButton = document.getElementById('modalCloseButton');
const cancelSalesEditButton = document.getElementById('cancelSalesEditButton');
const saveSalesEditButton = document.getElementById('saveSalesEditButton');
const editSalesKeyInput = document.getElementById('editSalesKey');
const editSalesTimestampInput = document.getElementById('editSalesTimestamp');
const editPackageNameInput = document.getElementById('editPackageName');
const editSalesUsernameInput = document.getElementById('editSalesUsername');
const editDurationInput = document.getElementById('editDuration');
const editTrxIdInput = document.getElementById('editTrxId');
const editAmountInput = document.getElementById('editAmount');
const editCustomerWhatsappInput = document.getElementById('editCustomerWhatsapp');

// রিমাইন্ডার
const reminderEditModal = document.getElementById('reminderEditModal');
const reminderModalCloseButton = document.getElementById('reminderModalCloseButton');
const cancelReminderEditButton = document.getElementById('cancelReminderEditButton');
const saveReminderEditButton = document.getElementById('saveReminderEditButton');
const reminderLogKeyInput = document.getElementById('reminderLogKeyInput');
const reminderCustomerWhatsappInput = document.getElementById('reminderCustomerWhatsappInput');
const reminderTimestampInput = document.getElementById('reminderTimestampInput');

const reminderSearchInput = document.getElementById('reminderSearchInput');
const reminderSearchBtn = document.getElementById('reminderSearchBtn');
const reminderSearchClearBtn = document.getElementById('reminderSearchClearBtn');

const reminderTemplateInput = document.getElementById('reminderTemplateInput');
const saveReminderTemplateBtn = document.getElementById('saveReminderTemplateBtn');
const expiringTomorrowList = document.getElementById('expiringTomorrowList');
const expiringTodayList = document.getElementById('expiringTodayList');
const expiredRecentlyList = document.getElementById('expiredRecentlyList');
const manualReminderNumberInput = document.getElementById('manualReminderNumber'); 
const sendManualReminderBtn = document.getElementById('sendManualReminderBtn'); 
const copyTomorrowListBtn = document.getElementById('copyTomorrowListBtn'); 
const copyTodayListBtn = document.getElementById('copyTodayListBtn'); 
const copyExpiredListBtn = document.getElementById('copyExpiredListBtn'); 
const copyActiveListBtn = document.getElementById('copyActiveListBtn'); 
const activeNowList = document.getElementById('activeNowList'); 

const sentMessagesList = document.getElementById('sentMessagesList');
const copySentListBtn = document.getElementById('copySentListBtn');

// --- গ্লোবাল ভেরিয়েবল (রিপোর্ট সংশ্লিষ্ট) ---
let currentEditKey = null; 
let currentOrderTypeFilter = 'all'; 
let currentSaleTypeFilter = 'all';
let reminderMessageTemplate = "প্রিয় গ্রাহক [username], আপনার [package] প্যাকেজটির মেয়াদ [date] তারিখে শেষ হয়ে যাচ্ছে। রিনিউ করতে যোগাযোগ করুন।"; 
const sentRemindersKey = 'ottAdminSentReminders';
let sentReminders = new Set(); 
let paymentMethodStats = {
    bkash: { today: 0, yesterday: 0, '7days': 0, '30days': 0, lastMonth: 0, all: 0 },
    nagad: { today: 0, yesterday: 0, '7days': 0, '30days': 0, lastMonth: 0, all: 0 },
    rocket: { today: 0, yesterday: 0, '7days': 0, '30days': 0, lastMonth: 0, all: 0 },
    upay: { today: 0, yesterday: 0, '7days': 0, '30days': 0, lastMonth: 0, all: 0 }
};
let packageSalesStats = {}; 
let currentPackageFilter = null; 
// serverOffset এবং allSalesLogs ভেরিয়েবলদুটি admin.js থেকে গ্লোবালি আসবে

// --- রিয়েল-টাইম আপডেটের জন্য গ্লোবাল ভেরিয়েবল ---
let isInitialLoadComplete = false; 
let lastLoadedRegularTimestamp = 0; 
let lastLoadedResellerTimestamp = 0;

// --- localStorage ফাংশন (রিমাইন্ডার) ---
function loadSentReminders() {
    try {
        const storedData = localStorage.getItem(sentRemindersKey);
        if (storedData) {
            return new Set(JSON.parse(storedData)); 
        }
    } catch (e) {
        console.error("Failed to load sent reminders from localStorage:", e);
        localStorage.removeItem(sentRemindersKey); 
    }
    return new Set(); 
}

function saveSentReminders(sentSet) {
    try {
        localStorage.setItem(sentRemindersKey, JSON.stringify(Array.from(sentSet)));
    } catch (e) {
        console.error("Failed to save sent reminders to localStorage:", e);
    }
}

// --- হেল্পার ফাংশন (রিপোর্ট) ---
function getBdtTimezoneDate(timestamp) {
    const bdtOffsetInMinutes = 6 * 60;
    const date = new Date(timestamp);
    const utcTime = date.getTime() + (date.getTimezoneOffset() * 60000);
    return new Date(utcTime + (bdtOffsetInMinutes * 60000));
}

function getLastMonthBdtBoundaries(serverNow) {
    const bdtNowLocal = getBdtTimezoneDate(serverNow);
    const lastMonthDate = new Date(bdtNowLocal.getFullYear(), bdtNowLocal.getMonth() - 1, 1);
    const thisMonthDate = new Date(bdtNowLocal.getFullYear(), bdtNowLocal.getMonth(), 1);
    const bdtOffsetMilliseconds = 6 * 60 * 60 * 1000;
    
    const lastMonthStartTimestamp = new Date(Date.UTC(lastMonthDate.getFullYear(), lastMonthDate.getMonth(), 1)).getTime() - bdtOffsetMilliseconds;
    const thisMonthStartTimestamp = new Date(Date.UTC(thisMonthDate.getFullYear(), thisMonthDate.getMonth(), 1)).getTime() - bdtOffsetMilliseconds;
    const lastMonthEndTimestamp = thisMonthStartTimestamp - 1; 

    return { start: lastMonthStartTimestamp, end: lastMonthEndTimestamp };
}

function getBdtDateString(timestamp) {
    const bdtDate = getBdtTimezoneDate(timestamp);
    const year = bdtDate.getFullYear();
    const month = String(bdtDate.getMonth() + 1).padStart(2, '0');
    const day = String(bdtDate.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}`;
}

function toEnglishNumber(str) {
    if (!str) return '';
    const bengaliDigits = ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯'];
    const englishDigits = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    let newStr = String(str);
    for (let i = 0; i < 10; i++) {
        newStr = newStr.replace(new RegExp(bengaliDigits[i], 'g'), englishDigits[i]);
    }
    return newStr;
}

function formatTimestampToInput(timestamp) {
    const date = new Date(timestamp);
    const localDate = new Date(timestamp - (new Date().getTimezoneOffset() * 60000));
    return localDate.toISOString().slice(0, 16);
}
function formatInputToTimestamp(inputString) {
    const localTime = new Date(inputString).getTime();
    const timezoneOffset = new Date().getTimezoneOffset() * 60000;
    return localTime + timezoneOffset;
}

function getOrderType(durationFullString) {
    const safeDuration = toEnglishNumber((durationFullString || "").toLowerCase());
    const match = safeDuration.match(/^(\d+)/);
    const durationValue = match ? parseInt(match[0]) : NaN;

    if (isNaN(durationValue)) {
        return 'paid'; 
    }

    if (safeDuration.includes("ঘন্টা") || safeDuration.includes("hour")) {
        if (durationValue < 72) {
            return 'trial'; 
        } else {
            return 'paid'; 
        }
    }
    
    if (safeDuration.includes("দিন") || safeDuration.includes("day")) {
        const hours = durationValue * 24; 
        if (hours < 72) {
            return 'trial'; 
        } else {
            return 'paid'; 
        }
    }
    
    return 'paid';
}

function getDeductionAmount(durationFullString) {
    const lowerDuration = (durationFullString || "").toLowerCase();
    let safeDuration = toEnglishNumber(lowerDuration);
    
    if (safeDuration.includes("ঘন্টা") || safeDuration.includes("hour")) {
        return 0; 
    } 
    else if (safeDuration.includes("12 মাস") || safeDuration.includes("1 বছর") || safeDuration.includes("1 year") || safeDuration.includes("12 month")) {
        return 10;
    } 
    else if (safeDuration.includes("6 মাস") || safeDuration.includes("6 month")) {
        return 5;
    } 
    else if (safeDuration.includes("3 মাস") || safeDuration.includes("3 month")) {
        return 3;
    } 
    else if (safeDuration.includes("2 মাস") || safeDuration.includes("2 month")) {
        return 2;
    }
    else if (safeDuration.includes("1 মাস") || safeDuration.includes("1 month")) {
        return 1;
    }
    
    return 0; 
}

// --- সেলস রিপোর্ট ফাংশন ---

function initializeSalesLogListeners() {
    if(filterSalesButton) {
        filterSalesButton.addEventListener('click', () => {
            if (salesMonthInput) salesMonthInput.value = '';
            refreshSalesTableView();
        });
    }

    if(filterSalesByMonthButton) {
        filterSalesByMonthButton.addEventListener('click', () => {
            if (salesStartDateInput) salesStartDateInput.value = '';
            if (salesEndDateInput) salesEndDateInput.value = '';
            refreshSalesTableView();
        });
    }

    if(clearFilterSalesButton) {
        clearFilterSalesButton.addEventListener('click', () => {
            salesStartDateInput.value = '';
            salesEndDateInput.value = '';
            if(salesSearchInput) salesSearchInput.value = '';
            
            if(salesMonthInput) salesMonthInput.value = '';
            if(salesPaymentMethodFilter) salesPaymentMethodFilter.value = 'all';

            currentPackageFilter = null; 
            showFullReportView(); 
            
            // অর্ডার টাইপ ফিল্টার রিসেট
            orderTypeFilterButtons.forEach(btn => btn.classList.remove('active'));
            document.querySelector('#order-type-filters .stat-filter-btn[data-type="all"]').classList.add('active');
            currentOrderTypeFilter = 'all';

            // সেলস টাইপ ফিল্টার রিসেট
            saleTypeFilterButtons.forEach(btn => btn.classList.remove('active'));
            document.querySelector('#sale-type-filters .stat-filter-btn[data-sale-type="all"]').classList.add('active');
            currentSaleTypeFilter = 'all';

            refreshSalesTableView();
        });
    }

    // সেলস টাইপ ফিল্টার বাটন
    if (saleTypeFilterButtonsContainer) {
        saleTypeFilterButtons.forEach(button => {
            button.addEventListener('click', () => {
                saleTypeFilterButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
                currentSaleTypeFilter = button.dataset.saleType;
                refreshSalesTableView();
            });
        });
    }

    if (orderTypeFilterButtonsContainer) {
        orderTypeFilterButtons.forEach(button => {
            button.addEventListener('click', () => {
                orderTypeFilterButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
                currentOrderTypeFilter = button.dataset.type;
                
                refreshSalesTableView();
                displayPackageSalesStats(getActivePackagePeriod(), currentOrderTypeFilter);
            });
        });
    }
    
    if (salesPaymentMethodFilter) {
        salesPaymentMethodFilter.addEventListener('change', refreshSalesTableView);
    }

    if (salesLogTbody) {
        salesLogTbody.addEventListener('click', (e) => {
            // চেকবক্স ক্লিকের জন্য আলাদা লজিক
            if (e.target.classList.contains('sales-log-checkbox')) {
                handleSalesLogCheckboxClick();
                return;
            }

            const target = e.target.closest('button'); 
            if (!target) return; 

            if (target.classList.contains('edit-sales-btn')) {
                openSalesEditModal(target.dataset.key);
            } else if (target.classList.contains('delete-sales-btn')) {
                deleteSalesLog(target.dataset.key, true); // true = কনফার্মেশন দেখাও
            }
        });
    }
    
    if(modalCloseButton) modalCloseButton.addEventListener('click', closeSalesEditModal);
    if(cancelSalesEditButton) cancelSalesEditButton.addEventListener('click', closeSalesEditModal);
    if(saveSalesEditButton) saveSalesEditButton.addEventListener('click', saveSalesEdit);
    
    if (paymentStatsFilterButtonsContainer) {
        paymentStatsFilterButtons.forEach(button => {
            button.addEventListener('click', () => {
                paymentStatsFilterButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
                const period = button.dataset.period;
                displayPaymentMethodStats(period);
            });
        });
    }
    
    if (packageStatsFilterButtonsContainer) {
        packageStatsFilterButtons.forEach(button => {
            button.addEventListener('click', () => {
                packageStatsFilterButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
                const period = button.dataset.period;
                displayPackageSalesStats(period, getActiveOrderType());
            });
        });
    }

    if (packageSearchInput) {
        packageSearchInput.addEventListener('keyup', () => {
            displayPackageSalesStats(getActivePackagePeriod(), getActiveOrderType());
        });
    }

    if (packageSalesStatsContainer) {
        packageSalesStatsContainer.addEventListener('click', (e) => {
            const target = e.target.closest('.package-stat-item');
            if (target && target.dataset.packageName) {
                filterByPackage(target.dataset.packageName);
            }
        });
    }

    if (backToFullReportBtn) {
        backToFullReportBtn.addEventListener('click', () => {
            currentPackageFilter = null; 
            showFullReportView();
            refreshSalesTableView(); 
        });
    }

    if(salesSearchBtn) {
        salesSearchBtn.addEventListener('click', refreshSalesTableView);
    }
    if(salesSearchClearBtn) {
        salesSearchClearBtn.addEventListener('click', () => {
            if(salesSearchInput) salesSearchInput.value = '';
            refreshSalesTableView();
        });
    }

    // বাল্ক ডিলিট বাটন লিসেনার
    if (deleteSelectedSalesButton) {
        deleteSelectedSalesButton.addEventListener('click', deleteSelectedSalesLogs);
    }
    // সিলেক্ট অল চেকবক্স লিসেনার
    if (selectAllSalesLogsCheckbox) {
        selectAllSalesLogsCheckbox.addEventListener('click', toggleSelectAllSalesLogs);
    }
}

function toggleSelectAllSalesLogs(e) {
    const isChecked = e.target.checked;
    const checkboxes = document.querySelectorAll('#sales-log-tbody .sales-log-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = isChecked;
    });
}

function handleSalesLogCheckboxClick() {
    if (!selectAllSalesLogsCheckbox) return;
    
    const allCheckboxes = document.querySelectorAll('#sales-log-tbody .sales-log-checkbox');
    const checkedCheckboxes = document.querySelectorAll('#sales-log-tbody .sales-log-checkbox:checked');
    
    if (allCheckboxes.length > 0 && allCheckboxes.length === checkedCheckboxes.length) {
        selectAllSalesLogsCheckbox.checked = true;
    } else {
        selectAllSalesLogsCheckbox.checked = false;
    }
}

async function deleteSelectedSalesLogs() {
    const checkedBoxes = document.querySelectorAll('#sales-log-tbody .sales-log-checkbox:checked');
    
    if (checkedBoxes.length === 0) {
        alert("অনুগ্রহ করে প্রথমে ডিলিট করার জন্য সেলস লগ মার্ক করুন।");
        return;
    }

    if (!confirm(`আপনি কি সত্যিই এই ${checkedBoxes.length} টি সেলস লগ ডিলিট করতে চান? এই কাজটি ফেরত আনা যাবে না।`)) {
        return;
    }

    if(deleteSelectedSalesButton) deleteSelectedSalesButton.disabled = true;
    if(deleteSelectedSalesButton) deleteSelectedSalesButton.textContent = 'ডিলিট করা হচ্ছে...';
    
    const keysToDelete = Array.from(checkedBoxes).map(cb => cb.dataset.key);
    let deletedCount = 0;
    let failedCount = 0;

    for (const key of keysToDelete) {
        try {
            // 'false' পাঠানো হয়েছে যেন প্রতিটি ডিলিটে আলাদা করে কনফার্ম না চায়
            await deleteSalesLog(key, false); 
            deletedCount++;
        } catch (err) {
            console.error(`লগ ${key} ডিলিট করা যায়নি:`, err);
            failedCount++;
        }
    }
    
    if(deleteSelectedSalesButton) deleteSelectedSalesButton.disabled = false;
    if(deleteSelectedSalesButton) deleteSelectedSalesButton.innerHTML = '<i class="fas fa-trash-alt"></i> মার্ক করা আইটেম ডিলিট করুন';

    showSuccessMessage(`${deletedCount} টি লগ সফলভাবে ডিলিট করা হয়েছে।`);
    if (failedCount > 0) {
        showError({ message: `${failedCount} টি লগ ডিলিট করা যায়নি।` });
    }
    
    // টেবিল ও পরিসংখ্যান রিফ্রেশ
    processAndDisplaySales();
}


function refreshSalesTableView() {
    const startDateValue = salesStartDateInput.value;
    const endDateValue = salesEndDateInput.value;
    const monthValue = salesMonthInput.value;
    const searchQuery = salesSearchInput ? salesSearchInput.value.trim() : '';
    const paymentMethod = salesPaymentMethodFilter ? salesPaymentMethodFilter.value : 'all';

    let logsToShow = allSalesLogs; 
    let startTime = 0;
    let endTime = Infinity;
    let isDateFiltered = false; 

    // তারিখ বা মাস ফিল্টার চেক
    if (monthValue) {
        const [year, month] = monthValue.split('-').map(Number);
        const bdtOffset = 6 * 60 * 60 * 1000;
        startTime = new Date(Date.UTC(year, month - 1, 1)).getTime() - bdtOffset; 
        endTime = new Date(Date.UTC(year, month, 1)).getTime() - bdtOffset - 1; 
        isDateFiltered = true;
    } else if (startDateValue && endDateValue) {
        startTime = new Date(startDateValue + "T00:00:00+06:00").getTime(); 
        endTime = new Date(endDateValue + "T23:59:59+06:00").getTime(); 
        isDateFiltered = true;
    }

    // অন্যান্য ফিল্টার চেক
    const isPackageFiltered = (currentPackageFilter !== null);
    const isSearchActive = (searchQuery !== '');
    const isPaymentFilterActive = (paymentMethod !== 'all');
    const isSaleTypeFilterActive = (currentSaleTypeFilter !== 'all'); 
    const isOrderTypeFilterActive = (currentOrderTypeFilter !== 'all');

    const anyFilterActive = isDateFiltered || isPackageFiltered || isSearchActive || isPaymentFilterActive || isSaleTypeFilterActive || isOrderTypeFilterActive;

    if (anyFilterActive) {
        if (isDateFiltered) {
            logsToShow = logsToShow.filter(logItem => {
                return logItem.data.timestamp >= startTime && logItem.data.timestamp <= endTime;
            });
        }
        if (isPackageFiltered) {
            logsToShow = logsToShow.filter(logItem => (logItem.data.packageName || "Unknown Package") === currentPackageFilter);
        }
    } else {
        // কোনো ফিল্টার অ্যাক্টিভ নেই। ডিফল্ট হিসাবে আজকের লগ দেখান।
        logsToShow = getTodayLogs();
    }
    
    displaySales(logsToShow);
}


function showPackageReportView(packageName) {
    if (salesStatsWrapper) salesStatsWrapper.classList.add('hidden');
    if (backToFullReportBtn) backToFullReportBtn.classList.remove('hidden');
    if (salesReportTitle) salesReportTitle.innerHTML = `<i class="fas fa-box-open"></i> প্যাকেজ রিপোর্ট: ${packageName}`;
}

function showFullReportView() {
    if (salesStatsWrapper) salesStatsWrapper.classList.remove('hidden');
    if (backToFullReportBtn) backToFullReportBtn.classList.add('hidden');
    if (salesReportTitle) salesReportTitle.innerHTML = `<i class="fas fa-chart-line"></i> সেলস রিপোর্ট (সম্পূর্ণ)`;
}


function formatTimestampToDateTime(timestamp) {
    const date = new Date(timestamp);
    const options = {
        year: 'numeric', month: 'short', day: 'numeric',
        hour: '2-digit', minute: '2-digit', hour12: true,
        timeZone: 'Asia/Dhaka' 
    };
    const displayTime = date.toLocaleString('en-US', options);
    return { displayTime };
}

function getTodayLogs() {
    const now = Date.now() + serverOffset;
    const today_bdt_string = getBdtDateString(now);
    
    return allSalesLogs.filter(logItem => {
        const log_bdt_string = getBdtDateString(logItem.data.timestamp);
        return log_bdt_string === today_bdt_string;
    });
}

function getYesterdayLogs() {
    const now = Date.now() + serverOffset;
    const yesterdayTimestamp = now - (24 * 60 * 60 * 1000); 
    const yesterday_bdt_string = getBdtDateString(yesterdayTimestamp);
    
    return allSalesLogs.filter(logItem => {
        const log_bdt_string = getBdtDateString(logItem.data.timestamp);
        return log_bdt_string === yesterday_bdt_string;
    });
}

// --- loadSalesLog - সব ডাটা লোড করার জন্য ---
function loadSalesLog() {
    if (!salesLogTbody) return;

    // সব লগ রিসেট করুন
    allSalesLogs = [];
    isInitialLoadComplete = false;
    lastLoadedRegularTimestamp = 0;
    lastLoadedResellerTimestamp = 0;
    salesLogTbody.innerHTML = '<tr class="no-data-row"><td colspan="11">সেলস লগ লোড হচ্ছে...</td></tr>';

    // 1. প্রাথমিক ডাটা লোড (সমস্ত সাধারণ সেল)
    const regularQuery = salesLogRef.orderByChild('timestamp').once('value');

    // 2. প্রাথমিক ডাটা লোড (সমস্ত রিসেলার সেল)
    const resellerQuery = resellerSalesLogRef.orderByChild('timestamp').once('value');

    // 3. দুটি লোড একসাথে করি
    Promise.all([
        regularQuery,
        resellerQuery
    ]).then((snapshots) => {

        const regularSnapshot = snapshots[0];
        const resellerSnapshot = snapshots[1];

        // সাধারণ সেলস যোগ করা
        if (regularSnapshot.exists()) {
            regularSnapshot.forEach(child => {
                const logData = child.val();
                allSalesLogs.push({
                    key: child.key, 
                    data: logData,
                    type: 'regular'
                });
                // শেষ টাইমস্ট্যাম্প সেভ করি
                if (logData.timestamp > lastLoadedRegularTimestamp) {
                    lastLoadedRegularTimestamp = logData.timestamp;
                }
            });
        }

        // রিসেলার সেলস যোগ করা
        if (resellerSnapshot.exists()) {
            resellerSnapshot.forEach(child => {
                const resellerData = child.val();
                // রিসেলার সেলসকে সাধারণ সেলের ফরম্যাটে আনা
                const logData = {
                    timestamp: resellerData.timestamp,
                    packageName: resellerData.packageName,
                    packageKey: resellerData.packageKey, 
                    username: resellerData.customerName, 
                    duration: `${resellerData.balanceSold} মাস (রিসেল)`, 
                    balanceSold: resellerData.balanceSold, 
                    amount: resellerData.salePrice, 
                    purchaseCost: resellerData.purchaseCost, 
                    profit: resellerData.profit, 
                    trxId: "Reseller Sale",
                    device: "N/A",
                    paymentMethod: "Reseller",
                    customerWhatsapp: resellerData.customerWhatsapp
                };

                allSalesLogs.push({
                    key: child.key, 
                    data: logData,
                    type: 'reseller'
                });
                // শেষ টাইমস্ট্যাম্প সেভ করি
                if (resellerData.timestamp > lastLoadedResellerTimestamp) {
                    lastLoadedResellerTimestamp = resellerData.timestamp;
                }
            });
        }

        // সব সেলস সময় অনুযায়ী সাজানো (নতুন থেকে পুরাতন)
        allSalesLogs.sort((a, b) => b.data.timestamp - a.data.timestamp);

        isInitialLoadComplete = true;
        console.log(`প্রাথমিক লোড সম্পন্ন। মোট ${allSalesLogs.length} টি লগ লোড হয়েছে।`);
        
        // 4. প্রাথমিক ডাটা দিয়ে UI আপডেট করি (সকল পরিসংখ্যান)
        processAndDisplaySales(); 
        
        // 6. এখন শুধু নতুন সেলের জন্য অপেক্ষা করি
        listenForNewRegularSales();
        listenForNewResellerSales();

    }).catch((error) => {
        console.error("প্রাথমিক সেলস লগ লোড করতে সমস্যা:", error);
        if(salesLogTbody) salesLogTbody.innerHTML = '<tr class="no-data-row"><td colspan="11">সেলস লগ লোড করা যায়নি।</td></tr>';
    });
}

// --- listenForNewRegularSales (অটো-সিঙ্ক সহ) ---
function listenForNewRegularSales() {
    // যে টাইমস্ট্যাম্প পর্যন্ত লোড হয়েছে, তার পর থেকে শুনি (+1)
    const query = salesLogRef.orderByChild('timestamp').startAt(lastLoadedRegularTimestamp + 1);
    
    query.on('child_added', (snapshot) => {
        if (!isInitialLoadComplete) return;

        const newLogData = snapshot.val();
        const newLogKey = snapshot.key;

        const newLogItem = {
            key: newLogKey,
            data: newLogData,
            type: 'regular'
        };
        
        if (newLogItem.data.timestamp <= lastLoadedRegularTimestamp) {
            return;
        }
        lastLoadedRegularTimestamp = newLogItem.data.timestamp;

        // নতুন সেলটি অ্যারের শুরুতে যোগ করুন
        allSalesLogs.unshift(newLogItem);
        console.log("একটি নতুন 'সাধারণ' সেল এসেছে।");
        
        // --- অটো কাস্টমার সিঙ্ক লজিক ---
        try {
            const log = newLogData;
            if (log && log.customerWhatsapp && log.customerWhatsapp !== 'N/A' && (log.amount || 0) > 0) {
                const whatsapp = log.customerWhatsapp;
                const basePackageName = log.packageName ? log.packageName.replace(/\s+\(WITH ADULT\)$|\s+\(FAMILY PACK\)$/, '') : 'Unknown Package';
                
                const customerData = {
                    whatsapp: whatsapp,
                    name: log.username || whatsapp, 
                    packageName: basePackageName, 
                    lastSaleTimestamp: log.timestamp, 
                    details: "Auto-synced (Last Sale Logged)"
                };

                const customerQuery = regularCustomersRef.orderByChild('whatsapp').equalTo(whatsapp).limitToFirst(1);
                
                customerQuery.once('value', (customerSnapshot) => {
                    if (customerSnapshot.exists()) {
                        customerSnapshot.forEach((child) => {
                            const existingKey = child.key;
                            regularCustomersRef.child(existingKey).update(customerData);
                        });
                    } else {
                        regularCustomersRef.push(customerData);
                    }
                });
            }
        } catch (e) {
            console.error("নতুন সেলস থেকে কাস্টমার সিঙ্ক করতে সমস্যা:", e);
        }
        // --- সিঙ্ক লজিক শেষ ---

        // UI আপডেট করুন
        processAndDisplaySales();
    });
}

function listenForNewResellerSales() {
    const query = resellerSalesLogRef.orderByChild('timestamp').startAt(lastLoadedResellerTimestamp + 1);

    query.on('child_added', (snapshot) => {
        if (!isInitialLoadComplete) return;

        const resellerData = snapshot.val();
        // রিসেলার সেলসকে সাধারণ সেলের ফরম্যাটে আনা
        const logData = {
            timestamp: resellerData.timestamp,
            packageName: resellerData.packageName,
            packageKey: resellerData.packageKey, 
            username: resellerData.customerName, 
            duration: `${resellerData.balanceSold} মাস (রিসেল)`, 
            balanceSold: resellerData.balanceSold, 
            amount: resellerData.salePrice, 
            purchaseCost: resellerData.purchaseCost, 
            profit: resellerData.profit, 
            trxId: "Reseller Sale",
            device: "N/A",
            paymentMethod: "Reseller",
            customerWhatsapp: resellerData.customerWhatsapp
        };

        const newLogItem = {
            key: snapshot.key,
            data: logData,
            type: 'reseller'
        };

        if (resellerData.timestamp <= lastLoadedResellerTimestamp) {
            return;
        }
        lastLoadedResellerTimestamp = resellerData.timestamp;

        allSalesLogs.unshift(newLogItem);
        console.log("একটি নতুন 'রিসেলার' সেল এসেছে।");

        processAndDisplaySales();
    });
}


// --- processAndDisplaySales ---
function processAndDisplaySales() {
    
    if (!isInitialLoadComplete) {
        return; 
    }

    // 1. আজকের স্ট্যাটাস গণনা
    const todayLogs = getTodayLogs();
    let todaySales = 0;
    let todayOrders = 0;
    let todayPurchaseCost = 0; 
    let todayProfit = 0;
    
    todayLogs.forEach(logItem => {
        const log = logItem.data;
        const amount = log.amount || 0;
        const purchaseCost = log.purchaseCost || 0;
        const profit = (logItem.type === 'reseller') ? (log.profit || 0) : (amount - purchaseCost);

        todaySales += amount;
        todayPurchaseCost += purchaseCost; 
        todayProfit += profit;
        todayOrders++;
    });

    // 2. UI তে স্ট্যাটাস বসানো
    if(adminTodaySalesEl) adminTodaySalesEl.textContent = `৳ ${todaySales}`;
    if(adminTodayOrdersEl) adminTodayOrdersEl.textContent = todayOrders;
    if(adminTodayPurchaseEl) adminTodayPurchaseEl.textContent = `৳ ${todayPurchaseCost}`;
    if(adminTodayProfitEl) adminTodayProfitEl.textContent = `৳ ${todayProfit}`;
    
    // 3. সমস্ত পরিসংখ্যান আপডেট
    calculateLifetimeStats(allSalesLogs); 
    calculatePaymentMethodStats(allSalesLogs); 
    calculatePackageSalesStats(allSalesLogs);
    
    // ❌❌ হ্যাং বন্ধ করার জন্য রিমাইন্ডার অটো ক্যালকুলেশন বন্ধ করা হলো ❌❌
    // calculateAndDisplayReminders(allSalesLogs); // এটি এখন মেন্যু ক্লিকে লোড হবে
    
    // 4. ফিল্টার করা ডিসপ্লে আপডেট
    displayPaymentMethodStats(getActivePaymentPeriod()); 
    displayPackageSalesStats(getActivePackagePeriod(), getActiveOrderType()); 

    // 5. সেলস টেবিল আপডেট
    refreshSalesTableView();
}


function displaySales(logs) {
    if (!salesLogTbody) return;
    
    // 'Select All' চেকবক্স আনচেক করা
    if (selectAllSalesLogsCheckbox) {
        selectAllSalesLogsCheckbox.checked = false;
    }

    const searchQuery = salesSearchInput ? salesSearchInput.value.trim() : '';
    const paymentMethod = salesPaymentMethodFilter ? salesPaymentMethodFilter.value : 'all';

    let filteredLogs = logs.filter(logItem => {
        const log = logItem.data;
        
        // সেলস টাইপ অনুযায়ী ফিল্টার
        if (currentSaleTypeFilter === 'regular' && logItem.type !== 'regular') {
            return false;
        }
        if (currentSaleTypeFilter === 'reseller' && logItem.type !== 'reseller') {
            return false;
        }
        
        // অর্ডার টাইপ (ট্রায়াল/পেইড)
        if (logItem.type === 'regular') {
            if (currentOrderTypeFilter === 'paid' && getOrderType(log.duration) !== 'paid') {
                return false;
            }
            if (currentOrderTypeFilter === 'trial' && getOrderType(log.duration) !== 'trial') {
                return false;
            }
        } else {
            // রিসেলার সেলস সবসময় 'paid'
            if (currentOrderTypeFilter === 'trial') return false;
        }
        
        // সার্চ
        if (searchQuery) {
            const query = searchQuery.toLowerCase(); 
            const nameMatch = (log.username || "").toLowerCase().includes(query);
            
            let logWhatsapp = log.customerWhatsapp || "";
            if (logWhatsapp.startsWith('88')) {
                 logWhatsapp = logWhatsapp.substring(2); 
            }
            
            let normalizedSearchQuery = searchQuery;
            if (normalizedSearchQuery.startsWith('88')) {
                normalizedSearchQuery = normalizedSearchQuery.substring(2); 
            }
            
            const whatsappMatch = logWhatsapp.includes(normalizedSearchQuery);
            
            if (!whatsappMatch && !nameMatch) {
                return false;
            }
        }
        
        // পেমেন্ট মেথড
        if (paymentMethod !== 'all') {
            const logPaymentMethod = (log.paymentMethod || 'N/A').toLowerCase();
            
            if (logItem.type === 'reseller' && paymentMethod !== 'reseller') {
                 return false;
            }
            if (logItem.type === 'regular' && paymentMethod === 'reseller') {
                 return false;
            }
            
            if (paymentMethod === 'trial') {
                 const logTrxId = (log.trxId || "");
                if (logPaymentMethod !== 'n/a' && logTrxId.toUpperCase() !== 'TRIAL' && (log.amount || 0) > 0) {
                    return false;
                }
            } else if (paymentMethod !== 'reseller') {
                if (logPaymentMethod !== paymentMethod) {
                    return false;
                }
            }
        }
        
        return true; 
    });


    salesLogTbody.innerHTML = '';
    
    if (filteredLogs.length === 0) {
        salesLogTbody.innerHTML = '<tr class="no-data-row"><td colspan="11">এই ফিল্টারে কোনো সেলস পাওয়া যায়নি।</td></tr>';
        filteredTotalSalesEl.textContent = '৳ ০';
        filteredTotalOrdersEl.textContent = '০';
        return;
    }

    let totalSales = 0;
    let totalOrders = 0;

    filteredLogs.forEach(logItem => { 
        const log = logItem.data; 
        const key = logItem.key; 
        
        const { displayTime } = formatTimestampToDateTime(log.timestamp);
        const amount = log.amount || 0;
        
        const row = document.createElement('tr');
        row.innerHTML = `
            <td class="sales-log-checkbox-cell">
                <input type="checkbox" class="sales-log-checkbox" data-key="${key}" data-type="${logItem.type}">
            </td>
            <td>${displayTime}</td>
            <td>${logItem.type === 'reseller' ? '<span class="reseller-tag">রিসেলার</span>' : 'সাধারণ'}</td> 
            <td>${log.packageName || 'N/A'}</td>
            <td>${log.username || '-'}</td>
            <td>${log.duration || 'N/A'}</td>
            <td>${log.paymentMethod || 'N/A'}</td>
            <td>${log.trxId || 'N/A'}</td>
            <td>${log.customerWhatsapp || 'N/A'}</td> 
            <td>${amount}</td>
            <td>
                <button class="sales-action-btn edit-btn edit-sales-btn" data-key="${key}">✏️</button>
                <button class="sales-action-btn delete-btn delete-sales-btn" data-key="${key}">❌</button>
            </td>
        `;
        salesLogTbody.appendChild(row);

        totalSales += amount;
        totalOrders++;
    });

    filteredTotalSalesEl.textContent = `৳ ${totalSales}`;
    filteredTotalOrdersEl.textContent = totalOrders;
}

function calculateLifetimeStats(logs) {
    let totalSales7 = 0, totalSales30 = 0, totalSalesLastMonth = 0, allTimeSales = 0;
    let totalPurchase7 = 0, totalPurchase30 = 0, totalPurchaseLastMonth = 0, allTimePurchase = 0;
    let totalProfit7 = 0, totalProfit30 = 0, totalProfitLastMonth = 0, allTimeProfit = 0;
    let totalOrders7 = 0, totalOrders30 = 0, totalOrdersLastMonth = 0, allTimeOrders = 0; 
    
    // রিসেলার ভেরিয়েবল
    let resellerSales7 = 0, resellerSales30 = 0, resellerSalesLastMonth = 0, allTimeResellerSales = 0;
    let resellerProfit7 = 0, resellerProfit30 = 0, resellerProfitLastMonth = 0, allTimeResellerProfit = 0;

    const now = Date.now() + serverOffset;
    const bdtNow = getBdtTimezoneDate(now);
    const today = new Date(bdtNow.getFullYear(), bdtNow.getMonth(), bdtNow.getDate()).getTime();
    
    const sevenDaysAgo = today - (6 * 24 * 60 * 60 * 1000); 
    const thirtyDaysAgo = today - (29 * 24 * 60 * 60 * 1000); 
    const { start: lastMonthStart, end: lastMonthEnd } = getLastMonthBdtBoundaries(now);

    logs.forEach(logItem => {
        const log = logItem.data;
        const amount = log.amount || 0;
        const purchaseCost = log.purchaseCost || 0; 
        
        const profit = (logItem.type === 'reseller') ? (log.profit || 0) : (amount - purchaseCost);
        const timestamp = log.timestamp;

        // মোট গণনা (সাধারণ + রিসেলার)
        allTimeSales += amount;
        allTimePurchase += purchaseCost; 
        allTimeProfit += profit; 
        allTimeOrders++; 

        if (timestamp >= thirtyDaysAgo) {
            totalSales30 += amount;
            totalPurchase30 += purchaseCost; 
            totalProfit30 += profit;
            totalOrders30++; 
        }

        if (timestamp >= sevenDaysAgo) {
            totalSales7 += amount;
            totalPurchase7 += purchaseCost; 
            totalProfit7 += profit;
            totalOrders7++; 
        }
        
        if (timestamp >= lastMonthStart && timestamp <= lastMonthEnd) {
            totalSalesLastMonth += amount;
            totalPurchaseLastMonth += purchaseCost;
            totalProfitLastMonth += profit;
            totalOrdersLastMonth++;
        }
        
        // শুধু রিসেলার সেলস গণনা
        if (logItem.type === 'reseller') {
            allTimeResellerSales += amount;
            allTimeResellerProfit += profit;

            if (timestamp >= thirtyDaysAgo) {
                resellerSales30 += amount;
                resellerProfit30 += profit;
            }
            if (timestamp >= sevenDaysAgo) {
                resellerSales7 += amount;
                resellerProfit7 += profit;
            }
            if (timestamp >= lastMonthStart && timestamp <= lastMonthEnd) {
                resellerSalesLastMonth += amount;
                resellerProfitLastMonth += profit;
            }
        }
    });

    // ৭ দিনের রিপোর্ট (সাধারণ)
    if (last7DaysSalesEl) last7DaysSalesEl.textContent = `৳ ${totalSales7}`;
    if (last7DaysPurchaseEl) last7DaysPurchaseEl.textContent = `৳ ${totalPurchase7}`;
    if (last7DaysProfitEl) last7DaysProfitEl.textContent = `৳ ${totalProfit7}`;
    if (last7DaysOrdersEl) last7DaysOrdersEl.textContent = totalOrders7;
    
    // ৩০ দিনের রিপোর্ট (সাধারণ)
    if (last30DaysSalesEl) last30DaysSalesEl.textContent = `৳ ${totalSales30}`;
    if (last30DaysPurchaseEl) last30DaysPurchaseEl.textContent = `৳ ${totalPurchase30}`;
    if (last30DaysProfitEl) last30DaysProfitEl.textContent = `৳ ${totalProfit30}`; 
    if (last30DaysOrdersEl) last30DaysOrdersEl.textContent = totalOrders30;

    // গত মাসের রিপোর্ট (সাধারণ)
    if (lastMonthSalesEl) lastMonthSalesEl.textContent = `৳ ${totalSalesLastMonth}`;
    if (lastMonthPurchaseEl) lastMonthPurchaseEl.textContent = `৳ ${totalPurchaseLastMonth}`;
    if (lastMonthProfitEl) lastMonthProfitEl.textContent = `৳ ${totalProfitLastMonth}`; 
    if (lastMonthOrdersEl) lastMonthOrdersEl.textContent = totalOrdersLastMonth;

    // মোট (সর্বদা) রিপোর্ট (সাধারণ)
    if (allTimeSalesEl) allTimeSalesEl.textContent = `৳ ${allTimeSales}`;
    if (allTimePurchaseEl) allTimePurchaseEl.textContent = `৳ ${allTimePurchase}`;
    if (allTimeProfitEl) allTimeProfitEl.textContent = `৳ ${allTimeProfit}`; 
    if (allTimeOrdersEl) allTimeOrdersEl.textContent = allTimeOrders;
    
    // রিসেলার কার্ডে তথ্য বসানো
    if (last7DaysResellerSalesEl) last7DaysResellerSalesEl.textContent = `৳ ${resellerSales7}`;
    if (last30DaysResellerSalesEl) last30DaysResellerSalesEl.textContent = `৳ ${resellerSales30}`;
    if (lastMonthResellerSalesEl) lastMonthResellerSalesEl.textContent = `৳ ${resellerSalesLastMonth}`;
    if (allTimeResellerSalesEl) allTimeResellerSalesEl.textContent = `৳ ${allTimeResellerSales}`;
    if (last7DaysResellerProfitEl) last7DaysResellerProfitEl.textContent = `৳ ${resellerProfit7}`;
    if (last30DaysResellerProfitEl) last30DaysResellerProfitEl.textContent = `৳ ${resellerProfit30}`;
    if (lastMonthResellerProfitEl) lastMonthResellerProfitEl.textContent = `৳ ${resellerProfitLastMonth}`;
    if (allTimeResellerProfitEl) allTimeResellerProfitEl.textContent = `৳ ${allTimeResellerProfit}`;
}


function calculatePaymentMethodStats(logs) {
    paymentMethodStats = {
        bkash: { today: 0, yesterday: 0, '7days': 0, '30days': 0, lastMonth: 0, all: 0 },
        nagad: { today: 0, yesterday: 0, '7days': 0, '30days': 0, lastMonth: 0, all: 0 },
        rocket: { today: 0, yesterday: 0, '7days': 0, '30days': 0, lastMonth: 0, all: 0 },
        upay: { today: 0, yesterday: 0, '7days': 0, '30days': 0, lastMonth: 0, all: 0 }
    };

    const now = Date.now() + serverOffset;
    const today_bdt_string = getBdtDateString(now);
    const yesterday_bdt_string = getBdtDateString(now - (24 * 60 * 60 * 1000));
    
    const bdtNow = getBdtTimezoneDate(now);
    const today = new Date(bdtNow.getFullYear(), bdtNow.getMonth(), bdtNow.getDate()).getTime();
    
    const sevenDaysAgo = today - (6 * 24 * 60 * 60 * 1000); 
    const thirtyDaysAgo = today - (29 * 24 * 60 * 60 * 1000); 
    
    const { start: lastMonthStart, end: lastMonthEnd } = getLastMonthBdtBoundaries(now);

    logs.forEach(logItem => {
        // শুধু সাধারণ সেলের জন্য পেমেন্ট মেথড গণনা
        if (logItem.type === 'regular') {
            const log = logItem.data;
            const amount = log.amount || 0;
            const timestamp = log.timestamp;
            const method = (log.paymentMethod || 'N/A').toLowerCase();
            
            const logDateStr_bdt = getBdtDateString(timestamp);
            
            let statsKey = null;
            if (method === 'bkash') statsKey = 'bkash';
            else if (method === 'nagad') statsKey = 'nagad';
            else if (method === 'rocket') statsKey = 'rocket';
            else if (method === 'upay') statsKey = 'upay';
            
            if (statsKey) {
                paymentMethodStats[statsKey].all += amount;
                
                if (timestamp >= thirtyDaysAgo) {
                    paymentMethodStats[statsKey]['30days'] += amount;
                }
                
                if (timestamp >= sevenDaysAgo) {
                    paymentMethodStats[statsKey]['7days'] += amount;
                }

                if (timestamp >= lastMonthStart && timestamp <= lastMonthEnd) {
                    paymentMethodStats[statsKey].lastMonth += amount;
                }

                if (logDateStr_bdt === yesterday_bdt_string) {
                    paymentMethodStats[statsKey].yesterday += amount;
                }
                
                if (logDateStr_bdt === today_bdt_string) {
                    paymentMethodStats[statsKey].today += amount;
                }
            }
        }
    });
}

function displayPaymentMethodStats(period) {
    if (!bkashSalesEl || !nagadSalesEl || !rocketSalesEl || !upaySalesEl) return;
    
    bkashSalesEl.textContent = `৳ ${paymentMethodStats.bkash[period] || 0}`;
    nagadSalesEl.textContent = `৳ ${paymentMethodStats.nagad[period] || 0}`;
    rocketSalesEl.textContent = `৳ ${paymentMethodStats.rocket[period] || 0}`;
    upaySalesEl.textContent = `৳ ${paymentMethodStats.upay[period] || 0}`;
}

function getActivePaymentPeriod() {
    if (!paymentStatsFilterButtonsContainer) return 'today';
    const activeButton = paymentStatsFilterButtonsContainer.querySelector('.stat-filter-btn.active');
    return activeButton ? activeButton.dataset.period : 'today'; 
}

function getActiveOrderType() {
    if (!orderTypeFilterButtonsContainer) return 'all';
    const activeButton = orderTypeFilterButtonsContainer.querySelector('.stat-filter-btn.active');
    return activeButton ? activeButton.dataset.type : 'all';
}


function calculatePackageSalesStats(logs) {
    packageSalesStats = {}; 

    const now = Date.now() + serverOffset;
    const today_bdt_string = getBdtDateString(now);
    const yesterday_bdt_string = getBdtDateString(now - (24 * 60 * 60 * 1000));

    const bdtNow = getBdtTimezoneDate(now);
    const today = new Date(bdtNow.getFullYear(), bdtNow.getMonth(), bdtNow.getDate()).getTime();

    const sevenDaysAgo = today - (6 * 24 * 60 * 60 * 1000); 
    const thirtyDaysAgo = today - (29 * 24 * 60 * 60 * 1000);
    
    const { start: lastMonthStart, end: lastMonthEnd } = getLastMonthBdtBoundaries(now);


    logs.forEach(logItem => {
        const log = logItem.data;
        const timestamp = log.timestamp;
        const packageName = log.packageName || "Unknown Package";
        
        const orderType = (logItem.type === 'regular') ? getOrderType(log.duration) : 'paid';
        const orderValue = (logItem.type === 'regular') ? getDeductionAmount(log.duration) : (log.balanceSold || 0); 
        
        if (!packageSalesStats[packageName]) {
            packageSalesStats[packageName] = {
                today: { all: 0, paid: 0, trial: 0 },
                yesterday: { all: 0, paid: 0, trial: 0 },
                '7days': { all: 0, paid: 0, trial: 0 },
                '30days': { all: 0, paid: 0, trial: 0 },
                lastMonth: { all: 0, paid: 0, trial: 0 },
                all: { all: 0, paid: 0, trial: 0 }
            };
        }
        
        const logDateStr_bdt = getBdtDateString(timestamp);
        
        packageSalesStats[packageName].all.all += orderValue;
        if(orderType === 'paid') {
             packageSalesStats[packageName].all.paid += orderValue;
        } else if (orderType === 'trial') {
             packageSalesStats[packageName].all.trial += orderValue;
        }
        
        
        if (timestamp >= thirtyDaysAgo) {
            packageSalesStats[packageName]['30days'].all += orderValue;
            if(orderType === 'paid') {
                packageSalesStats[packageName]['30days'].paid += orderValue;
            } else if (orderType === 'trial') {
                packageSalesStats[packageName]['30days'].trial += orderValue;
            }
        }
        
        if (timestamp >= sevenDaysAgo) {
            packageSalesStats[packageName]['7days'].all += orderValue;
            if(orderType === 'paid') {
                packageSalesStats[packageName]['7days'].paid += orderValue;
            } else if (orderType === 'trial') {
                packageSalesStats[packageName]['7days'].trial += orderValue;
            }
        }

        if (timestamp >= lastMonthStart && timestamp <= lastMonthEnd) {
             packageSalesStats[packageName].lastMonth.all += orderValue;
            if(orderType === 'paid') {
                packageSalesStats[packageName].lastMonth.paid += orderValue;
            } else if (orderType === 'trial') {
                packageSalesStats[packageName].lastMonth.trial += orderValue;
            }
        }

        if (logDateStr_bdt === yesterday_bdt_string) {
            packageSalesStats[packageName].yesterday.all += orderValue;
            if(orderType === 'paid') {
                packageSalesStats[packageName].yesterday.paid += orderValue;
            } else if (orderType === 'trial') {
                packageSalesStats[packageName].yesterday.trial += orderValue;
            }
        }
        
        if (logDateStr_bdt === today_bdt_string) {
            packageSalesStats[packageName].today.all += orderValue;
            if(orderType === 'paid') {
                packageSalesStats[packageName].today.paid += orderValue;
            } else if (orderType === 'trial') {
                packageSalesStats[packageName].today.trial += orderValue;
            }
        }
    });
}

function displayPackageSalesStats(period, orderType) {
    if (!packageSalesStatsContainer) return;
    packageSalesStatsContainer.innerHTML = ''; 
    
    const searchQuery = packageSearchInput ? packageSearchInput.value.toLowerCase() : '';

    const sortedPackages = Object.keys(packageSalesStats).sort((a, b) => {
        const countB = (packageSalesStats[b][period] && packageSalesStats[b][period][orderType]) ? packageSalesStats[b][period][orderType] : 0;
        const countA = (packageSalesStats[a][period] && packageSalesStats[a][period][orderType]) ? packageSalesStats[a][period][orderType] : 0;
        return countB - countA;
    });

    if (sortedPackages.length === 0) {
        packageSalesStatsContainer.innerHTML = '<p>কোনো প্যাকেজ সেলস ডেটা পাওয়া যায়নি।</p>';
        return;
    }

    let itemsFound = false; 
    sortedPackages.forEach(packageName => {
        if (searchQuery && !packageName.toLowerCase().includes(searchQuery)) {
            return;
        }
        
        const count = (packageSalesStats[packageName][period] && packageSalesStats[packageName][period][orderType]) ? packageSalesStats[packageName][period][orderType] : 0;
        
        if (count > 0) { 
            itemsFound = true; 
            const itemEl = document.createElement('div');
            itemEl.classList.add('package-stat-item');
            itemEl.dataset.packageName = packageName; 
            itemEl.innerHTML = `
                <span class="package-name">${packageName}</span>
                <span class="package-count">${count}</span>
            `;
            packageSalesStatsContainer.appendChild(itemEl);
        }
    });
    
    if (!itemsFound) { 
        if (searchQuery) {
            packageSalesStatsContainer.innerHTML = '<p>এই নামে কোনো প্যাকেজ সেল হয়নি।</p>';
        } else {
            packageSalesStatsContainer.innerHTML = '<p>এই ফিল্টারে কোনো প্যাকেজ সেল হয়নি।</p>';
        }
    }
}

function getActivePackagePeriod() {
    if (!packageStatsFilterButtonsContainer) return 'today';
    const activeButton = packageStatsFilterButtonsContainer.querySelector('.stat-filter-btn.active');
    return activeButton ? activeButton.dataset.period : 'today'; 
}


function filterByPackage(packageName) {
    currentPackageFilter = packageName; 
    showPackageReportView(packageName); 
    refreshSalesTableView();
}

function deleteSalesLog(key, showConfirmation = false) {
    
    return new Promise((resolve, reject) => {
        if (showConfirmation) {
            if (!confirm("আপনি কি সত্যিই এই সেলস লগটি ডিলিট করতে চান? এটি মোট সেলস এবং লাভ থেকেও বিয়োগ হয়ে যাবে।")) {
                reject("User cancelled deletion.");
                return;
            }
        }
        
        const logItemIndex = allSalesLogs.findIndex(item => item.key === key);
        if (logItemIndex === -1) {
            showError({ message: "লগটি পাওয়া যায়নি, সম্ভবত আগেই ডিলিট করা হয়েছে।" });
            reject("Log not found.");
            return;
        }
        
        const logItem = allSalesLogs[logItemIndex];
        const logData = logItem.data;
        const refToDelete = (logItem.type === 'reseller') ? resellerSalesLogRef : salesLogRef;
        
        refToDelete.child(key).remove()
            .then(() => {
                if (showConfirmation) { 
                    showSuccessMessage("সেলস লগ সফলভাবে ডিলিট হয়েছে।");
                }
                
                allSalesLogs.splice(logItemIndex, 1);
                
                if (showConfirmation) {
                    processAndDisplaySales();
                }
                
                // --- স্টক ফেরতের লজিক ---
                if (logItem.type === 'regular') {
                    const amountToDelete = logData.amount || 0; 
                    const today_bdt = getBdtDateString(Date.now() + serverOffset);
                    const logDate_bdt = getBdtDateString(logData.timestamp);

                    if (logDate_bdt === today_bdt) {
                        if (amountToDelete > 0) {
                            visitCountsRef.child('todaySales').transaction((currentSales) => {
                                const newSales = (currentSales || 0) - amountToDelete;
                                return newSales < 0 ? 0 : newSales;
                            });
                        }
                    }
                    
                    // স্টক ফেরত
                    const duration = logData.duration || "";
                    const packageNameFromLog = logData.packageName || "";
                    let amountToRefund = getDeductionAmount(duration);

                    if (amountToRefund > 0 && packageNameFromLog) {
                        packagesRef.once("value", (pkgSnapshot) => {
                            pkgSnapshot.forEach((child) => {
                                const basePackageName = packageNameFromLog.split(" (")[0];
                                
                                if (child.val().name === basePackageName) {
                                    const packageKey = child.key;
                                    const packageStockRef = packagesRef.child(packageKey).child('balance');
                                    
                                    packageStockRef.transaction((currentBalance) => {
                                        if (currentBalance !== null && currentBalance !== undefined) {
                                            return (parseInt(currentBalance) || 0) + amountToRefund; 
                                        }
                                        return currentBalance; 
                                    });
                                }
                            });
                        });
                    }
                } 
                // রিসেলার সেলের জন্য স্টক ফেরত
                else if (logItem.type === 'reseller') {
                    const balanceToRefund = logData.balanceSold || 0;
                    const packageKey = logData.packageKey || ""; 

                    if (balanceToRefund > 0 && packageKey) {
                        const packageStockRef = packagesRef.child(packageKey).child('balance');
                        
                        packageStockRef.transaction((currentBalance) => {
                            if (currentBalance !== null && currentBalance !== undefined) {
                                return (parseInt(currentBalance) || 0) + balanceToRefund; 
                            }
                            return currentBalance; 
                        });
                    }
                }
                
                resolve(); 
                
            })
            .catch(err => {
                showError(err);
                reject(err); 
            });
    });
}


function openSalesEditModal(key) {
    const logItem = allSalesLogs.find(item => item.key === key);
    if (!logItem) {
        alert("লগ খুঁজে পাওয়া যায়নি।");
        return;
    }
    
    // রিসেলার সেলস এডিট করা যাবে না
    if (logItem.type === 'reseller') {
        alert("রিসেলার সেলস এখান থেকে এডিট করা যাবে না। দয়া করে ডিলিট করে নতুন করে এন্ট্রি দিন।");
        return;
    }
    
    const log = logItem.data;
    
    currentEditKey = key; 
    editSalesTimestampInput.value = formatTimestampToInput(log.timestamp);
    editPackageNameInput.value = log.packageName || '';
    editSalesUsernameInput.value = log.username || ''; 
    editDurationInput.value = log.duration || '';
    editTrxIdInput.value = log.trxId || '';
    editAmountInput.value = log.amount || 0;
    editCustomerWhatsappInput.value = log.customerWhatsapp || ''; 
    
    salesEditModal.classList.remove('hidden');
    salesEditModal.style.display = 'flex'; 
}

function closeSalesEditModal() {
    currentEditKey = null;
    salesEditModal.classList.add('hidden');
    salesEditModal.style.display = 'none'; 
    
    editSalesTimestampInput.value = '';
    editPackageNameInput.value = '';
    editSalesUsernameInput.value = ''; 
    editDurationInput.value = '';
    editTrxIdInput.value = '';
    editAmountInput.value = '';
    editCustomerWhatsappInput.value = ''; 
}

function saveSalesEdit() {
    if (!currentEditKey) {
        alert("একটি সমস্যা হয়েছে। দয়া করে আবার চেষ্টা করুন।");
        return;
    }

    const logItemIndex = allSalesLogs.findIndex(item => item.key === currentEditKey);
    if (logItemIndex === -1) {
        alert("লগ খুঁজে পাওয়া যায়নি।");
        return;
    }
    
    const logItem = allSalesLogs[logItemIndex];
    if (logItem.type === 'reseller') {
        alert("লগ খুঁজে পাওয়া যায়নি অথবা এটি একটি রিসেলার সেল।");
        return;
    }
    
    const oldAmount = logItem.data.amount || 0;
    const oldTimestamp = logItem.data.timestamp; 
    
    const newAmount = parseInt(editAmountInput.value) || 0;
    const newTimestamp = formatInputToTimestamp(editSalesTimestampInput.value);
    
    if (isNaN(newTimestamp)) {
        alert("তারিখ ও সময় সঠিক নয়। দয়া করে আবার চেষ্টা করুন।");
        return;
    }
    
    const amountDifference = newAmount - oldAmount; 

    const updatedLogData = {
        packageName: editPackageNameInput.value,
        username: editSalesUsernameInput.value, 
        duration: editDurationInput.value,
        trxId: editTrxIdInput.value,
        amount: newAmount,
        customerWhatsapp: editCustomerWhatsappInput.value, 
        timestamp: newTimestamp, 
        paymentMethod: logItem.data.paymentMethod,
        device: logItem.data.device,
        purchaseCost: logItem.data.purchaseCost || 0 
    };

    salesLogRef.child(currentEditKey).update(updatedLogData)
        .then(() => {
            showSuccessMessage("সেলস লগ সফলভাবে আপডেট হয়েছে!");
            closeSalesEditModal();

            // 'allSalesLogs' অ্যারে ম্যানুয়ালি আপডেট করুন
            allSalesLogs[logItemIndex].data = updatedLogData;
            
            // টাইমস্ট্যাম্প পরিবর্তন হলে অ্যারেটি আবার সর্ট করা ভালো
            if (oldTimestamp !== newTimestamp) {
                allSalesLogs.sort((a, b) => b.data.timestamp - a.data.timestamp);
            }

            processAndDisplaySales();
            
            // --- আজকের সেলস গণনা আপডেট ---
            const today_bdt = getBdtDateString(Date.now() + serverOffset);
            const oldLogDate_bdt = getBdtDateString(oldTimestamp);
            const newLogDate_bdt = getBdtDateString(newTimestamp);

            if (oldLogDate_bdt === today_bdt && newLogDate_bdt !== today_bdt) {
                visitCountsRef.child('todaySales').transaction(current => (current || 0) - oldAmount);
            } 
            else if (oldLogDate_bdt !== today_bdt && newLogDate_bdt === today_bdt) {
                visitCountsRef.child('todaySales').transaction(current => (current || 0) + newAmount);
            } 
            else if (oldLogDate_bdt === today_bdt && newLogDate_bdt === today_bdt) {
                if (amountDifference !== 0) {
                    visitCountsRef.child('todaySales').transaction(current => (current || 0) + amountDifference);
                }
            }
        })
        .catch(showError);
}


// --- রিমাইন্ডার ফাংশন ---

function initializeReminderListeners() {
    
    // ✅✅✅ নতুন: রিমাইন্ডার মেন্যুতে ক্লিক করলে তবেই লিস্ট লোড হবে ✅✅✅
    const reminderPageBtn = document.querySelector('.menu-button[data-target="page-reminders"]');
    if (reminderPageBtn) {
        reminderPageBtn.addEventListener('click', () => {
            // ব্যবহারকারী যখন রিমাইন্ডার পেজে ঢুকবে, তখন লোড হবে
            showSuccessMessage("রিমাইন্ডার ডাটা লোড হচ্ছে..."); // ইউজারকে জানানোর জন্য
            setTimeout(() => {
                 calculateAndDisplayReminders(allSalesLogs);
            }, 50); // UI ফ্রিজ এড়ানোর জন্য ছোট ডিলে
        });
    }
    
    if (saveReminderTemplateBtn) {
        saveReminderTemplateBtn.addEventListener('click', () => {
            const newTemplate = reminderTemplateInput.value;
            siteContentRef.child('reminders/template').set(newTemplate)
                .then(() => {
                    reminderMessageTemplate = newTemplate; 
                    showSuccessMessage("রিমাইন্ডার টেমপ্লেট সেভ হয়েছে!");
                })
                .catch(showError);
        });
    }
    
    const listsContainer = document.querySelector('.reminder-lists');
    if (listsContainer) {
        listsContainer.addEventListener('click', (e) => {
            const sendBtn = e.target.closest('.send-reminder-btn');
            const editBtn = e.target.closest('.reminder-edit-btn'); 

            if (sendBtn && !sendBtn.disabled) {
                let whatsappNum = sendBtn.dataset.whatsapp;
                const packageName = sendBtn.dataset.package;
                const expiryDate = sendBtn.dataset.expiry;
                const username = sendBtn.dataset.username || ""; 

                if (!whatsappNum || whatsappNum === 'N/A') {
                    alert("এই অর্ডারের সাথে কোনো WhatsApp নম্বর সেভ করা নেই।");
                    return;
                }
                
                const uniqueId = `${whatsappNum}_${packageName}_${expiryDate}`;
                
                if (whatsappNum.startsWith('01')) {
                    whatsappNum = '880' + whatsappNum.substring(1);
                } else if (whatsappNum.startsWith('+880')) {
                    whatsappNum = whatsappNum.substring(1); 
                }
                
                if (!whatsappNum.startsWith('880') || whatsappNum.length < 13) {
                     alert("এই WhatsApp নম্বরটি সঠিক নয়: " + sendBtn.dataset.whatsapp + "\nসঠিক ফরম্যাট: 01... অথবা 880...");
                     return;
                }
                
                const message = reminderMessageTemplate
                    .replace(/\[package]/g, packageName)
                    .replace(/\[date]/g, expiryDate)
                    .replace(/\[username]/g, username);
                
                const url = `https://api.whatsapp.com/send?phone=${whatsappNum}&text=${encodeURIComponent(message)}`;
                window.open(url, '_blank');
                
                sentReminders.add(uniqueId); 
                saveSentReminders(sentReminders); 
                
                calculateAndDisplayReminders(allSalesLogs);
            } 
            else if (editBtn) { 
                const logKey = editBtn.dataset.logkey;
                const currentWhatsapp = editBtn.dataset.whatsapp;
                const currentTimestamp = parseInt(editBtn.dataset.timestamp);
                
                if (logKey) {
                    openReminderEditModal(logKey, currentWhatsapp, currentTimestamp); 
                } else {
                    alert("ত্রুটি: অর্ডার আইডি খুঁজে পাওয়া যায়নি।");
                }
            }
        });
    }
    
    if (sendManualReminderBtn) {
        sendManualReminderBtn.addEventListener('click', () => {
            let whatsappNum = manualReminderNumberInput.value;
            if (!whatsappNum || whatsappNum.length < 10) {
                alert("অনুগ্রহ করে একটি সঠিক WhatsApp নম্বর দিন।");
                return;
            }

            if (whatsappNum.startsWith('01')) {
                whatsappNum = '880' + whatsappNum.substring(1);
            } else if (!whatsappNum.startsWith('880')) {
                alert("অনুগ্রহ করে 880... অথবা 01... দিয়ে শুরু হওয়া সঠিক নম্বর দিন।");
                return;
            }
            
            const message = reminderMessageTemplate
                    .replace(/\[package]/g, 'আপনার প্যাকেজ')
                    .replace(/\[date]/g, 'শীঘ্রই')
                    .replace(/\[username]/g, ''); 
            
            const url = `https://api.whatsapp.com/send?phone=${whatsappNum}&text=${encodeURIComponent(message)}`;
            window.open(url, '_blank');
            manualReminderNumberInput.value = ''; 
        });
    }
    
    if (reminderModalCloseButton) reminderModalCloseButton.addEventListener('click', closeReminderEditModal);
    if (cancelReminderEditButton) cancelReminderEditButton.addEventListener('click', closeReminderEditModal);
    if (saveReminderEditButton) saveReminderEditButton.addEventListener('click', saveReminderEdit);
    
    if (copyTomorrowListBtn) copyTomorrowListBtn.addEventListener('click', () => copyReminderList('expiringTomorrowList'));
    if (copyTodayListBtn) copyTodayListBtn.addEventListener('click', () => copyReminderList('expiringTodayList'));
    if (copyExpiredListBtn) copyExpiredListBtn.addEventListener('click', () => copyReminderList('expiredRecentlyList'));
    if (copyActiveListBtn) copyActiveListBtn.addEventListener('click', () => copyReminderList('activeNowList'));
    if (copySentListBtn) copySentListBtn.addEventListener('click', () => copyReminderList('sentMessagesList'));

    if (reminderSearchBtn) {
        reminderSearchBtn.addEventListener('click', filterRemindersBySearch);
    }
    if (reminderSearchClearBtn) {
        reminderSearchClearBtn.addEventListener('click', () => {
            if (reminderSearchInput) reminderSearchInput.value = '';
            document.querySelectorAll('.reminder-item').forEach(item => item.style.display = 'flex'); 
        });
    }
}

function filterRemindersBySearch() {
    const query = reminderSearchInput.value.trim();
    if (!query) {
        alert("অনুগ্রহ করে সার্চ বক্সে একটি WhatsApp নম্বর লিখুন।");
        return;
    }

    const allReminderItems = document.querySelectorAll('.reminder-item');
    let found = false;

    allReminderItems.forEach(item => {
        const whatsappNumEl = item.querySelector('.whatsapp-num');
        if (whatsappNumEl) {
            const whatsappNum = whatsappNumEl.textContent;
            if (whatsappNum.includes(query)) {
                item.style.display = 'flex'; 
                found = true;
                const details = item.closest('details');
                if(details) details.open = true;
            } else {
                item.style.display = 'none'; 
            }
        }
    });

    if (!found) {
        alert("কোনো রিমাইন্ডার খুঁজে পাওয়া যায়নি।");
    }
}

function copyReminderList(listId) {
    const listContainer = document.getElementById(listId);
    if (!listContainer) return;
    
    const numbers = [];
    listContainer.querySelectorAll('.reminder-item').forEach(item => {
        if (item.style.display !== 'none') {
            const numEl = item.querySelector('.whatsapp-num');
            if (numEl) {
                const num = numEl.textContent;
                if (num && num !== 'N/A') {
                    numbers.push(num);
                }
            }
        }
    });
    
    if (numbers.length === 0) {
        alert("এই লিস্টে কপি করার মতো কোনো নম্বর নেই।");
        return;
    }
    
    const numberString = numbers.join(',');
    navigator.clipboard.writeText(numberString)
        .then(() => {
            showSuccessMessage(`${numbers.length} টি নম্বর ক্লিপবোর্ডে কপি করা হয়েছে।`);
        })
        .catch(err => {
            showError({ message: "নম্বর কপি করা যায়নি।" });
            console.error('Copy failed', err);
        });
}


function loadReminderTemplate() {
    siteContentRef.child('reminders/template').on('value', (snapshot) => {
        if (snapshot.exists()) {
            const template = snapshot.val();
            reminderMessageTemplate = template;
            if (reminderTemplateInput) {
                reminderTemplateInput.value = template;
            }
        } else {
            if (reminderTemplateInput) {
                reminderMessageTemplate = "প্রিয় গ্রাহক [username], আপনার [package] প্যাকেজটির মেয়াদ [date] তারিখে শেষ হয়ে যাচ্ছে। রিনিউ করতে যোগাযোগ করুন।";
                reminderTemplateInput.value = reminderMessageTemplate;
            }
        }
    });
}


function calculateExpiryDate(log, customTimestamp = null) {
    const durationFullString = log.duration || "";
    const englishDurationString = toEnglishNumber(durationFullString);
    const match = englishDurationString.match(/^(\d+)/); 
    const durationValue = match ? parseInt(match[0]) : NaN; 
    
    if (isNaN(durationValue)) {
        return null;
    }

    const startDate = new Date(customTimestamp || log.timestamp); 
    
    const options = { 
        day: 'numeric', 
        month: 'short', 
        year: 'numeric', 
        hour: '2-digit', 
        minute: '2-digit', 
        hour12: true,
        timeZone: 'Asia/Dhaka' 
    };
    
    const lowerCaseDuration = durationFullString.toLowerCase();

    try {
        if (lowerCaseDuration.includes("ঘন্টা") || lowerCaseDuration.includes("hour")) {
            startDate.setHours(startDate.getHours() + durationValue);
        } else if (lowerCaseDuration.includes("দিন") || lowerCaseDuration.includes("day")) {
            startDate.setDate(startDate.getDate() + durationValue);
        } else if (lowerCaseDuration.includes("মাস") || lowerCaseDuration.includes("month")) {
            startDate.setMonth(startDate.getMonth() + durationValue);
        } else if (lowerCaseDuration.includes("বছর") || lowerCaseDuration.includes("year")) {
            startDate.setFullYear(startDate.getFullYear() + durationValue);
        } else {
            return null;
        }
        return { date: startDate, display: startDate.toLocaleString('bn-BD', options), timestamp: startDate.getTime() };
    } catch (e) {
        console.error("Expiry calculation error:", e, log);
        return null;
    }
}


function calculateAndDisplayReminders(logs) {
    console.log("Calculating reminders..."); // ডিবাগিং
    customRemindersRef.once('value').then(snapshot => {
        const customRemindersData = snapshot.val() || {};

        const bdtNow = getBdtTimezoneDate(Date.now() + serverOffset);
        const nowTime = bdtNow.getTime(); 
        const today = new Date(bdtNow.getFullYear(), bdtNow.getMonth(), bdtNow.getDate()).getTime();
        const tomorrow = today + (24 * 60 * 60 * 1000);
        const sevenDaysAgo = today - (7 * 24 * 60 * 60 * 1000);

        let expiringToday = [];
        let expiringTomorrow = [];
        let expiredRecently = [];
        let activeNow = []; 
        let sentMessages = []; 

        // রিমাইন্ডার শুধু সাধারণ সেলের জন্য প্রযোজ্য
        const regularLogs = logs.filter(log => log.type === 'regular');

        regularLogs.forEach(logItem => {
            const log = logItem.data;
            const logKey = logItem.key;
            
            const customData = customRemindersData[logKey];
            const whatsapp = customData ? customData.whatsapp : log.customerWhatsapp;
            const baseTimestamp = customData ? customData.timestamp : log.timestamp;
            
            if (!whatsapp || whatsapp === 'N/A') {
                return; 
            }
            
            const expiry = calculateExpiryDate(log, baseTimestamp);
            if (!expiry) {
                return; 
            }
            
            const bdtExpiryDate = getBdtTimezoneDate(expiry.timestamp);
            const expiryDateOnly = new Date(bdtExpiryDate.getFullYear(), bdtExpiryDate.getMonth(), bdtExpiryDate.getDate()).getTime();
            const expiryFullTime = expiry.date.getTime(); 

            const reminderData = {
                whatsapp: whatsapp,
                username: log.username || '', 
                package: log.packageName,
                expiryDateDisplay: expiry.display,
                expiryTimestamp: expiry.timestamp, 
                logKey: logKey 
            };
            
            const uniqueId = `${reminderData.whatsapp}_${reminderData.package}_${reminderData.expiryDateDisplay}`;
            if (sentReminders.has(uniqueId)) {
                sentMessages.push(reminderData);
                return;
            }
            
            if (expiryDateOnly === today) {
                expiringToday.push(reminderData);
            } 
            else if (expiryDateOnly === tomorrow) {
                expiringTomorrow.push(reminderData);
            } 
            else if (expiryDateOnly < today && expiryDateOnly >= sevenDaysAgo) {
                expiredRecently.push(reminderData);
            } 
            else if (expiryFullTime > nowTime) { 
                activeNow.push(reminderData);
            }
        });

        displayReminderList(sentMessagesList, sentMessages, 'countSent', true); 
        displayReminderList(expiringTomorrowList, expiringTomorrow, 'countTomorrow');
        displayReminderList(expiringTodayList, expiringToday, 'countToday');
        displayReminderList(expiredRecentlyList, expiredRecently, 'countExpired');
        displayReminderList(activeNowList, activeNow, 'countActive');
    });
}

function displayReminderList(container, list, countElementId, isSentList = false) {
    
    const countElement = document.getElementById(countElementId);
    if (countElement) {
        countElement.textContent = `(${list.length})`;
    }
    
    if (!container) return;
    container.innerHTML = '';
    
    if (list.length === 0) {
        container.innerHTML = '<p class="no-reminders">এই তালিকায় কোনো গ্রাহক নেই।</p>';
        return;
    }

    list.forEach(item => {
        const itemEl = document.createElement('div');
        itemEl.classList.add('reminder-item');
        
        let actionButtonHtml = '';
        let statusHtml = '';
        
        if (isSentList) {
            itemEl.classList.add('sent-item'); 
            statusHtml = '<span class="sent-status sent">মেসেজ সেন্ড করা হয়েছে</span>';
            actionButtonHtml = `
                <button class="send-reminder-btn sent-btn" disabled>
                    <i class="fas fa-check"></i> সেন্ট
                </button>
            `;
        } else {
            statusHtml = '<span class="sent-status"></span>';
            actionButtonHtml = `
                <button class="send-reminder-btn" data-whatsapp="${item.whatsapp}" data-package="${item.package}" data-expiry="${item.expiryDateDisplay}" data-username="${item.username || ''}">
                    <i class="fab fa-whatsapp"></i> পাঠান
                </button>
            `;
        }
        
        itemEl.innerHTML = `
            <div class="reminder-info">
                <span class="whatsapp-num">${item.whatsapp}</span>
                <span class="username-display" style="font-size: 0.9em; color: var(--info-color); font-weight: bold;">User: ${item.username || 'N/A'}</span>
                <span class="package-name">${item.package}</span>
                <span class="expiry-date">মেয়াদ শেষ: ${item.expiryDateDisplay}</span>
                ${statusHtml}
            </div>
            <div class="reminder-actions">
                ${actionButtonHtml}
                <button class="reminder-edit-btn" data-logkey="${item.logKey}" data-whatsapp="${item.whatsapp}" data-timestamp="${item.expiryTimestamp}">
                    <i class="fas fa-edit"></i> এডিট
                </button>
            </div>
        `;
        container.appendChild(itemEl);
    });
}

function openReminderEditModal(logKey, currentWhatsapp, currentTimestamp) {
    if (!reminderEditModal) {
        console.error("reminderEditModal খুঁজে পাওয়া যায়নি।");
        return;
    }
    
    const logItem = allSalesLogs.find(item => item.key === logKey);
    if (!logItem) {
        alert("মূল অর্ডার খুঁজে পাওয়া যায়নি।");
        return;
    }
    
    if (logItem.type === 'reseller') {
        alert("রিসেলার সেলের জন্য রিমাইন্ডার এডিট প্রযোজ্য নয়।");
        return;
    }
    
    reminderLogKeyInput.value = logKey;
    reminderCustomerWhatsappInput.value = currentWhatsapp;
    
    const durationFullString = logItem.data.duration || "";
    const englishDurationString = toEnglishNumber(durationFullString);
    const match = englishDurationString.match(/^(\d+)/);
    const durationValue = match ? parseInt(match[0]) : NaN;
    
    let originalStartDate = new Date(currentTimestamp); 

    if (!isNaN(durationValue)) {
        const lowerCaseDuration = durationFullString.toLowerCase();
        try {
            if (lowerCaseDuration.includes("ঘন্টা") || lowerCaseDuration.includes("hour")) {
                originalStartDate.setHours(originalStartDate.getHours() - durationValue);
            } else if (lowerCaseDuration.includes("দিন") || lowerCaseDuration.includes("day")) {
                originalStartDate.setDate(originalStartDate.getDate() - durationValue);
            } else if (lowerCaseDuration.includes("মাস") || lowerCaseDuration.includes("month")) {
                originalStartDate.setMonth(originalStartDate.getMonth() - durationValue);
            } else if (lowerCaseDuration.includes("বছর") || lowerCaseDuration.includes("year")) {
                originalStartDate.setFullYear(originalStartDate.getFullYear() - durationValue);
            }
        } catch(e) {
            console.error("Error calculating original start date:", e);
        }
    }
    
    reminderTimestampInput.value = formatTimestampToInput(originalStartDate.getTime());
    
    reminderEditModal.classList.remove('hidden');
    reminderEditModal.style.display = 'flex';
}

function closeReminderEditModal() {
    if (!reminderEditModal) return;
    reminderEditModal.classList.add('hidden');
    reminderEditModal.style.display = 'none';
}

function saveReminderEdit() {
    const logKey = reminderLogKeyInput.value;
    const newWhatsapp = reminderCustomerWhatsappInput.value;
    const newTimestamp = formatInputToTimestamp(reminderTimestampInput.value);

    if (!logKey) {
        alert("ত্রুটি: অর্ডার আইডি নেই।");
        return;
    }
    if (isNaN(newTimestamp)) {
        alert("তারিখ ও সময় সঠিক নয়।");
        return;
    }

    const dataToSave = {
        whatsapp: newWhatsapp,
        timestamp: newTimestamp
    };

    customRemindersRef.child(logKey).set(dataToSave)
        .then(() => {
            showSuccessMessage("রিমাইন্ডার সফলভাবে আপডেট করা হয়েছে!");
            closeReminderEditModal();
            calculateAndDisplayReminders(allSalesLogs); 
        })
        .catch(showError);
}
