// --- Firebase কনফিগারেশন ---
const firebaseConfig = {
    apiKey: "AIzaSyCql5HDGJVx3GXyLnLMHvAIAiRE7sDiYIY",
    authDomain: "ip-tv-peyment.firebaseapp.com",
    databaseURL: "https://ip-tv-peyment-default-rtdb.asia-southeast1.firebasedatabase.app/",
    projectId: "ip-tv-peyment",
    storageBucket: "ip-tv-peyment.appspot.com",
    messagingSenderId: "4072999206",
    appId: "1:4072999206:web:d24c972655f02f634d8567",
    measurementId: "G-HW8BBBF6Q5"
};

// --- Firebase চালু করা ---
firebase.initializeApp(firebaseConfig);
var auth = firebase.auth(); 
var db = firebase.database(); 

// --- গ্লোবাল ভেরিয়েবল ---
var siteContentRef = db.ref('site_content'); 
var packagesRef = db.ref('packages'); 
var resellerCustomersRef = db.ref('reseller_customers');
var resellerSalesLogRef = db.ref('reseller_sales_log');
var salesLogRef = db.ref('sales_log'); 
var noticeSliderRef = db.ref('site_content/notice_slider'); 
var reviewsRef = db.ref('site_content/reviews'); 
var appsRef = db.ref('site_content/dynamic_apps'); 
var faqsRef = db.ref('site_content/faqs'); 
var paymentSettingsRef = db.ref('site_content/payment_settings'); 
var videosRef = db.ref('site_content/videos'); 
var supportLinksRef = db.ref('site_content/support_links');
var visitCountsRef = db.ref('visit_counts');
var customRemindersRef = db.ref('custom_reminders');
var regularCustomersRef = db.ref('regular_customers'); 

var allSalesLogs = []; 
var serverOffset = 0; 
var allResellerCustomers = []; 
var allPackagesList = {}; 
var allRegularCustomers = []; 

// --- HTML এলিমেন্ট সিলেক্ট করা ---
const loginContainer = document.querySelector('.login-container');
const dashboard = document.getElementById('dashboard');
const loginButton = document.getElementById('loginButton');
const logoutButton = document.getElementById('logoutButton');
const emailInput = document.getElementById('email');
const passwordInput = document.getElementById('password');
const errorMessage = document.getElementById('error-message');
const successMessage = document.getElementById('success-message');

// হেডার এলিমেন্ট
const adminLogoPreview = document.getElementById('adminLogoPreview');

// সাধারণ সেটিং ও পপ-আপ এলিমেন্ট
const newsTickerInput = document.getElementById('news_ticker_input');
const trialEnabledCheckbox = document.getElementById('trial_enabled_checkbox');
const adminLogoUrlInput = document.getElementById('admin_logo_url_input');
const saveGeneralSettingsButton = document.getElementById('saveGeneralSettingsButton');

// ❇️ নতুন: পপ-আপ এলিমেন্ট
const popupEnableCheckbox = document.getElementById('popup_enable_checkbox');
const popupTitleInput = document.getElementById('popup_title_input');
const popupBodyInput = document.getElementById('popup_body_input');
const popupBtnTextInput = document.getElementById('popup_btn_text_input');
const popupBtnLinkInput = document.getElementById('popup_btn_link_input');

// স্লাইডার
const slideKeyInput = document.getElementById('slide_key_input');
const slideTypeSelect = document.getElementById('slide_type_select');
const slideTitleInput = document.getElementById('slide_title_input');
const slideContentInput = document.getElementById('slide_content_input');
const slideImageUrlInput = document.getElementById('slide_image_url_input');
const slideOrderInput = document.getElementById('slide_order_input');
const saveSlideButton = document.getElementById('saveSlideButton');
const clearSlideFormButton = document.getElementById('clearSlideFormButton');
const slideListContainer = document.getElementById('slide-list-container');
const textFields = document.getElementById('text-fields');
const imageFields = document.getElementById('image-fields');

// প্যাকেজ
const packageKeyInput = document.getElementById('package_key_input');
const packageNameInput = document.getElementById('package_name_input');
const packageOrderInput = document.getElementById('package_order_input'); 
const packagePriceMonthInput = document.getElementById('package_price_month_input');
const packageChannelUrlInput = document.getElementById('package_channel_url_input');
const packageBalanceInput = document.getElementById('package_balance_input'); 
const packagePurchasePriceInput = document.getElementById('package_purchase_price_input'); 
const packageFeaturesInput = document.getElementById('package_features_input');
const packageHasAdultInput = document.getElementById('package_has_adult_input');
const packageIsPublishedInput = document.getElementById('package_is_published_input');
const savePackageButton = document.getElementById('savePackageButton');
const clearFormButton = document.getElementById('clearFormButton');
const packageListContainer = document.getElementById('package-list-container');
const addPriceButton = document.getElementById('addPriceButton');
const pricingLabelInput = document.getElementById('pricing_label_input');
const pricingAmountInput = document.getElementById('pricing_amount_input');
const pricingDiscountInput = document.getElementById('pricing_discount_input');
const pricingListContainer = document.getElementById('pricing-list-container');
const pricingIsPublishedInput = document.getElementById('pricing_is_published_input');

// স্টক
const stockPackageSelect = document.getElementById('stock-package-select');
const stockCurrentBalanceDisplay = document.getElementById('stock-current-balance-display');
const stockCurrentBalanceEl = document.getElementById('stock-current-balance');
const stockAddAmountInput = document.getElementById('stock-add-amount');
const addStockButton = document.getElementById('addStockButton');
const stockSetAmountInput = document.getElementById('stock-set-amount'); 
const setStockButton = document.getElementById('setStockButton'); 
let packageListForStock = {}; 

// অন্যান্য সেটিং
const reviewKeyInput = document.getElementById('review_key_input');
const reviewUrlInput = document.getElementById('review_url_input');
const reviewAltInput = document.getElementById('review_alt_input');
const saveReviewButton = document.getElementById('saveReviewButton');
const clearReviewFormButton = document.getElementById('clearReviewFormButton');
const reviewListContainer = document.getElementById('review-list-container');

const appKeyInput = document.getElementById('app_key_input');
const appNameInput = document.getElementById('app_name_input');
const appCategoryInput = document.getElementById('app_category_input'); 
const appLinkInput = document.getElementById('app_link_input');
const appMobileGuideInput = document.getElementById('app_mobile_guide_input');
const appTvGuideInput = document.getElementById('app_tv_guide_input');
const saveAppButton = document.getElementById('saveAppButton');
const clearAppFormButton = document.getElementById('clearAppFormButton');
const appListContainer = document.getElementById('app-list-container');

const faqKeyInput = document.getElementById('faq_key_input');
const faqQuestionInput = document.getElementById('faq_question_input');
const faqAnswerInput = document.getElementById('faq_answer_input');
const faqOrderInput = document.getElementById('faq_order_input'); 
const saveFaqButton = document.getElementById('saveFaqButton');
const clearFaqFormButton = document.getElementById('clearFaqFormButton');
const faqListContainer = document.getElementById('faq-list-container');

const paymentBkashInput = document.getElementById('payment_bkash');
const paymentNagadInput = document.getElementById('payment_nagad');
const paymentRocketInput = document.getElementById('payment_rocket');
const paymentUpayInput = document.getElementById('payment_upay');
const paymentVideoGuideInput = document.getElementById('payment_video_guide');
const paymentWhatsappInput = document.getElementById('payment_whatsapp');
const paymentDeviceListInput = document.getElementById('payment_device_list');
const paymentEnableUsernameInput = document.getElementById('payment_enable_username');
const savePaymentSettingsButton = document.getElementById('savePaymentSettingsButton');

const videoKeyInput = document.getElementById('video_key_input');
const videoTitleInput = document.getElementById('video_title_input');
const videoUrlInput = document.getElementById('video_url_input');
const videoThumbnailInput = document.getElementById('video_thumbnail_input');
const videoDescriptionInput = document.getElementById('video_description_input');
const videoOrderInput = document.getElementById('video_order_input');
const saveVideoButton = document.getElementById('saveVideoButton');
const clearVideoFormButton = document.getElementById('clearVideoFormButton');
const videoListContainer = document.getElementById('video-list-container');

const saveMainSupportButton = document.getElementById('saveMainSupportButton');
const supportMainWhatsapp = document.getElementById('support_main_whatsapp');
const supportMainMessenger = document.getElementById('support_main_messenger');
const supportSections = document.querySelectorAll('.sub-editor-section[data-list-name]'); 

// মেন্যু ও পেজ
const mainMenu = document.getElementById('main-menu');
const editorPages = document.querySelectorAll('.editor-page');
const menuButtons = document.querySelectorAll('.menu-button');
const backButtons = document.querySelectorAll('.back-btn');

// রিসেলার এলিমেন্ট
const resellerCustomerKeyInput = document.getElementById('reseller_customer_key_input');
const resellerCustomerNameInput = document.getElementById('reseller_customer_name_input');
const resellerCustomerWhatsappInput = document.getElementById('reseller_customer_whatsapp_input');
const resellerCustomerDetailsInput = document.getElementById('reseller_customer_details_input');
const saveResellerCustomerButton = document.getElementById('saveResellerCustomerButton');
const clearResellerCustomerFormButton = document.getElementById('clearResellerCustomerFormButton');
const resellerCustomerSearchInput = document.getElementById('resellerCustomerSearchInput');
const resellerCustomerListContainer = document.getElementById('reseller-customer-list-container');
const resellerSaleCustomerSelect = document.getElementById('reseller_sale_customer_input');
const resellerPackageSelect = document.getElementById('reseller_sale_package_input');
const resellerSaleBalanceInput = document.getElementById('reseller_sale_balance_input');
const resellerSalePriceInput = document.getElementById('reseller_sale_price_input');
const saveResellerSaleButton = document.getElementById('saveResellerSaleButton');
const resellerProfitPreview = document.getElementById('reseller_profit_preview');
const resellerPurchaseCostPreview = document.getElementById('reseller_purchase_cost_preview');
const resellerProfitAmountPreview = document.getElementById('reseller_profit_amount_preview');

// অটো কাস্টমার এলিমেন্ট
const autoCustomerSearchInput = document.getElementById('autoCustomerSearchInput');
const autoSaleCustomerSelect = document.getElementById('auto_sale_customer_input');
const autoSalePackageSelect = document.getElementById('auto_sale_package_input');
const autoSaleBalanceInput = document.getElementById('auto_sale_balance_input');
const autoSalePriceInput = document.getElementById('auto_sale_price_input');
const saveAutoSaleButton = document.getElementById('saveAutoSaleButton');
const autoProfitPreview = document.getElementById('auto_profit_preview');
const autoPurchaseCostPreview = document.getElementById('auto_purchase_cost_preview');
const autoProfitAmountPreview = document.getElementById('auto_profit_amount_preview');
const packageCustomerGroupsContainer = document.getElementById('package-customer-groups-container');

let currentPricingList = {}; 


if(loginButton) {
    loginButton.addEventListener('click', () => {
        auth.signInWithEmailAndPassword(emailInput.value, passwordInput.value)
            .catch((error) => { errorMessage.textContent = "ভুল ইমেইল অথবা পাসওয়ার্ড।"; });
    });
}

if(logoutButton) {
    logoutButton.addEventListener('click', () => {
        auth.signOut();
    });
}

// হেল্পার ফাংশন
function getBdtDateString(timestamp) {
    const bdtOffsetInMinutes = 6 * 60;
    const date = new Date(timestamp);
    const utcTime = date.getTime() + (date.getTimezoneOffset() * 60000);
    const bdtDate = new Date(utcTime + (bdtOffsetInMinutes * 60000));
    const year = bdtDate.getFullYear();
    const month = String(bdtDate.getMonth() + 1).padStart(2, '0');
    const day = String(bdtDate.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}`;
}

// Auth স্টেট চেঞ্জ লিসেনার
auth.onAuthStateChanged((user) => {
    if (user) {
        if(typeof loadSentReminders === 'function') {
            sentReminders = loadSentReminders(); 
        }

        loginContainer.classList.add('hidden');
        dashboard.classList.remove('hidden');
        showPage('main-menu'); 
        
        db.ref("/.info/serverTimeOffset").once("value", (offsetSnap) => {
            serverOffset = offsetSnap.val() || 0;
            const now = Date.now() + serverOffset; 
            const today_bdt = getBdtDateString(now); 

            visitCountsRef.child('lastResetDate').once("value", (snap) => {
                const lastResetDate = snap.val();
                
                if (lastResetDate !== today_bdt) {
                    visitCountsRef.update({
                        todaySales: 0,
                        todayOrders: 0,
                        lastResetDate: today_bdt
                    }).then(() => {
                        console.log("Daily stats reset to BDT: " + today_bdt);
                        loadAllAdminData(); 
                    });
                } else {
                    loadAllAdminData();
                }
            });
        });
        
        // admin_reports.js এর ফাংশন কল
        if(typeof initializeSalesLogListeners === 'function') {
            initializeSalesLogListeners(); 
        }
        if(typeof initializeReminderListeners === 'function') {
            initializeReminderListeners(); 
        }
        
        initializeStockManagerListeners(); 
        initializeResellerSalesListeners(); 
        initializeAutoCustomerListeners(); 
        
    } else {
        // লগআউট
        loginContainer.classList.remove('hidden');
        dashboard.classList.add('hidden');
        showPage(null); 
        
        // সব লিসেনার অফ করা
        siteContentRef.child('general').off();
        siteContentRef.child('popup').off(); // পপ-আপ লিসেনার অফ
        if(typeof siteContentRef.child === 'function') { 
            siteContentRef.child('reminders/template').off(); 
        }
        visitCountsRef.off(); 
        if(typeof salesLogRef !== 'undefined') salesLogRef.off(); 
        if(typeof resellerSalesLogRef !== 'undefined') resellerSalesLogRef.off();
        packagesRef.off(); 
        appsRef.off();
        faqsRef.off(); 
        paymentSettingsRef.off(); 
        videosRef.off(); 
        reviewsRef.off();
        supportLinksRef.off();
        noticeSliderRef.off(); 
        if(typeof resellerCustomersRef !== 'undefined') resellerCustomersRef.off();
        if(typeof regularCustomersRef !== 'undefined') regularCustomersRef.off(); 
    }
});

function loadAllAdminData() {

    // সাধারণ সেটিং ও লোগো লোড
    siteContentRef.child('general').on('value', (snapshot) => {
        const data = snapshot.val() || {};
        if(newsTickerInput) newsTickerInput.value = data.news_ticker || '';
        if(trialEnabledCheckbox) trialEnabledCheckbox.checked = data.isTrialEnabled || false;
        
        if(adminLogoUrlInput) adminLogoUrlInput.value = data.admin_logo_url || '';
        if(adminLogoPreview) {
            const logoUrl = data.admin_logo_url;
            if (logoUrl) {
                adminLogoPreview.src = logoUrl;
                adminLogoPreview.onerror = () => { 
                    adminLogoPreview.src = 'https://placehold.co/50x50/1A1A2E/E0E0E0?text=Logo'; 
                };
            } else {
                adminLogoPreview.src = 'https://placehold.co/50x50/1A1A2E/E0E0E0?text=Logo';
            }
        }
    });

    // ❇️ নতুন: পপ-আপ ডাটা লোড
    siteContentRef.child('popup').on('value', (snapshot) => {
        const data = snapshot.val() || {};
        if(popupEnableCheckbox) popupEnableCheckbox.checked = data.isEnabled || false;
        if(popupTitleInput) popupTitleInput.value = data.title || '';
        if(popupBodyInput) popupBodyInput.value = data.body || '';
        if(popupBtnTextInput) popupBtnTextInput.value = data.btnText || '';
        if(popupBtnLinkInput) popupBtnLinkInput.value = data.btnLink || '';
    });
    
    loadSlidesForAdmin();
    loadPackagesForAdmin(); 
    loadPackagesForStockManager(); 
    loadReviewsForAdmin(); 
    loadAppsForAdmin(); 
    loadFaqsForAdmin(); 
    loadPaymentSettings(); 
    loadVideosForAdmin();
    loadSupportLinksForAdmin();

    if(typeof loadReminderTemplate === 'function') {
        loadReminderTemplate(); 
    }
    if(typeof loadSalesLog === 'function') {
        loadSalesLog(); 
    }

    loadPackagesForReseller();
    loadResellerCustomers();
    loadRegularCustomers();
    loadPackagesForAutoCustomerSale();
}

// ❇️ সাধারণ সেটিং ও পপ-আপ সেভ
if(saveGeneralSettingsButton) {
    saveGeneralSettingsButton.addEventListener('click', () => {
        // সাধারণ সেটিং
        const settingsData = {
            news_ticker: newsTickerInput.value,
            isTrialEnabled: trialEnabledCheckbox.checked,
            admin_logo_url: adminLogoUrlInput.value
        };
        
        // পপ-আপ ডাটা
        const popupData = {
            isEnabled: popupEnableCheckbox.checked,
            title: popupTitleInput.value,
            body: popupBodyInput.value,
            btnText: popupBtnTextInput.value,
            btnLink: popupBtnLinkInput.value
        };
        
        // দুটি একসাথে আপডেট করা
        Promise.all([
            siteContentRef.child('general').update(settingsData),
            siteContentRef.child('popup').set(popupData)
        ]).then(() => {
            showSuccessMessage("সেটিং এবং পপ-আপ সফলভাবে সেভ হয়েছে!");
        }).catch(showError);
    });
}

// --- স্লাইডার ফাংশন ---
function toggleSlideFields() { if (slideTypeSelect.value === 'image') { textFields.style.display = 'none'; imageFields.style.display = 'block'; } else { textFields.style.display = 'block'; imageFields.style.display = 'none'; } }
window.toggleSlideFields = toggleSlideFields;
if(clearSlideFormButton) clearSlideFormButton.addEventListener('click', clearSlideForm);
function clearSlideForm() { slideKeyInput.value = ''; slideTypeSelect.value = 'text'; slideTitleInput.value = ''; slideContentInput.value = ''; slideImageUrlInput.value = ''; slideOrderInput.value = ''; toggleSlideFields(); }
if(saveSlideButton) { saveSlideButton.addEventListener('click', () => { const key = slideKeyInput.value; const order = parseInt(slideOrderInput.value) || 0; const slideData = { type: slideTypeSelect.value, title: slideTitleInput.value, content: slideContentInput.value, imageUrl: slideImageUrlInput.value, order: order }; if (key) { noticeSliderRef.child(key).update(slideData) .then(() => { showSuccessMessage("স্লাইড সফলভাবে আপডেট হয়েছে!"); clearSlideForm(); }) .catch(showError); } else { noticeSliderRef.push(slideData) .then(() => { showSuccessMessage("নতুন স্লাইড সফলভাবে যোগ হয়েছে!"); clearSlideForm(); }) .catch(showError); } }); }

function loadSlidesForAdmin() { 
    noticeSliderRef.on('value', (snapshot) => { 
        if(!slideListContainer) return; 
        slideListContainer.innerHTML = ''; 
        if (!snapshot.exists()) { 
            slideListContainer.innerHTML = '<p>কোনো স্লাইড পাওয়া যায়নি।</p>'; 
            return; 
        } 
        
        let slides = [];
        snapshot.forEach(childSnapshot => {
            slides.push({ key: childSnapshot.key, ...childSnapshot.val() });
        });
        slides.sort((a, b) => (a.order || 0) - (b.order || 0));

        slides.forEach(slideData => { 
            const slideKey = slideData.key; 
            let displayText = slideData.type === 'image' ? `[ছবি] ${slideData.imageUrl.substring(0, 30)}...` : `[টেক্সট] ${slideData.title}`; 
            const slideItem = document.createElement('div'); 
            slideItem.classList.add('review-item'); 
            slideItem.innerHTML = ` <span>(Order: ${slideData.order || 'N/A'}) ${displayText}</span> <div class="actions"> <button class="edit-btn" data-key="${slideKey}">✏️ এডিট</button> <button class="delete-btn" data-key="${slideKey}">❌ ডিলিট</button> </div> `; 
            slideListContainer.appendChild(slideItem); 
        }); 
        slideListContainer.querySelectorAll('.edit-btn').forEach(button => { button.addEventListener('click', (e) => selectSlideForEdit(e.target.dataset.key)); }); 
        slideListContainer.querySelectorAll('.delete-btn').forEach(button => { button.addEventListener('click', (e) => deleteSlide(e.target.dataset.key)); }); 
    }, (error) => { 
        console.error("স্লাইডার লোড করতে সমস্যা:", error);
        if(slideListContainer) slideListContainer.innerHTML = '<p style="color:red;">স্লাইডার লোড করা যায়নি।</p>';
    }); 
}
function selectSlideForEdit(key) { noticeSliderRef.child(key).once('value', (snapshot) => { const data = snapshot.val(); slideKeyInput.value = key; slideTypeSelect.value = data.type || 'text'; slideTitleInput.value = data.title || ''; slideContentInput.value = data.content || ''; slideImageUrlInput.value = data.imageUrl || ''; slideOrderInput.value = data.order || ''; toggleSlideFields(); document.getElementById('slide-editor-form').scrollIntoView({ behavior: 'smooth' }); }); }
function deleteSlide(key) { if (confirm("আপনি কি সত্যিই এই স্লাইডটি ডিলিট করতে চান?")) { noticeSliderRef.child(key).remove() .then(() => { showSuccessMessage("স্লাইড ডিলিট করা হয়েছে।"); clearSlideForm(); }) .catch(showError); } }

// --- প্যাকেজ ফাংশন ---
function loadPackagesForAdmin() { 
    packagesRef.on('value', (snapshot) => {
        if(!packageListContainer) return;
        packageListContainer.innerHTML = ''; 
        if (!snapshot.exists()) {
            packageListContainer.innerHTML = '<p>কোনো প্যাকেজ পাওয়া যায়নি।</p>';
            return;
        }

        let packages = [];
        snapshot.forEach(childSnapshot => {
            packages.push({ key: childSnapshot.key, ...childSnapshot.val() });
        });
        packages.sort((a, b) => (a.order || 0) - (b.order || 0));

        packages.forEach(packageData => {
            const packageKey = packageData.key;
            const packageItem = document.createElement('div');
            packageItem.classList.add('package-item'); 
            packageItem.setAttribute('data-key', packageKey); 
            
            const isPublished = (packageData.isPublished === undefined) ? true : packageData.isPublished;

            let balanceHtml = '';
            if (packageData.balance === null || packageData.balance === undefined) {
                balanceHtml = `<span class="balance-info unlimited">(ব্যালেন্স: আনলিমিটেড)</span>`;
            } else {
                const balance = parseInt(packageData.balance);
                if (balance <= 5) {
                    balanceHtml = `<span class="balance-info low-stock">(ব্যালেন্স: ${balance})</span>`;
                } else {
                    balanceHtml = `<span class="balance-info">(ব্যালেন্স: ${balance})</span>`;
                }
            }

            const toggleHtml = `
                <label class="toggle-switch" title="সাইটে দেখানো/লুকানো">
                    <input type="checkbox" class="live-publish-toggle" data-key="${packageKey}" ${isPublished ? 'checked' : ''}>
                    <span class="slider"></span>
                </label>
            `;

            packageItem.innerHTML = `
                ${toggleHtml} 
                <span>${packageData.name} (Order: ${packageData.order || 'N/A'})</span>
                ${balanceHtml}
                <div class="actions">
                    <button class="edit-btn" data-key="${packageKey}">✏️ এডিট</button>
                    <button class="delete-btn" data-key="${packageKey}">❌ ডিলিট</button>
                </div>
            `;
            packageListContainer.appendChild(packageItem);
        });

        packageListContainer.querySelectorAll('.live-publish-toggle').forEach(toggle => {
            toggle.addEventListener('change', (e) => {
                const packageKey = e.target.dataset.key;
                const isPublished = e.target.checked;
                
                packagesRef.child(packageKey).child('isPublished').set(isPublished)
                    .then(() => {
                        showSuccessMessage('প্যাকেজের স্ট্যাটাস আপডেট হয়েছে।');
                    })
                    .catch(showError);
            });
        });
        
        packageListContainer.querySelectorAll('.edit-btn').forEach(button => {
            button.addEventListener('click', (e) => selectPackageForEdit(e.target.dataset.key));
        });
        packageListContainer.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', (e) => deletePackage(e.target.dataset.key));
        });
    }, (error) => { 
        console.error("প্যাকেজ লোড করতে সমস্যা:", error);
        if(packageListContainer) packageListContainer.innerHTML = '<p style="color:red;">প্যাকেজ লোড করা যায়নি।</p>';
    });
}

if(addPriceButton) { 
    addPriceButton.addEventListener('click', () => { 
        const label = pricingLabelInput.value.trim(); 
        const amount = parseInt(pricingAmountInput.value);
        const discount = parseInt(pricingDiscountInput.value) || 0;
        const isPublished = pricingIsPublishedInput.checked;

        if (!label || isNaN(amount) || amount <= 0) { 
            alert("অনুগ্রহ করে সঠিক মেয়াদ (Label) এবং মূল্য (Price) দিন।"); 
            return; 
        }
        if (isNaN(discount) || discount < 0 || discount > 100) {
            alert("ছাড় (Discount) অবশ্যই ০ থেকে ১০০ এর মধ্যে একটি সংখ্যা হতে হবে।");
            return;
        }
        
        currentPricingList[label] = {
            price: amount,
            discount: discount,
            isPublished: isPublished 
        }; 

        renderPricingList(); 
        pricingLabelInput.value = ''; 
        pricingAmountInput.value = ''; 
        pricingDiscountInput.value = '';
        pricingIsPublishedInput.checked = true;
    }); 
}

function renderPricingList() { 
    if(!pricingListContainer) return; 
    pricingListContainer.innerHTML = ''; 
    if (Object.keys(currentPricingList).length === 0) { 
        pricingListContainer.innerHTML = '<p><small>এখনো কোনো মূল্য যোগ করা হয়নি।</small></p>'; 
        return; 
    } 
    
    for (const label in currentPricingList) { 
        const priceData = currentPricingList[label];
        
        let amount, discount, isPublished;
        
        if (typeof priceData === 'object' && priceData !== null) {
            amount = priceData.price;
            discount = priceData.discount || 0;
            isPublished = (priceData.isPublished === undefined) ? true : priceData.isPublished;
        } else {
            amount = priceData;
            discount = 0;
            isPublished = true; 
        }

        const itemEl = document.createElement('div'); 
        itemEl.classList.add('pricing-item'); 
        
        let displayText = `(৳${amount})`;
        if (discount > 0) {
            displayText += ` - ${discount}% ছাড়`;
        }

        const toggleHtml = `
            <label class="toggle-switch">
                <input type="checkbox" class="price-publish-toggle" data-label="${label}" ${isPublished ? 'checked' : ''}>
                <span class="slider"></span>
            </label>
        `;

        itemEl.innerHTML = ` 
            <span>${label} <span class="price-value">${displayText}</span></span> 
            <div class="actions"> 
                ${toggleHtml} <button class="edit-price-btn" data-label="${label}">✏️ এডিট</button> 
                <button class="delete-price-btn" data-label="${label}">❌</button> 
            </div> 
        `; 
        pricingListContainer.appendChild(itemEl); 
    } 
    
    pricingListContainer.querySelectorAll('.delete-price-btn').forEach(button => { 
        button.addEventListener('click', (e) => { 
            const labelToDelete = e.target.dataset.label; 
            delete currentPricingList[labelToDelete]; 
            renderPricingList(); 
        }); 
    }); 
    
    pricingListContainer.querySelectorAll('.edit-price-btn').forEach(button => { 
        button.addEventListener('click', (e) => { 
            const labelToEdit = e.target.dataset.label; 
            const priceData = currentPricingList[labelToEdit]; 
            
            let amount, discount, isPublished;
            if (typeof priceData === 'object' && priceData !== null) {
                amount = priceData.price;
                discount = priceData.discount || 0;
                isPublished = (priceData.isPublished === undefined) ? true : priceData.isPublished;
            } else {
                amount = priceData;
                discount = 0;
                isPublished = true;
            }
            
            pricingLabelInput.value = labelToEdit; 
            pricingAmountInput.value = amount;
            pricingDiscountInput.value = discount;
            pricingIsPublishedInput.checked = isPublished; 
            
            delete currentPricingList[labelToEdit]; 
            renderPricingList(); 
        }); 
    });

    pricingListContainer.querySelectorAll('.price-publish-toggle').forEach(toggle => {
        toggle.addEventListener('click', (e) => {
            const label = e.target.dataset.label;
            const isPublished = e.target.checked;
            
            if (currentPricingList[label]) {
                if (typeof currentPricingList[label] === 'object') {
                    currentPricingList[label].isPublished = isPublished;
                } else {
                    currentPricingList[label] = {
                        price: currentPricingList[label],
                        discount: 0,
                        isPublished: isPublished
                    };
                }
            }
            
            const currentPackageKey = packageKeyInput.value;
            if (currentPackageKey) {
                packagesRef.child(currentPackageKey).child('pricing').child(label).child('isPublished').set(isPublished)
                    .then(() => {
                        showSuccessMessage(`'${label}' এর স্ট্যাটাস আপডেট হয়েছে।`);
                    })
                    .catch(showError);
            } else {
                showError({ message: "দয়া করে প্রথমে 'সেভ প্যাকেজ' বাটনে ক্লিক করে প্যাকেজটি সেভ করুন।" });
                e.target.checked = !isPublished; 
                if (currentPricingList[label]) currentPricingList[label].isPublished = !isPublished;
            }
        });
    });
}


if(savePackageButton) {
    savePackageButton.addEventListener('click', () => {
        const key = packageKeyInput.value;
        const order = parseInt(packageOrderInput.value); 
        const featuresArray = packageFeaturesInput.value.split('\n').filter(f => f.trim() !== '');
        
        const purchasePrice = parseFloat(packagePurchasePriceInput.value) || 0; 
        
        let balanceValue = null; 
        if (packageBalanceInput.value !== '') {
            balanceValue = parseInt(packageBalanceInput.value);
            if (isNaN(balanceValue)) {
                balanceValue = 0; 
            }
        }
        
        const packageData = {
            name: packageNameInput.value,
            order: isNaN(order) ? 0 : order,
            price_month: packagePriceMonthInput.value,
            channel_list_url: packageChannelUrlInput.value,
            balance: balanceValue,
            purchasePrice: purchasePrice, 
            features: featuresArray,
            has_adult_option: packageHasAdultInput.checked,
            pricing: currentPricingList, 
            isPublished: packageIsPublishedInput.checked 
        };
        
        if (key) {
            packagesRef.child(key).update(packageData)
                .then(() => {
                    showSuccessMessage("প্যাকেজ সফলভাবে আপডেট হয়েছে!");
                    clearPackageForm();
                })
                .catch(showError);
        } else {
            if (!packageData.order || packageData.order === 0) {
                packagesRef.limitToLast(1).once('value', (snapshot) => {
                    let newOrder = 1; 
                    if (snapshot.exists()) {
                        snapshot.forEach(child => { newOrder = (child.val().order || 0) + 1; });
                    }
                    packageData.order = newOrder; 
                    pushNewPackage(packageData); 
                });
            } else {
                pushNewPackage(packageData);
            }
        }
    });
}

function pushNewPackage(packageData) {
    packagesRef.push(packageData)
        .then(() => {
            showSuccessMessage("নতুন প্যাকেজ সফলভাবে যোগ হয়েছে!");
            clearPackageForm();
        })
        .catch(showError);
}

function selectPackageForEdit(key) {
    packagesRef.child(key).once('value', (snapshot) => {
        const data = snapshot.val();
        packageKeyInput.value = key;
        packageNameInput.value = data.name;
        packageOrderInput.value = data.order || ''; 
        packagePriceMonthInput.value = data.price_month || '';
        packageChannelUrlInput.value = data.channel_list_url;
        
        packageBalanceInput.value = (data.balance === null || data.balance === undefined) ? '' : data.balance; 
        
        if(packagePurchasePriceInput) {
            packagePurchasePriceInput.value = data.purchasePrice || '';
        }
        
        packageFeaturesInput.value = (data.features || []).join('\n'); 
        packageHasAdultInput.checked = data.has_adult_option || false; 
        currentPricingList = data.pricing || {}; 
        renderPricingList(); 
        
        packageIsPublishedInput.checked = (data.isPublished === undefined) ? true : data.isPublished;
        
        document.getElementById('package-editor-form').scrollIntoView({ behavior: 'smooth' });
    });
}

function deletePackage(key) {
    if (confirm("আপনি কি সত্যিই এই প্যাকেজটি ডিলিট করতে চান?")) {
        packagesRef.child(key).remove()
            .then(() => {
                showSuccessMessage("প্যাকেজ ডিলিট করা হয়েছে।");
                clearPackageForm();
            })
            .catch(showError);
    }
}

if(clearFormButton) clearFormButton.addEventListener('click', clearPackageForm);
function clearPackageForm() {
    packageKeyInput.value = '';
    packageNameInput.value = '';
    packageOrderInput.value = ''; 
    packagePriceMonthInput.value = '';
    packageChannelUrlInput.value = '';
    packageBalanceInput.value = ''; 
    
    if(packagePurchasePriceInput) {
        packagePurchasePriceInput.value = '';
    }

    packageFeaturesInput.value = '';
    packageHasAdultInput.checked = false;
    currentPricingList = {};
    pricingLabelInput.value = '';
    pricingAmountInput.value = '';
    pricingDiscountInput.value = ''; 
    pricingIsPublishedInput.checked = true; 
    renderPricingList();
    
    packageIsPublishedInput.checked = true;
}

// --- স্টক ম্যানেজার ফাংশন ---
function loadPackagesForStockManager() {
    if (!stockPackageSelect) return;

    packagesRef.on('value', (snapshot) => {
        stockPackageSelect.innerHTML = '<option value="">-- প্যাকেজ সিলেক্ট করুন --</option>';
        packageListForStock = {}; 

        if (!snapshot.exists()) {
            stockPackageSelect.innerHTML = '<option value="">-- কোনো প্যাকেজ পাওয়া যায়নি --</option>';
            return;
        }
        
        snapshot.forEach(childSnapshot => {
            const packageKey = childSnapshot.key;
            const packageData = childSnapshot.val();
            
            const option = document.createElement('option');
            option.value = packageKey;
            option.text = packageData.name;
            stockPackageSelect.appendChild(option);
            
            packageListForStock[packageKey] = {
                name: packageData.name,
                balance: packageData.balance
            };
        });
        
        updateCurrentStockDisplay();
    }, (error) => { 
        console.error("স্টকের জন্য প্যাকেজ লোড করতে সমস্যা:", error);
        if(stockPackageSelect) stockPackageSelect.innerHTML = '<option value="">-- লোড করা যায়নি --</option>';
    });
}

function updateCurrentStockDisplay() {
    const selectedKey = stockPackageSelect.value;
    if (selectedKey && packageListForStock[selectedKey]) {
        const balance = packageListForStock[selectedKey].balance;
        
        if (balance === null || balance === undefined) {
            stockCurrentBalanceEl.textContent = "আনলিমিটেড";
            stockCurrentBalanceEl.className = 'unlimited';
        } else {
            const balanceNum = parseInt(balance);
            stockCurrentBalanceEl.textContent = balanceNum;
            stockCurrentBalanceEl.className = balanceNum <= 5 ? 'low-stock' : '';
        }
        stockCurrentBalanceDisplay.classList.remove('hidden');
    } else {
        stockCurrentBalanceDisplay.classList.add('hidden');
    }
}

function initializeStockManagerListeners() {
    if (stockPackageSelect) {
        stockPackageSelect.addEventListener('change', updateCurrentStockDisplay);
    }
    
    if (addStockButton) {
        addStockButton.addEventListener('click', () => {
            const selectedKey = stockPackageSelect.value;
            const amountToAdd = parseInt(stockAddAmountInput.value);

            if (!selectedKey) {
                alert("অনুগ্রহ করে একটি প্যাকেজ সিলেক্ট করুন।");
                return;
            }
            if (isNaN(amountToAdd) || amountToAdd <= 0) {
                alert("অনুগ্রহ করে সঠিক পরিমাণ লিখুন (যেমন: 50)।");
                return;
            }
            
            const packageStockRef = packagesRef.child(selectedKey).child('balance');
            
            packageStockRef.transaction((currentBalance) => {
                if (currentBalance === null || currentBalance === undefined) {
                    return amountToAdd;
                } else {
                    return (parseInt(currentBalance) || 0) + amountToAdd;
                }
            }, (error, committed, snapshot) => {
                if (error) {
                    showError(error);
                } else if (committed) {
                    showSuccessMessage(`${amountToAdd} টি স্টক সফলভাবে যোগ করা হয়েছে!`);
                    stockAddAmountInput.value = ''; 
                } else {
                    showError({ message: "স্টক আপডেট ব্যর্থ হয়েছে।" });
                }
            });
        });
    }
    
    if (setStockButton) {
        setStockButton.addEventListener('click', () => {
            const selectedKey = stockPackageSelect.value;
            const amountToSet = stockSetAmountInput.value; 

            if (!selectedKey) {
                alert("অনুগ্রহ করে একটি প্যাকেজ সিলেক্ট করুন।");
                return;
            }
            
            let newBalance = null; 
            if (amountToSet !== '') { 
                newBalance = parseInt(amountToSet);
                if (isNaN(newBalance) || newBalance < 0) {
                    alert("অনুগ্রহ করে সঠিক সংখ্যা লিখুন (যেমন: 100), অথবা আনলিমিটেড করতে খালি রাখুন।");
                    return;
                }
            }

            const packageStockRef = packagesRef.child(selectedKey).child('balance');
            
            packageStockRef.set(newBalance) 
                .then(() => {
                    showSuccessMessage(`ব্যালেন্স সফলভাবে "${newBalance === null ? 'আনলিমিটেড' : newBalance}" সেট করা হয়েছে!`);
                    stockSetAmountInput.value = ''; 
                })
                .catch(showError);
        });
    }
}

// --- অন্যান্য সেটিং ---

function loadReviewsForAdmin() { reviewsRef.on('value', (snapshot) => { if(!reviewListContainer) return; reviewListContainer.innerHTML = ''; if (!snapshot.exists()) { reviewListContainer.innerHTML = '<p>কোনো রিভিউ পাওয়া যায়নি।</p>'; return; } let reviews = []; snapshot.forEach(childSnapshot => { reviews.push(childSnapshot.val()); }); reviews = reviews.filter(r => r && r.url); reviews.forEach((review, index) => { const reviewItem = document.createElement('div'); reviewItem.classList.add('review-item'); reviewItem.innerHTML = ` <span>${review.alt || 'Review Image'}</span> <div class="actions"> <button class="edit-btn" data-index="${index}">✏️ এডিট</button> <button class="delete-btn" data-index="${index}">❌ ডিলিট</button> </div> `; reviewListContainer.appendChild(reviewItem); }); reviewListContainer.querySelectorAll('.edit-btn').forEach(btn => { btn.addEventListener('click', () => selectReviewForEdit(btn.dataset.index)); }); reviewListContainer.querySelectorAll('.delete-btn').forEach(btn => { btn.addEventListener('click', () => deleteReview(btn.dataset.index)); }); }); }
if(saveReviewButton) { saveReviewButton.addEventListener('click', () => { const key = reviewKeyInput.value; const reviewData = { url: reviewUrlInput.value, alt: reviewAltInput.value }; if (!reviewData.url) { alert("⚠️ অনুগ্রহ করে ছবির URL দিন।"); return; } reviewsRef.once('value', snapshot => { let reviews = snapshot.val() || []; if (!Array.isArray(reviews)) { reviews = Object.values(reviews).filter(r => r != null); } if (key !== "") { const index = parseInt(key); if (index >= 0 && index < reviews.length) { reviews[index] = reviewData; } } else { reviews.push(reviewData); } const finalReviews = reviews.filter(r => r && r.url); reviewsRef.set(finalReviews) .then(() => { showSuccessMessage("রিভিউ সেভ হয়েছে!"); clearReviewForm(); }) .catch(showError); }); }); }
function selectReviewForEdit(index) { reviewsRef.once('value', (snapshot) => { let reviews = snapshot.val() || []; if (!Array.isArray(reviews)) { reviews = Object.values(reviews).filter(r => r != null); } const data = reviews[parseInt(index)]; if (data) { reviewKeyInput.value = index.toString(); reviewUrlInput.value = data.url; reviewAltInput.value = data.alt; } }); }
function deleteReview(index) { if (!confirm("আপনি কি সত্যিই এই রিভিউটি ডিলিট করতে চান?")) return; reviewsRef.once('value', (snapshot) => { let reviews = snapshot.val() || []; if (!Array.isArray(reviews)) { reviews = Object.values(reviews).filter(r => r != null); } reviews.splice(index, 1); reviewsRef.set(reviews.filter(r => r && r.url)) .then(() => { showSuccessMessage("রিভিউ ডিলিট হয়েছে।"); clearReviewForm(); }) .catch(showError); }); }
if(clearReviewFormButton) clearReviewFormButton.addEventListener('click', clearReviewForm);
function clearReviewForm() { reviewKeyInput.value = ''; reviewUrlInput.value = ''; reviewAltInput.value = ''; }

function loadAppsForAdmin() { if(!appListContainer) return; appsRef.on('value', (snapshot) => { appListContainer.innerHTML = ''; if (!snapshot.exists()) { appListContainer.innerHTML = '<p>কোনো অ্যাপ যোগ করা হয়নি।</p>'; return; } snapshot.forEach(childSnapshot => { const appKey = childSnapshot.key; const appData = childSnapshot.val(); const appItem = document.createElement('div'); appItem.classList.add('app-item'); appItem.innerHTML = ` <span>${appData.name} <small>(${appData.app_category || 'N/A'})</small></span> <div class="actions"> <button class="edit-btn" data-key="${appKey}">✏️ এডিট</button> <button class="delete-btn" data-key="${appKey}">❌ ডিলিট</button> </div> `; appListContainer.appendChild(appItem); }); appListContainer.querySelectorAll('.edit-btn').forEach(button => { button.addEventListener('click', (e) => selectAppForEdit(e.target.dataset.key)); }); appListContainer.querySelectorAll('.delete-btn').forEach(button => { button.addEventListener('click', (e) => deleteApp(e.target.dataset.key)); }); }); }
if(saveAppButton) { saveAppButton.addEventListener('click', () => { const key = appKeyInput.value; const appData = { name: appNameInput.value, app_category: appCategoryInput.value, app_link: appLinkInput.value, mobile_guide: appMobileGuideInput.value, tv_guide: appTvGuideInput.value }; if (!appData.name || !appData.app_link) { alert("অনুগ্রহ করে অ্যাপের নাম এবং অ্যাপের লিঙ্ক দিন।"); return; } if (key) { appsRef.child(key).update(appData) .then(() => { showSuccessMessage("অ্যাপ সফলভাবে আপডেট হয়েছে!"); clearAppForm(); }) .catch(showError); } else { appsRef.push(appData) .then(() => { showSuccessMessage("নতুন অ্যাপ সফলভাবে যোগ হয়েছে!"); clearAppForm(); }) .catch(showError); } }); }
function selectAppForEdit(key) { appsRef.child(key).once('value', (snapshot) => { const data = snapshot.val(); appKeyInput.value = key; appNameInput.value = data.name; appCategoryInput.value = data.app_category || 'Android'; appLinkInput.value = data.app_link; appMobileGuideInput.value = data.mobile_guide || ''; appTvGuideInput.value = data.tv_guide || ''; document.getElementById('app-editor-form').scrollIntoView({ behavior: 'smooth' }); }); }
function deleteApp(key) { if (confirm("আপনি কি সত্যিই এই অ্যাপটি ডিলিট করতে চান?")) { appsRef.child(key).remove() .then(() => { showSuccessMessage("অ্যাপ ডিলিট করা হয়েছে।"); clearAppForm(); }) .catch(showError); } }
if(clearAppFormButton) clearAppFormButton.addEventListener('click', clearAppForm);
function clearAppForm() { appKeyInput.value = ''; appNameInput.value = ''; appCategoryInput.value = 'Android'; appLinkInput.value = ''; appMobileGuideInput.value = ''; appTvGuideInput.value = ''; }

function loadFaqsForAdmin() { 
    if(!faqListContainer) return; 
    faqsRef.on('value', (snapshot) => { 
        faqListContainer.innerHTML = ''; 
        if (!snapshot.exists()) { 
            faqListContainer.innerHTML = '<p>কোনো প্রশ্নাবলী যোগ করা হয়নি।</p>'; 
            return; 
        } 
        
        let faqs = [];
        snapshot.forEach(childSnapshot => {
            faqs.push({ key: childSnapshot.key, ...childSnapshot.val() });
        });
        faqs.sort((a, b) => (a.order || 0) - (b.order || 0));

        faqs.forEach(faqData => { 
            const faqKey = faqData.key; 
            const faqItem = document.createElement('div'); 
            faqItem.classList.add('faq-item'); 
            faqItem.innerHTML = ` <span> (Order: ${faqData.order || 'N/A'}) ${faqData.question} <p>${(faqData.answer || '').substring(0, 100)}...</p> </span> <div class="actions"> <button class="edit-btn" data-key="${faqKey}">✏️ এডিট</button> <button class="delete-btn" data-key="${faqKey}">❌ ডিলিট</button> </div> `; 
            faqListContainer.appendChild(faqItem); 
        }); 
        faqListContainer.querySelectorAll('.edit-btn').forEach(button => { button.addEventListener('click', (e) => selectFaqForEdit(e.target.dataset.key)); }); 
        faqListContainer.querySelectorAll('.delete-btn').forEach(button => { button.addEventListener('click', (e) => deleteFaq(e.target.dataset.key)); }); 
    }, (error) => { 
        console.error("FAQ লোড করতে সমস্যা:", error);
        if(faqListContainer) faqListContainer.innerHTML = '<p style="color:red;">FAQ লোড করা যায়নি।</p>';
    }); 
}
if(saveFaqButton) { saveFaqButton.addEventListener('click', () => { const key = faqKeyInput.value; const order = parseInt(faqOrderInput.value); const faqData = { question: faqQuestionInput.value, answer: faqAnswerInput.value, order: isNaN(order) ? 0 : order }; if (!faqData.question || !faqData.answer) { alert("অনুগ্রহ করে প্রশ্ন এবং উত্তর উভয়ই দিন।"); return; } if (key) { faqsRef.child(key).update(faqData) .then(() => { showSuccessMessage("প্রশ্ন সফলভাবে আপডেট হয়েছে!"); clearFaqForm(); }) .catch(showError); } else { faqsRef.push(faqData) .then(() => { showSuccessMessage("নতুন প্রশ্ন সফলভাবে যোগ হয়েছে!"); clearFaqForm(); }) .catch(showError); } }); }
function selectFaqForEdit(key) { faqsRef.child(key).once('value', (snapshot) => { const data = snapshot.val(); faqKeyInput.value = key; faqQuestionInput.value = data.question; faqAnswerInput.value = data.answer; faqOrderInput.value = data.order || ''; document.getElementById('faq-editor-form').scrollIntoView({ behavior: 'smooth' }); }); }
function deleteFaq(key) { if (confirm("আপনি কি সত্যিই এই প্রশ্নটি ডিলিট করতে চান?")) { faqsRef.child(key).remove() .then(() => { showSuccessMessage("প্রশ্ন ডিলিট করা হয়েছে।"); clearFaqForm(); }) .catch(showError); } }
if(clearFaqFormButton) clearFaqFormButton.addEventListener('click', clearFaqForm);
function clearFaqForm() { faqKeyInput.value = ''; faqQuestionInput.value = ''; faqAnswerInput.value = ''; faqOrderInput.value = ''; }

function loadPaymentSettings() { paymentSettingsRef.on('value', (snapshot) => { const data = snapshot.val(); if (data) { if(paymentBkashInput) paymentBkashInput.value = data.bkash || ''; if(paymentNagadInput) paymentNagadInput.value = data.nagad || ''; if(paymentRocketInput) paymentRocketInput.value = data.rocket || ''; if(paymentUpayInput) paymentUpayInput.value = data.upay || ''; if(paymentVideoGuideInput) paymentVideoGuideInput.value = data.video_guide || ''; if(paymentWhatsappInput) paymentWhatsappInput.value = data.whatsapp || ''; if(paymentDeviceListInput) paymentDeviceListInput.value = (data.device_list || []).join('\n'); if(paymentEnableUsernameInput) paymentEnableUsernameInput.checked = data.enable_username || false; } }); }
if(savePaymentSettingsButton) { savePaymentSettingsButton.addEventListener('click', () => { const deviceListArray = paymentDeviceListInput.value.split('\n').filter(d => d.trim() !== ''); const settingsData = { bkash: paymentBkashInput.value, nagad: paymentNagadInput.value, rocket: paymentRocketInput.value, upay: paymentUpayInput.value, video_guide: paymentVideoGuideInput.value, whatsapp: paymentWhatsappInput.value, device_list: deviceListArray, enable_username: paymentEnableUsernameInput.checked }; paymentSettingsRef.update(settingsData) .then(() => showSuccessMessage("পেমেন্ট সেটিং সফলভাবে সেভ হয়েছে!")) .catch(showError); }); }

function getYouTubeVideoID(url) { let videoId = ''; if (!url) return null; if (url.includes("watch?v=")) videoId = url.split('v=')[1].split('&')[0]; else if (url.includes("youtu.be/")) videoId = url.split('youtu.be/')[1].split('?')[0]; else if (url.includes("/embed/")) videoId = url.split('/embed/')[1].split('?')[0]; else if (url.includes("/shorts/")) videoId = url.split('/shorts/')[1].split('?')[0]; return videoId || null; }
function loadVideosForAdmin() { 
    if(!videoListContainer) return; 
    videosRef.on('value', (snapshot) => { 
        videoListContainer.innerHTML = ''; 
        if (!snapshot.exists()) { 
            videoListContainer.innerHTML = '<p>কোনো ভিডিও যোগ করা হয়নি।</p>'; 
            return; 
        } 
        
        let videos = [];
        snapshot.forEach(childSnapshot => {
            videos.push({ key: childSnapshot.key, ...childSnapshot.val() });
        });
        videos.sort((a, b) => (a.order || 0) - (b.order || 0));

        videos.forEach(videoData => { 
            const videoKey = videoData.key; 
            const videoItem = document.createElement('div'); 
            videoItem.classList.add('video-item'); 
            videoItem.innerHTML = ` <span> (Order: ${videoData.order || 'N/A'}) ${videoData.title} </span> <div class="actions"> <button class="edit-btn" data-key="${videoKey}">✏️ এডিট</button> <button class="delete-btn" data-key="${videoKey}">❌ ডিলিট</button> </div> `; 
            videoListContainer.appendChild(videoItem); 
        }); 
        videoListContainer.querySelectorAll('.edit-btn').forEach(button => { button.addEventListener('click', (e) => selectVideoForEdit(e.target.dataset.key)); }); 
        videoListContainer.querySelectorAll('.delete-btn').forEach(button => { button.addEventListener('click', (e) => deleteVideo(e.target.dataset.key)); }); 
    }, (error) => { 
        console.error("ভিডিও লোড করতে সমস্যা:", error);
        if(videoListContainer) videoListContainer.innerHTML = '<p style="color:red;">ভিডিও লোড করা যায়নি।</p>';
    }); 
}
if(saveVideoButton) { saveVideoButton.addEventListener('click', () => { const key = videoKeyInput.value; const originalUrl = videoUrlInput.value; const videoId = getYouTubeVideoID(originalUrl); if (!videoTitleInput.value || !originalUrl) { alert("অনুগ্রহ করে ভিডিওর টাইটেল এবং URL উভয়ই দিন।"); return; } if (!videoId) { alert("অবৈধ ইউটিউব লিঙ্ক। দয়া করে 'watch?v=', 'youtu.be/' বা 'shorts/' লিঙ্ক ব্যবহার করুন।"); return; } let thumbnailUrl = videoThumbnailInput.value; if (!thumbnailUrl) { thumbnailUrl = `https://i.ytimg.com/vi/${videoId}/hqdefault.jpg`; } const order = parseInt(videoOrderInput.value); const videoData = { title: videoTitleInput.value, url: `https://www.youtube.com/embed/${videoId}`, thumbnail: thumbnailUrl, description: videoDescriptionInput.value, order: isNaN(order) ? 0 : order }; if (key) { videosRef.child(key).update(videoData) .then(() => { showSuccessMessage("ভিডিও সফলভাবে আপডেট হয়েছে!"); clearVideoForm(); }) .catch(showError); } else { videosRef.push(videoData) .then(() => { showSuccessMessage("নতুন ভিডিও সফলভাবে যোগ হয়েছে!"); clearVideoForm(); }) .catch(showError); } }); }
function selectVideoForEdit(key) { videosRef.child(key).once('value', (snapshot) => { const data = snapshot.val(); videoKeyInput.value = key; videoTitleInput.value = data.title; videoUrlInput.value = data.url; videoThumbnailInput.value = data.thumbnail || ''; videoDescriptionInput.value = data.description || ''; videoOrderInput.value = data.order || ''; document.getElementById('video-editor-form').scrollIntoView({ behavior: 'smooth' }); }); }
function deleteVideo(key) { if (confirm("আপনি কি সত্যিই এই ভিডিওটি ডিলিট করতে চান?")) { videosRef.child(key).remove() .then(() => { showSuccessMessage("ভিডিও ডিলিট করা হয়েছে।"); clearVideoForm(); }) .catch(showError); } }
if(clearVideoFormButton) clearVideoFormButton.addEventListener('click', clearVideoForm);
function clearVideoForm() { videoKeyInput.value = ''; videoTitleInput.value = ''; videoUrlInput.value = ''; videoThumbnailInput.value = ''; videoDescriptionInput.value = ''; videoOrderInput.value = ''; }

function loadSupportLinksForAdmin() { supportLinksRef.on('value', (snapshot) => { const supportData = snapshot.val() || {}; if(supportMainWhatsapp) supportMainWhatsapp.value = supportData.main_whatsapp || ''; if(supportMainMessenger) supportMainMessenger.value = supportData.main_messenger || ''; supportSections.forEach(section => { const listName = section.dataset.listName; const container = section.querySelector('.support-link-list') || document.getElementById(`${listName}_list_container`); if(!container) return; container.innerHTML = ''; const list = supportData[listName] || []; const listArray = Array.isArray(list) ? list : Object.values(list); if (listArray.length === 0) { container.innerHTML = '<p>কোনো লিঙ্ক পাওয়া যায়নি।</p>'; return; } listArray.forEach((item, index) => { if (!item) return; const itemEl = document.createElement('div'); itemEl.classList.add('link-item'); itemEl.innerHTML = ` <span>${item.name}</span> <div class="actions"> <button class="edit-btn" data-index="${index}" data-list="${listName}">✏️ এডিট</button> <button class="delete-btn" data-index="${index}" data-list="${listName}">❌ ডিলিট</button> </div> `; container.appendChild(itemEl); }); container.querySelectorAll('.edit-btn').forEach(btn => { btn.addEventListener('click', () => selectSupportLinkForEdit(btn.dataset.list, btn.dataset.index)); }); container.querySelectorAll('.delete-btn').forEach(btn => { btn.addEventListener('click', () => deleteSupportLink(btn.dataset.list, btn.dataset.index)); }); }); }); }
if(saveMainSupportButton) { saveMainSupportButton.addEventListener('click', () => { supportLinksRef.update({ main_whatsapp: supportMainWhatsapp.value, main_messenger: supportMainMessenger.value }) .then(() => showSuccessMessage("প্রধান সাপোর্ট লিঙ্ক সেভ হয়েছে!")) .catch(showError); }); }
function selectSupportLinkForEdit(listName, index) { const listRef = supportLinksRef.child(listName); listRef.once('value', (snapshot) => { let list = snapshot.val() || []; if (!Array.isArray(list)) list = Object.values(list); const item = list[parseInt(index)]; if (item) { const section = document.querySelector(`.sub-editor-section[data-list-name="${listName}"]`); if (section) { const nameInput = section.querySelector('.new-link-name'); const urlInput = section.querySelector('.new-link-url'); const addButton = section.querySelector('.add-link-btn'); nameInput.value = item.name; urlInput.value = item.url; addButton.textContent = '💾 সেভ পরিবর্তন'; addButton.dataset.editingIndex = index; } } }); }
supportSections.forEach(section => { const listName = section.dataset.listName; const addButton = section.querySelector('.add-link-btn'); if (!addButton) return; const nameInput = section.querySelector('.new-link-name'); const urlInput = section.querySelector('.new-link-url'); const originalButtonText = addButton.textContent; addButton.addEventListener('click', () => { const newLink = { name: nameInput.value, url: urlInput.value }; if (!newLink.name || !newLink.url) { alert("অনুগ্রহ করে নাম এবং URL উভয়ই দিন।"); return; } const listRef = supportLinksRef.child(listName); const editingIndex = addButton.dataset.editingIndex; listRef.once('value', (snapshot) => { let list = snapshot.val() || []; if (!Array.isArray(list)) { list = Object.values(list).filter(item => item != null); } if (editingIndex !== undefined && parseInt(editingIndex) < list.length) { list[parseInt(editingIndex)] = newLink; } else { list.push(newLink); } listRef.set(list.filter(item => item != null)) .then(() => { showSuccessMessage(editingIndex !== undefined ? "লিঙ্ক সফলভাবে আপডেট হয়েছে!" : "নতুন লিঙ্ক সফলভাবে যোগ হয়েছে!"); nameInput.value = ''; urlInput.value = ''; delete addButton.dataset.editingIndex; addButton.textContent = originalButtonText; }) .catch(showError); }); }); });
function deleteSupportLink(listName, index) { if (!confirm("আপনি কি সত্যিই এই লিঙ্কটি ডিলিট করতে চান?")) return; const listRef = supportLinksRef.child(listName); listRef.once('value', (snapshot) => { let list = snapshot.val() || []; if (!Array.isArray(list)) { list = Object.values(list).filter(item => item != null); } list.splice(index, 1); listRef.set(list.filter(item => item != null)) .then(() => showSuccessMessage("লিঙ্ক ডিলিট হয়েছে।")) .catch(showError); }); }


// --- রিসেলার সেলস ফাংশন ---

function initializeResellerSalesListeners() {
    if (saveResellerCustomerButton) {
        saveResellerCustomerButton.addEventListener('click', saveResellerCustomer);
    }
    if (clearResellerCustomerFormButton) {
        clearResellerCustomerFormButton.addEventListener('click', clearResellerCustomerForm);
    }
    if (resellerCustomerSearchInput) {
        resellerCustomerSearchInput.addEventListener('input', filterResellerCustomers);
    }
    if (resellerCustomerListContainer) {
        resellerCustomerListContainer.addEventListener('click', (e) => {
            const item = e.target.closest('.customer-item'); 
            if (!item) return;

            if (e.target.classList.contains('report-btn')) {
                e.stopPropagation(); 
                showCustomerSalesReport(e.target.dataset.whatsapp);
            } 
            else if (e.target.classList.contains('edit-btn')) {
                selectResellerCustomerForEdit(item.dataset.key);
            } 
            else if (e.target.classList.contains('delete-btn')) {
                deleteResellerCustomer(item.dataset.key);
            } 
            else {
                selectResellerCustomer(item.dataset.key);
                document.querySelectorAll('#reseller-customer-list-container .customer-item').forEach(el => el.classList.remove('selected'));
                item.classList.add('selected');
            }
        });
    }
    
    if (resellerSaleCustomerSelect) {
        resellerSaleCustomerSelect.addEventListener('change', () => {
             document.querySelectorAll('#reseller-customer-list-container .customer-item').forEach(el => {
                if(el.dataset.key === resellerSaleCustomerSelect.value) {
                    el.classList.add('selected');
                } else {
                    el.classList.remove('selected');
                }
             });
        });
    }
    
    if (resellerPackageSelect) {
        resellerPackageSelect.addEventListener('change', updateResellerProfitPreview);
    }
    if (resellerSaleBalanceInput) {
        resellerSaleBalanceInput.addEventListener('input', updateResellerProfitPreview);
    }
    if (resellerSalePriceInput) {
        resellerSalePriceInput.addEventListener('input', updateResellerProfitPreview);
    }

    if (saveResellerSaleButton) {
        saveResellerSaleButton.addEventListener('click', saveResellerSale);
    }
}

function showCustomerSalesReport(whatsappNumber) {
    if (!whatsappNumber) {
        alert("এই কাস্টমারের কোনো WhatsApp নম্বর সেভ করা নেই।");
        return;
    }
    
    showPage('page-sales-report');

    const searchInput = document.getElementById('salesSearchInput');
    const searchBtn = document.getElementById('salesSearchBtn');
    const clearBtn = document.getElementById('clearFilterSalesButton');

    if (searchInput && searchBtn && clearBtn) {
        clearBtn.click();
        searchInput.value = whatsappNumber;
        searchBtn.click();
    } else {
        alert("সেলস রিপোর্ট পেজটি লোড করা যাচ্ছে না।");
    }
}


function loadResellerCustomers() {
    resellerCustomersRef.on('value', (snapshot) => {
        allResellerCustomers = [];
        if(resellerSaleCustomerSelect) resellerSaleCustomerSelect.innerHTML = '<option value="">-- প্রথমে কাস্টমার সিলেক্ট করুন --</option>'; 

        if (snapshot.exists()) {
            snapshot.forEach(child => {
                const customer = { key: child.key, ...child.val() };
                allResellerCustomers.push(customer);
                
                if (resellerSaleCustomerSelect) {
                    const option = document.createElement('option');
                    option.value = customer.key;
                    option.text = `${customer.name} (${customer.whatsapp})`;
                    resellerSaleCustomerSelect.appendChild(option);
                }
            });
        }
        allResellerCustomers.reverse(); 
        displayResellerCustomers(); 
    }, (error) => { 
        console.error("রিসেলার কাস্টমার লোড করতে সমস্যা:", error);
        if(resellerCustomerListContainer) resellerCustomerListContainer.innerHTML = '<p style="color:red;">কাস্টমার লোড করা যায়নি।</p>';
        if(resellerSaleCustomerSelect) resellerSaleCustomerSelect.innerHTML = '<option value="">-- লোড করা যায়নি --</option>';
    });
}

function displayResellerCustomers() {
    if (!resellerCustomerListContainer) return;
    resellerCustomerListContainer.innerHTML = '';
    const query = resellerCustomerSearchInput.value.toLowerCase();
    
    const customersToShow = allResellerCustomers.filter(customer => {
        return customer.name.toLowerCase().includes(query) || customer.whatsapp.includes(query);
    });

    if (customersToShow.length === 0) {
        resellerCustomerListContainer.innerHTML = '<p>কোনো কাস্টমার পাওয়া যায়নি।</p>';
        return;
    }

    customersToShow.forEach(customer => {
        const item = document.createElement('div');
        item.classList.add('customer-item'); 
        item.dataset.key = customer.key;
        item.innerHTML = `
            <div class="info">
                <span class="name">${customer.name}</span>
                <small class="whatsapp">${customer.whatsapp}</small>
                <small class="details">${customer.details || ''}</small>
            </div>
            <div class="actions">
                <button class="report-btn" data-key="${customer.key}" data-whatsapp="${customer.whatsapp}" title="সেলস রিপোর্ট দেখুন">📈</button>
                <button class="edit-btn" data-key="${customer.key}" title="এডিট করুন">✏️</button>
                <button class="delete-btn" data-key="${customer.key}" title="ডিলিট করুন">❌</button>
            </div>
        `;
        resellerCustomerListContainer.appendChild(item);
    });
}

function filterResellerCustomers() {
    displayResellerCustomers();
}

function saveResellerCustomer() {
    const key = resellerCustomerKeyInput.value;
    const name = resellerCustomerNameInput.value.trim();
    const whatsapp = resellerCustomerWhatsappInput.value.trim();
    const details = resellerCustomerDetailsInput.value.trim();

    if (!name || !whatsapp) {
        alert("অনুগ্রহ করে কাস্টমারের নাম এবং হোয়াটসঅ্যাপ নম্বর দিন।");
        return;
    }

    const customerData = {
        name: name,
        whatsapp: whatsapp,
        details: details
    };

    let promise;
    if (key) {
        promise = resellerCustomersRef.child(key).update(customerData);
    } else {
        promise = resellerCustomersRef.push(customerData);
    }

    promise.then(() => {
        showSuccessMessage(key ? "কাস্টমার আপডেট হয়েছে!" : "নতুন কাস্টমার যোগ হয়েছে!");
        clearResellerCustomerForm();
    }).catch(showError);
}

function selectResellerCustomerForEdit(key) {
    const customer = allResellerCustomers.find(c => c.key === key);
    if (customer) {
        resellerCustomerKeyInput.value = customer.key;
        resellerCustomerNameInput.value = customer.name;
        resellerCustomerWhatsappInput.value = customer.whatsapp;
        resellerCustomerDetailsInput.value = customer.details || '';
        document.getElementById('reseller-customer-form').scrollIntoView({ behavior: 'smooth' });
    }
}

function deleteResellerCustomer(key) {
    if (confirm("আপনি কি সত্যিই এই কাস্টমারকে ডিলিট করতে চান?")) {
        resellerCustomersRef.child(key).remove()
            .then(() => showSuccessMessage("কাস্টমার ডিলিট করা হয়েছে।"))
            .catch(showError);
    }
}

function clearResellerCustomerForm() {
    resellerCustomerKeyInput.value = '';
    resellerCustomerNameInput.value = '';
    resellerCustomerWhatsappInput.value = '';
    resellerCustomerDetailsInput.value = '';
}

function selectResellerCustomer(key) {
    if (resellerSaleCustomerSelect) {
        resellerSaleCustomerSelect.value = key;
        document.getElementById('reseller-sale-form').scrollIntoView({ behavior: 'smooth' });
    }
}

function loadPackagesForReseller() {
    packagesRef.on('value', (snapshot) => {
        allPackagesList = {}; 
        if(resellerPackageSelect) resellerPackageSelect.innerHTML = '<option value="">-- প্যাকেজ সিলেক্ট করুন --</option>';
        
        if (!snapshot.exists()) return;
        
        snapshot.forEach(childSnapshot => {
            const packageKey = childSnapshot.key;
            const packageData = childSnapshot.val();
            
            if (packageData.name && (packageData.isPublished === undefined || packageData.isPublished === true)) {
                allPackagesList[packageKey] = packageData; 
                
                const option = document.createElement('option');
                option.value = packageKey;
                option.text = `${packageData.name} (ক্রয়মূল্য: ৳${packageData.purchasePrice || 0}/মাস)`;
                if(resellerPackageSelect) resellerPackageSelect.appendChild(option);
            }
        });
    }, (error) => { 
        console.error("রিসেলারের জন্য প্যাকেজ লোড করতে সমস্যা:", error);
        if(resellerPackageSelect) resellerPackageSelect.innerHTML = '<option value="">-- প্যাকেজ লোডে ত্রুটি --</option>';
    });
}

function updateResellerProfitPreview() {
    const packageKey = resellerPackageSelect.value;
    const balanceSold = parseInt(resellerSaleBalanceInput.value) || 0;
    const salePrice = parseInt(resellerSalePriceInput.value) || 0;

    if (!packageKey || balanceSold <= 0) {
        if(resellerProfitPreview) resellerProfitPreview.classList.add('hidden');
        return;
    }

    const selectedPackage = allPackagesList[packageKey];
    if (!selectedPackage) {
        if(resellerProfitPreview) resellerProfitPreview.classList.add('hidden');
        return;
    }

    const purchasePricePerMonth = selectedPackage.purchasePrice || 0;
    const totalPurchaseCost = purchasePricePerMonth * balanceSold;
    const profit = salePrice - totalPurchaseCost;

    if(resellerPurchaseCostPreview) resellerPurchaseCostPreview.textContent = totalPurchaseCost;
    if(resellerProfitAmountPreview) resellerProfitAmountPreview.textContent = profit;
    if(resellerProfitPreview) resellerProfitPreview.classList.remove('hidden');
}

function saveResellerSale() {
    const customerKey = resellerSaleCustomerSelect.value; 
    const packageKey = resellerPackageSelect.value;
    const balanceSold = parseInt(resellerSaleBalanceInput.value);
    const salePrice = parseInt(resellerSalePriceInput.value);

    if (!customerKey) { alert("অনুগ্রহ করে একজন কাস্টমার সিলেক্ট করুন।"); return; }
    if (!packageKey) { alert("অনুগ্রহ করে একটি প্যাকেজ সিলেক্ট করুন।"); return; }
    if (isNaN(balanceSold) || balanceSold <= 0) { alert("অনুগ্রহ করে কত মাসের ব্যালেন্স সেল করছেন তা সঠিকভাবে লিখুন।"); return; }
    if (isNaN(salePrice) || salePrice < 0) { alert("অনুগ্রহ করে সঠিক বিক্রয় মূল্য লিখুন।"); return; }

    const selectedPackage = allPackagesList[packageKey];
    const selectedCustomer = allResellerCustomers.find(c => c.key === customerKey);
    
    if (!selectedPackage || !selectedCustomer) { alert("কাস্টমার বা প্যাকেজ খুঁজে পাওয়া যায়নি।"); return; }

    const purchasePricePerMonth = selectedPackage.purchasePrice || 0;
    const totalPurchaseCost = purchasePricePerMonth * balanceSold;
    const profit = salePrice - totalPurchaseCost;

    const saleData = {
        timestamp: firebase.database.ServerValue.TIMESTAMP,
        customerKey: customerKey, customerName: selectedCustomer.name, customerWhatsapp: selectedCustomer.whatsapp,
        packageKey: packageKey, packageName: selectedPackage.name,
        balanceSold: balanceSold, purchaseCost: totalPurchaseCost,
        salePrice: salePrice, profit: profit
    };

    const packageStockRef = packagesRef.child(packageKey).child('balance');
            
    packageStockRef.transaction((currentBalance) => {
        if (currentBalance === null || currentBalance === undefined) {
            return currentBalance; 
        }
        
        const currentStock = parseInt(currentBalance) || 0;
        if (currentStock < balanceSold) {
            return; 
        }
        
        return currentStock - balanceSold;

    }, (error, committed, snapshot) => {
        if (error) {
            showError({ message: "স্টক আপডেট করার সময় সমস্যা হয়েছে: " + error.message });
            return;
        }

        if (!committed) {
            showError({ message: `দুঃখিত, এই প্যাকেজের যথেষ্ট স্টক নেই। বর্তমান স্টক: ${snapshot.val()} | প্রয়োজন: ${balanceSold}` });
            return;
        }

        resellerSalesLogRef.push(saleData)
            .then(() => {
                showSuccessMessage("রিসেল সফলভাবে সেভ হয়েছে! স্টক আপডেট করা হয়েছে।");
                resellerSaleBalanceInput.value = '';
                resellerSalePriceInput.value = '';
                resellerPackageSelect.value = '';
                resellerSaleCustomerSelect.value = ''; 
                
                document.querySelectorAll('#reseller-customer-list-container .customer-item').forEach(el => el.classList.remove('selected'));
                if(resellerProfitPreview) resellerProfitPreview.classList.add('hidden'); 

            })
            .catch((pushError) => {
                showError(pushError);
                packageStockRef.transaction(current => (current || 0) + balanceSold); 
            });
    });
}


// --- অটো কাস্টমার সেলস ফাংশন ---

function initializeAutoCustomerListeners() {
    if (autoCustomerSearchInput) {
        autoCustomerSearchInput.addEventListener('input', filterRegularCustomers);
    }
    
    if (packageCustomerGroupsContainer) {
        packageCustomerGroupsContainer.addEventListener('click', (e) => {
            const item = e.target.closest('.customer-item'); 
            if (!item) return;

            if (e.target.classList.contains('report-btn')) {
                e.stopPropagation(); 
                showAutoCustomerSalesReport(e.target.dataset.whatsapp); 
            } 
            else {
                selectAutoCustomer(item.dataset.key);
                document.querySelectorAll('#package-customer-groups-container .customer-item').forEach(el => el.classList.remove('selected'));
                item.classList.add('selected');
            }
        });
    }
    
    if (autoSaleCustomerSelect) {
        autoSaleCustomerSelect.addEventListener('change', () => {
             document.querySelectorAll('#package-customer-groups-container .customer-item').forEach(el => {
                if(el.dataset.key === autoSaleCustomerSelect.value) {
                    el.classList.add('selected');
                } else {
                    el.classList.remove('selected');
                }
             });
        });
    }
    
    if (autoSalePackageSelect) {
        autoSalePackageSelect.addEventListener('change', updateAutoSaleProfitPreview);
    }
    if (autoSaleBalanceInput) {
        autoSaleBalanceInput.addEventListener('input', updateAutoSaleProfitPreview);
    }
    if (autoSalePriceInput) {
        autoSalePriceInput.addEventListener('input', updateAutoSaleProfitPreview);
    }

    if (saveAutoSaleButton) {
        saveAutoSaleButton.addEventListener('click', saveAutoSale);
    }
}

function showAutoCustomerSalesReport(whatsappNumber) {
    if (!whatsappNumber) {
        alert("এই কাস্টমারের কোনো WhatsApp নম্বর সেভ করা নেই।");
        return;
    }
    
    showPage('page-sales-report');

    const searchInput = document.getElementById('salesSearchInput');
    const searchBtn = document.getElementById('salesSearchBtn');
    const clearBtn = document.getElementById('clearFilterSalesButton');

    if (searchInput && searchBtn && clearBtn) {
        clearBtn.click();
        searchInput.value = whatsappNumber;
        searchBtn.click();
    } else {
        alert("সেলস রিপোর্ট পেজটি লোড করা যাচ্ছে না।");
    }
}

function loadRegularCustomers() {
    regularCustomersRef.on('value', (snapshot) => {
        allRegularCustomers = [];
        if(autoSaleCustomerSelect) autoSaleCustomerSelect.innerHTML = '<option value="">-- প্রথমে কাস্টমার সিলেক্ট করুন --</option>'; 

        if (snapshot.exists()) {
            snapshot.forEach(child => {
                const customer = { key: child.key, ...child.val() };
                allRegularCustomers.push(customer);
                
                if (autoSaleCustomerSelect) {
                    const option = document.createElement('option');
                    option.value = customer.key;
                    option.text = `${customer.name} (${customer.whatsapp})`;
                    autoSaleCustomerSelect.appendChild(option);
                }
            });
        }
        allRegularCustomers.reverse(); 
        displayRegularCustomers(); 
    }, (error) => { 
        console.error("অটো কাস্টমার লোড করতে সমস্যা:", error);
        if(packageCustomerGroupsContainer) packageCustomerGroupsContainer.innerHTML = '<p style="color:red;">কাস্টমার লোড করা যায়নি।</p>'; 
        if(autoSaleCustomerSelect) autoSaleCustomerSelect.innerHTML = '<option value="">-- লোড করা যায়নি --</option>';
    });
}

function displayRegularCustomers() {
    if (!packageCustomerGroupsContainer) return;
    
    packageCustomerGroupsContainer.innerHTML = '';

    const query = autoCustomerSearchInput ? autoCustomerSearchInput.value.toLowerCase() : '';
    
    const customersToShow = allRegularCustomers.filter(customer => {
        return (customer.name || "").toLowerCase().includes(query) || (customer.whatsapp || "").includes(query);
    });

    if (customersToShow.length === 0) {
        packageCustomerGroupsContainer.innerHTML = '<p>কোনো কাস্টমার পাওয়া যায়নি।</p>';
        return;
    }
    
    const listsByPackage = new Map();
    let totalCustomers = 0;

    customersToShow.forEach(customer => {
        const packageName = customer.packageName || "Unknown Package / No Sale Log";

        if (!listsByPackage.has(packageName)) {
            listsByPackage.set(packageName, []);
        }
        listsByPackage.get(packageName).push(customer);
        totalCustomers++;
    });

    const sortedPackageNames = Array.from(listsByPackage.keys()).sort();

    sortedPackageNames.forEach(packageName => {
        const customerList = listsByPackage.get(packageName);
        
        const detailsEl = document.createElement('details');
        detailsEl.classList.add('operator-group'); 
        
        const summaryEl = document.createElement('summary');
        summaryEl.innerHTML = `${packageName} <span class="package-count">(${customerList.length})</span>`;
        detailsEl.appendChild(summaryEl);
        
        const listInnerContainer = document.createElement('div');
        listInnerContainer.classList.add('customer-list-inner');
        
        renderCustomerListToContainer(customerList, listInnerContainer);
        
        detailsEl.appendChild(listInnerContainer);
        packageCustomerGroupsContainer.appendChild(detailsEl);
    });
}

function renderCustomerListToContainer(list, container) {
    if (!container) return;
    if (list.length === 0) {
        container.innerHTML = '<p>এই গ্রুপে কোনো কাস্টমার নেই।</p>';
        return;
    }
    list.forEach(customer => {
        const item = document.createElement('div');
        item.classList.add('customer-item'); 
        item.dataset.key = customer.key;
        item.innerHTML = `
            <div class="info">
                <span class="name">${customer.name}</span>
                <small class="whatsapp">${customer.whatsapp}</small>
                <small class="details">প্যাকেজ: ${customer.packageName || 'N/A'}</small>
            </div>
            <div class="actions">
                <button class="report-btn" data-key="${customer.key}" data-whatsapp="${customer.whatsapp}" title="সেলস রিপোর্ট দেখুন">📈</button>
            </div>
        `;
        container.appendChild(item);
    });
}


function filterRegularCustomers() {
    displayRegularCustomers();
}

function selectAutoCustomer(key) {
    if (autoSaleCustomerSelect) {
        autoSaleCustomerSelect.value = key;
        document.getElementById('auto-customer-sale-form').scrollIntoView({ behavior: 'smooth' });
    }
}

function loadPackagesForAutoCustomerSale() {
    packagesRef.on('value', (snapshot) => {
        
        if(autoSalePackageSelect) autoSalePackageSelect.innerHTML = '<option value="">-- প্যাকেজ সিলেক্ট করুন --</option>';
        
        if (!snapshot.exists()) return;
        
        snapshot.forEach(childSnapshot => {
            const packageKey = childSnapshot.key;
            const packageData = childSnapshot.val();
            
            if (packageData.name && (packageData.isPublished === undefined || packageData.isPublished === true)) {
                
                const option = document.createElement('option');
                option.value = packageKey;
                option.text = `${packageData.name} (ক্রয়মূল্য: ৳${packageData.purchasePrice || 0}/মাস)`;
                if(autoSalePackageSelect) autoSalePackageSelect.appendChild(option);
            }
        });
    }, (error) => { 
        console.error("অটো-কাস্টমার সেলের জন্য প্যাকেজ লোড করতে সমস্যা:", error);
        if(autoSalePackageSelect) autoSalePackageSelect.innerHTML = '<option value="">-- প্যাকেজ লোডে ত্রুটি --</option>';
    });
}

function updateAutoSaleProfitPreview() {
    const packageKey = autoSalePackageSelect.value;
    const balanceSold = parseInt(autoSaleBalanceInput.value) || 0;
    const salePrice = parseInt(autoSalePriceInput.value) || 0;

    if (!packageKey || balanceSold <= 0) {
        if(autoProfitPreview) autoProfitPreview.classList.add('hidden');
        return;
    }

    const selectedPackage = allPackagesList[packageKey]; 
    if (!selectedPackage) {
        if(autoProfitPreview) autoProfitPreview.classList.add('hidden');
        return;
    }

    const purchasePricePerMonth = selectedPackage.purchasePrice || 0;
    const totalPurchaseCost = purchasePricePerMonth * balanceSold;
    const profit = salePrice - totalPurchaseCost;

    if(autoPurchaseCostPreview) autoPurchaseCostPreview.textContent = totalPurchaseCost;
    if(autoProfitAmountPreview) autoProfitAmountPreview.textContent = profit;
    if(autoProfitPreview) autoProfitPreview.classList.remove('hidden');
}

function saveAutoSale() {
    const customerKey = autoSaleCustomerSelect.value; 
    const packageKey = autoSalePackageSelect.value;
    const balanceSold = parseInt(autoSaleBalanceInput.value); 
    const salePrice = parseInt(autoSalePriceInput.value); 

    if (!customerKey) { alert("অনুগ্রহ করে একজন কাস্টমার সিলেক্ট করুন।"); return; }
    if (!packageKey) { alert("অনুগ্রহ করে একটি প্যাকেজ সিলেক্ট করুন।"); return; }
    if (isNaN(balanceSold) || balanceSold <= 0) { alert("অনুগ্রহ করে কত মাসের ব্যালেন্স সেল করছেন তা সঠিকভাবে লিখুন।"); return; }
    if (isNaN(salePrice) || salePrice < 0) { alert("অনুগ্রহ করে সঠিক বিক্রয় মূল্য লিখুন।"); return; }

    const selectedPackage = allPackagesList[packageKey]; 
    const selectedCustomer = allRegularCustomers.find(c => c.key === customerKey);
    
    if (!selectedPackage || !selectedCustomer) { alert("কাস্টমার বা প্যাকেজ খুঁজে পাওয়া যায়নি।"); return; }

    const purchasePricePerMonth = selectedPackage.purchasePrice || 0;
    const totalPurchaseCost = purchasePricePerMonth * balanceSold;
    
    const saleData = {
        timestamp: firebase.database.ServerValue.TIMESTAMP,
        packageName: selectedPackage.name,
        username: selectedCustomer.name, 
        duration: `${balanceSold} মাস (অটো সেল)`, 
        amount: salePrice,
        purchaseCost: totalPurchaseCost, 
        trxId: "Admin Auto-Sale",
        device: "Admin Panel",
        paymentMethod: "Admin",
        customerWhatsapp: selectedCustomer.whatsapp
    };

    const packageStockRef = packagesRef.child(packageKey).child('balance');
            
    packageStockRef.transaction((currentBalance) => {
        if (currentBalance === null || currentBalance === undefined) {
            return currentBalance; 
        }
        
        const currentStock = parseInt(currentBalance) || 0;
        if (currentStock < balanceSold) {
            return; 
        }
        
        return currentStock - balanceSold;

    }, (error, committed, snapshot) => {
        if (error) {
            showError({ message: "স্টক আপডেট করার সময় সমস্যা হয়েছে: " + error.message });
            return;
        }

        if (!committed) {
            showError({ message: `দুঃখিত, এই প্যাকেজের যথেষ্ট স্টক নেই। বর্তমান স্টক: ${snapshot.val()} | প্রয়োজন: ${balanceSold}` });
            return;
        }

        salesLogRef.push(saleData)
            .then(() => {
                showSuccessMessage("সাধারণ সেলস সফলভাবে সেভ হয়েছে! স্টক আপডেট করা হয়েছে।");
                
                const today_bdt = getBdtDateString(Date.now() + serverOffset);
                visitCountsRef.child('lastResetDate').once("value", (snap) => {
                    if (snap.val() === today_bdt) {
                        visitCountsRef.child('todaySales').transaction(current => (current || 0) + salePrice);
                        visitCountsRef.child('todayOrders').transaction(current => (current || 0) + 1);
                    } else {
                        visitCountsRef.update({
                            todaySales: salePrice,
                            todayOrders: 1,
                            lastResetDate: today_bdt
                        });
                    }
                });
                
                autoSaleBalanceInput.value = '';
                autoSalePriceInput.value = '';
                autoSalePackageSelect.value = '';
                autoSaleCustomerSelect.value = ''; 
                
                document.querySelectorAll('#package-customer-groups-container .customer-item').forEach(el => el.classList.remove('selected'));
                if(autoProfitPreview) autoProfitPreview.classList.add('hidden'); 

            })
            .catch((pushError) => {
                showError(pushError);
                packageStockRef.transaction(current => (current || 0) + balanceSold); 
            });
    });
}

// --- সাধারণ নেভিগেশন ও মেসেজ ---
function showPage(pageId) {
    editorPages.forEach(page => page.classList.add('hidden'));
    if(mainMenu) mainMenu.classList.add('hidden');
    
    if (pageId) {
        const pageToShow = document.getElementById(pageId);
        if (pageToShow) {
            pageToShow.classList.remove('hidden');
        }
    }
}
menuButtons.forEach(button => {
    button.addEventListener('click', () => {
        const targetPage = button.dataset.target; 
        showPage(targetPage);
    });
});
backButtons.forEach(button => {
    button.addEventListener('click', () => {
        showPage('main-menu'); 
    });
});

function showSuccessMessage(message) {
    if(!successMessage) return;
    successMessage.textContent = message;
    setTimeout(() => { successMessage.textContent = ""; }, 3000); 
}

function showError(error) {
    if(!errorMessage) return;
    const combinedMessage = "একটি সমস্যা হয়েছে: " + (error.message || error);
    errorMessage.textContent = combinedMessage;
    console.error(error);
}

if(document.getElementById('clearAppFormButton')) {
    document.getElementById('clearAppFormButton').addEventListener('click', clearAppForm);
}
if(document.getElementById('clearFaqFormButton')) { 
    document.getElementById('clearFaqFormButton').addEventListener('click', clearFaqForm);
}
